/**
 * <copyright>
 * </copyright>
 *
 * $Id: AnnotationsModelSwitch.java,v 1.7 2010/03/07 19:25:14 mtaal Exp $
 */
package org.eclipse.emf.texo.annotations.annotationsmodel.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsModelPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.EAttributeAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EClassAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EClassifierAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EDataTypeAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EEnumAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EPackageAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EReferenceAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EStructuralFeatureAnnotation;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance hierarchy. It supports the
 * call {@link #doSwitch(EObject) doSwitch(object)} to invoke the <code>caseXXX</code> method for
 * each class of the model, starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsModelPackage
 * @generated
 */
public class AnnotationsModelSwitch<T> {
  /**
   * The cached model package
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected static AnnotationsModelPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public AnnotationsModelSwitch() {
    if (modelPackage == null) {
      modelPackage = AnnotationsModelPackage.eINSTANCE;
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  public T doSwitch(EObject theEObject) {
    return doSwitch(theEObject.eClass(), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(EClass theEClass, EObject theEObject) {
    if (theEClass.eContainer() == modelPackage) {
      return doSwitch(theEClass.getClassifierID(), theEObject);
    }
    else {
      List<EClass> eSuperTypes = theEClass.getESuperTypes();
      return
        eSuperTypes.isEmpty() ?
          defaultCase(theEObject) :
          doSwitch(eSuperTypes.get(0), theEObject);
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(int classifierID, EObject theEObject) {
    switch (classifierID) {
      case AnnotationsModelPackage.ENAMED_ELEMENT_ANNOTATION: {
        ENamedElementAnnotation eNamedElementAnnotation = (ENamedElementAnnotation)theEObject;
        T result = caseENamedElementAnnotation(eNamedElementAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.ECLASSIFIER_ANNOTATION: {
        EClassifierAnnotation eClassifierAnnotation = (EClassifierAnnotation)theEObject;
        T result = caseEClassifierAnnotation(eClassifierAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eClassifierAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.ECLASS_ANNOTATION: {
        EClassAnnotation eClassAnnotation = (EClassAnnotation)theEObject;
        T result = caseEClassAnnotation(eClassAnnotation);
        if (result == null) result = caseEClassifierAnnotation(eClassAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eClassAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.EDATA_TYPE_ANNOTATION: {
        EDataTypeAnnotation eDataTypeAnnotation = (EDataTypeAnnotation)theEObject;
        T result = caseEDataTypeAnnotation(eDataTypeAnnotation);
        if (result == null) result = caseEClassifierAnnotation(eDataTypeAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eDataTypeAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.ESTRUCTURAL_FEATURE_ANNOTATION: {
        EStructuralFeatureAnnotation eStructuralFeatureAnnotation = (EStructuralFeatureAnnotation)theEObject;
        T result = caseEStructuralFeatureAnnotation(eStructuralFeatureAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eStructuralFeatureAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.EPACKAGE_ANNOTATION: {
        EPackageAnnotation ePackageAnnotation = (EPackageAnnotation)theEObject;
        T result = caseEPackageAnnotation(ePackageAnnotation);
        if (result == null) result = caseENamedElementAnnotation(ePackageAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.EREFERENCE_ANNOTATION: {
        EReferenceAnnotation eReferenceAnnotation = (EReferenceAnnotation)theEObject;
        T result = caseEReferenceAnnotation(eReferenceAnnotation);
        if (result == null) result = caseEStructuralFeatureAnnotation(eReferenceAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eReferenceAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.EATTRIBUTE_ANNOTATION: {
        EAttributeAnnotation eAttributeAnnotation = (EAttributeAnnotation)theEObject;
        T result = caseEAttributeAnnotation(eAttributeAnnotation);
        if (result == null) result = caseEStructuralFeatureAnnotation(eAttributeAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eAttributeAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case AnnotationsModelPackage.EENUM_ANNOTATION: {
        EEnumAnnotation eEnumAnnotation = (EEnumAnnotation)theEObject;
        T result = caseEEnumAnnotation(eEnumAnnotation);
        if (result == null) result = caseEDataTypeAnnotation(eEnumAnnotation);
        if (result == null) result = caseEClassifierAnnotation(eEnumAnnotation);
        if (result == null) result = caseENamedElementAnnotation(eEnumAnnotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>ENamed Element Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null;
   * returning a non-null result will terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>ENamed Element Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseENamedElementAnnotation(ENamedElementAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EClassifier Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null;
   * returning a non-null result will terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EClassifier Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEClassifierAnnotation(EClassifierAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EClass Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
   * terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EClass Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEClassAnnotation(EClassAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EStructural Feature Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns
   * null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EStructural Feature Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEStructuralFeatureAnnotation(EStructuralFeatureAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EPackage Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
   * terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EPackage Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEPackageAnnotation(EPackageAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EData Type Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
   * terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EData Type Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEDataTypeAnnotation(EDataTypeAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EReference Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
   * terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EReference Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEReferenceAnnotation(EReferenceAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EAttribute Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
   * terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EAttribute Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEAttributeAnnotation(EAttributeAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EEnum Annotation</em>'.
   * <!-- begin-user-doc --> This implementation returns null; returning a non-null result will
   * terminate the switch. <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EEnum Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEEnumAnnotation(EEnumAnnotation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'. <!--
   * begin-user-doc --> This implementation returns null; returning a non-null result will terminate
   * the switch, but this is the last case anyway. <!-- end-user-doc -->
   * 
   * @param object
   *          the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  public T defaultCase(EObject object) {
    return null;
  }

} // AnnotationsModelSwitch
