/**
 * <copyright>
 * </copyright>
 *
 * $Id: AnnotationsmodelItemProviderAdapterFactory.java,v 1.6 2011/09/23 20:59:43 mtaal Exp $
 */
package org.eclipse.emf.texo.annotations.annotationsmodel.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.texo.annotations.annotationsmodel.util.AnnotationsmodelAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The adapters generated by this
 * factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support Eclipse property sheets. Note that most of the adapters are shared among multiple instances. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class AnnotationsmodelItemProviderAdapterFactory extends AnnotationsmodelAdapterFactory implements
    ComposeableAdapterFactory, IChangeNotifier, IDisposable {
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public AnnotationsmodelItemProviderAdapterFactory() {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EClassAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EClassAnnotationItemProvider eClassAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EClassAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEClassAnnotationAdapter() {
    if (eClassAnnotationItemProvider == null) {
      eClassAnnotationItemProvider = new EClassAnnotationItemProvider(this);
    }

    return eClassAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EDataTypeAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EDataTypeAnnotationItemProvider eDataTypeAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EDataTypeAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEDataTypeAnnotationAdapter() {
    if (eDataTypeAnnotationItemProvider == null) {
      eDataTypeAnnotationItemProvider = new EDataTypeAnnotationItemProvider(this);
    }

    return eDataTypeAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EPackageAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EPackageAnnotationItemProvider ePackageAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EPackageAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEPackageAnnotationAdapter() {
    if (ePackageAnnotationItemProvider == null) {
      ePackageAnnotationItemProvider = new EPackageAnnotationItemProvider(this);
    }

    return ePackageAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EReferenceAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EReferenceAnnotationItemProvider eReferenceAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EReferenceAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEReferenceAnnotationAdapter() {
    if (eReferenceAnnotationItemProvider == null) {
      eReferenceAnnotationItemProvider = new EReferenceAnnotationItemProvider(this);
    }

    return eReferenceAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EAttributeAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EAttributeAnnotationItemProvider eAttributeAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EAttributeAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEAttributeAnnotationAdapter() {
    if (eAttributeAnnotationItemProvider == null) {
      eAttributeAnnotationItemProvider = new EAttributeAnnotationItemProvider(this);
    }

    return eAttributeAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EEnumAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EEnumAnnotationItemProvider eEnumAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EEnumAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEEnumAnnotationAdapter() {
    if (eEnumAnnotationItemProvider == null) {
      eEnumAnnotationItemProvider = new EEnumAnnotationItemProvider(this);
    }

    return eEnumAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.EEnumLiteralAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EEnumLiteralAnnotationItemProvider eEnumLiteralAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.EEnumLiteralAnnotation}.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEEnumLiteralAnnotationAdapter() {
    if (eEnumLiteralAnnotationItemProvider == null) {
      eEnumLiteralAnnotationItemProvider = new EEnumLiteralAnnotationItemProvider(this);
    }

    return eEnumLiteralAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClass} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected AnnotatedEClassItemProvider annotatedEClassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClass}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEClassAdapter() {
    if (annotatedEClassItemProvider == null) {
      annotatedEClassItemProvider = new AnnotatedEClassItemProvider(this);
    }

    return annotatedEClassItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEPackage} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected AnnotatedEPackageItemProvider annotatedEPackageItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEPackage}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEPackageAdapter() {
    if (annotatedEPackageItemProvider == null) {
      annotatedEPackageItemProvider = new AnnotatedEPackageItemProvider(this);
    }

    return annotatedEPackageItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEDataType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected AnnotatedEDataTypeItemProvider annotatedEDataTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEDataType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEDataTypeAdapter() {
    if (annotatedEDataTypeItemProvider == null) {
      annotatedEDataTypeItemProvider = new AnnotatedEDataTypeItemProvider(this);
    }

    return annotatedEDataTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected AnnotatedModelItemProvider annotatedModelItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedModelAdapter() {
    if (annotatedModelItemProvider == null) {
      annotatedModelItemProvider = new AnnotatedModelItemProvider(this);
    }

    return annotatedModelItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnum} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected AnnotatedEEnumItemProvider annotatedEEnumItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnum}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEEnumAdapter() {
    if (annotatedEEnumItemProvider == null) {
      annotatedEEnumItemProvider = new AnnotatedEEnumItemProvider(this);
    }

    return annotatedEEnumItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEReference} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected AnnotatedEReferenceItemProvider annotatedEReferenceItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEReference}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEReferenceAdapter() {
    if (annotatedEReferenceItemProvider == null) {
      annotatedEReferenceItemProvider = new AnnotatedEReferenceItemProvider(this);
    }

    return annotatedEReferenceItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEAttribute} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected AnnotatedEAttributeItemProvider annotatedEAttributeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEAttribute}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEAttributeAdapter() {
    if (annotatedEAttributeItemProvider == null) {
      annotatedEAttributeItemProvider = new AnnotatedEAttributeItemProvider(this);
    }

    return annotatedEAttributeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnumLiteral} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected AnnotatedEEnumLiteralItemProvider annotatedEEnumLiteralItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnumLiteral}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createAnnotatedEEnumLiteralAdapter() {
    if (annotatedEEnumLiteralItemProvider == null) {
      annotatedEEnumLiteralItemProvider = new AnnotatedEEnumLiteralItemProvider(this);
    }

    return annotatedEEnumLiteralItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public ComposeableAdapterFactory getRootAdapterFactory() {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object type) {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type) {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type) {
    if (isFactoryForType(type)) {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
        return adapter;
      }
    }

    return null;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void addListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  public void fireNotifyChanged(Notification notification) {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null) {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory. 
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void dispose() {
    if (eClassAnnotationItemProvider != null) eClassAnnotationItemProvider.dispose();
    if (eDataTypeAnnotationItemProvider != null) eDataTypeAnnotationItemProvider.dispose();
    if (ePackageAnnotationItemProvider != null) ePackageAnnotationItemProvider.dispose();
    if (eReferenceAnnotationItemProvider != null) eReferenceAnnotationItemProvider.dispose();
    if (eAttributeAnnotationItemProvider != null) eAttributeAnnotationItemProvider.dispose();
    if (eEnumAnnotationItemProvider != null) eEnumAnnotationItemProvider.dispose();
    if (eEnumLiteralAnnotationItemProvider != null) eEnumLiteralAnnotationItemProvider.dispose();
    if (annotatedEClassItemProvider != null) annotatedEClassItemProvider.dispose();
    if (annotatedEPackageItemProvider != null) annotatedEPackageItemProvider.dispose();
    if (annotatedEDataTypeItemProvider != null) annotatedEDataTypeItemProvider.dispose();
    if (annotatedModelItemProvider != null) annotatedModelItemProvider.dispose();
    if (annotatedEEnumItemProvider != null) annotatedEEnumItemProvider.dispose();
    if (annotatedEReferenceItemProvider != null) annotatedEReferenceItemProvider.dispose();
    if (annotatedEAttributeItemProvider != null) annotatedEAttributeItemProvider.dispose();
    if (annotatedEEnumLiteralItemProvider != null) annotatedEEnumLiteralItemProvider.dispose();
  }

}
