/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.annotations.annotationsmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.texo.annotations.AnnotationModelSuffixHandler;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEAttribute;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClass;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClassifier;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEDataType;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnum;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnumLiteral;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedENamedElement;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEReference;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEStructuralFeature;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsmodelFactory;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsmodelPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.EAttributeAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EClassAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EDataTypeAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EEnumAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EEnumLiteralAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EPackageAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EReferenceAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.util.AnnotationsModelRegistry;

public class AnnotatedModel
extends EObjectImpl
implements EObject {
    protected EList<AnnotatedEPackage> annotatedEPackages;
    protected static final boolean GENERATING_SOURCES_EDEFAULT = false;
    protected boolean generatingSources = false;
    protected List<EPackage> readAnnotationModelEPackages = new ArrayList<EPackage>();

    protected AnnotatedModel() {
    }

    protected EClass eStaticClass() {
        return AnnotationsmodelPackage.Literals.ANNOTATED_MODEL;
    }

    public EList<AnnotatedEPackage> getAnnotatedEPackages() {
        if (this.annotatedEPackages == null) {
            this.annotatedEPackages = new EObjectContainmentWithInverseEList(AnnotatedEPackage.class, (InternalEObject)this, 0, 4);
        }
        return this.annotatedEPackages;
    }

    public boolean isGeneratingSources() {
        return this.generatingSources;
    }

    public void setGeneratingSources(boolean newGeneratingSources) {
        boolean oldGeneratingSources = this.generatingSources;
        this.generatingSources = newGeneratingSources;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldGeneratingSources, this.generatingSources));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatedEPackages()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatedEPackages()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatedEPackages();
            }
            case 1: {
                return this.isGeneratingSources();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatedEPackages().clear();
                this.getAnnotatedEPackages().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setGeneratingSources((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatedEPackages().clear();
                return;
            }
            case 1: {
                this.setGeneratingSources(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatedEPackages != null && !this.annotatedEPackages.isEmpty();
            }
            case 1: {
                return this.generatingSources;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (generatingSources: ");
        result.append(this.generatingSources);
        result.append(')');
        return result.toString();
    }

    public AnnotatedENamedElement getAnnotatedENamedElement(ENamedElement eNamedElement, boolean create) {
        if (eNamedElement instanceof EPackage) {
            return this.getAnnotatedEPackage((EPackage)eNamedElement, create);
        }
        if (eNamedElement instanceof EClass) {
            return this.getAnnotatedEClass((EClass)eNamedElement, create);
        }
        if (eNamedElement instanceof EEnum) {
            return this.getAnnotatedEEnum((EEnum)eNamedElement, create);
        }
        if (eNamedElement instanceof EEnumLiteral) {
            return this.getAnnotatedEEnumLiteral((EEnumLiteral)eNamedElement, create);
        }
        if (eNamedElement instanceof EDataType) {
            return this.getAnnotatedEDataType((EDataType)eNamedElement, create);
        }
        if (eNamedElement instanceof EReference) {
            return this.getAnnotatedEReference((EReference)eNamedElement, create);
        }
        if (eNamedElement instanceof EAttribute) {
            return this.getAnnotatedEAttribute((EAttribute)eNamedElement, create);
        }
        throw new IllegalArgumentException("EModelElement " + eNamedElement + " not supported here");
    }

    public AnnotatedEPackage getAnnotatedEPackage(EPackage ePackage, boolean create) {
        if (ePackage == null) {
            return null;
        }
        for (AnnotatedEPackage aPackage : this.getAnnotatedEPackages()) {
            if (aPackage.getEPackage() != ePackage) continue;
            return aPackage;
        }
        if (!this.readAnnotationModelEPackages.contains(ePackage) && ePackage.eResource() != null && ePackage.eResource().getURI() != null) {
            this.readAnnotationModelEPackages.add(ePackage);
            ResourceSet resourceSet = ePackage.eResource().getResourceSet();
            if (resourceSet != null) {
                for (EPackage annotationModelPackage : AnnotationsModelRegistry.getInstance().getAnnotationModels()) {
                    resourceSet.getPackageRegistry().put((Object)annotationModelPackage.getNsURI(), (Object)annotationModelPackage);
                }
                this.readAnnotatedModel(ePackage, resourceSet);
                return this.getAnnotatedEPackage(ePackage, create);
            }
        }
        if (create) {
            AnnotatedEPackage aPackage;
            aPackage = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEPackage();
            aPackage.setEPackage(ePackage);
            this.getAnnotatedEPackages().add((Object)aPackage);
            return aPackage;
        }
        return null;
    }

    protected void readAnnotatedModel(EPackage ePackage, ResourceSet resourceSet) {
        URI uri = ePackage.eResource().getURI();
        for (String suffix : AnnotationModelSuffixHandler.getInstance().getSuffixes()) {
            boolean resourcePresent = false;
            try {
                URI annotationsModelURI = AnnotationModelSuffixHandler.createAnnotationsModelURIWithSuffix(uri, suffix);
                Resource res = resourceSet.getResource(annotationsModelURI, true);
                TreeIterator iterator = res.getAllContents();
                resourcePresent = true;
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (!(eObject instanceof AnnotatedEPackage)) continue;
                    this.mergeAnnotatedEPackage((AnnotatedEPackage)EcoreUtil.copy((EObject)eObject));
                }
            }
            catch (Exception e) {
                if (!resourcePresent) continue;
                throw new IllegalStateException(e);
            }
        }
    }

    protected void mergeAnnotatedEPackage(AnnotatedEPackage sourceAPackage) {
        AnnotatedEPackage targetAPackage = this.getAnnotatedEPackage(sourceAPackage.getEPackage(), true);
        if (targetAPackage == null) {
            return;
        }
        for (EPackageAnnotation ePackageAnnotation : new ArrayList<EPackageAnnotation>((Collection<EPackageAnnotation>)sourceAPackage.getEPackageAnnotations())) {
            if (this.hasAnnotation((List<?>)targetAPackage.getEPackageAnnotations(), ePackageAnnotation)) continue;
            targetAPackage.getEPackageAnnotations().add((Object)ePackageAnnotation);
        }
        for (AnnotatedEClassifier aClassifier : sourceAPackage.getAnnotatedEClassifiers()) {
            if (aClassifier instanceof AnnotatedEClass) {
                this.mergeAnnotatedEClass((AnnotatedEClass)aClassifier);
                continue;
            }
            if (aClassifier instanceof AnnotatedEEnum) {
                this.mergeAnnotatedEEnum((AnnotatedEEnum)aClassifier);
                continue;
            }
            this.mergeAnnotatedEDataType((AnnotatedEDataType)aClassifier);
        }
    }

    private void mergeAnnotatedEEnum(AnnotatedEEnum sourceAEnum) {
        AnnotatedEEnum targetAEnum = this.getAnnotatedEEnum(sourceAEnum.getEEnum(), true);
        if (targetAEnum == null) {
            return;
        }
        for (EEnumAnnotation eEnumAnnotation : new ArrayList<EEnumAnnotation>((Collection<EEnumAnnotation>)sourceAEnum.getEEnumAnnotations())) {
            if (this.hasAnnotation(targetAEnum.getAllAnnotations(), eEnumAnnotation)) continue;
            targetAEnum.getEEnumAnnotations().add((Object)eEnumAnnotation);
        }
        for (AnnotatedEEnumLiteral sourceALiteral : sourceAEnum.getAnnotatedEEnumLiterals()) {
            AnnotatedEEnumLiteral targetALiteral = this.getAnnotatedEEnumLiteral(sourceALiteral.getEEnumLiteral(), true);
            for (EEnumLiteralAnnotation eLiteralAnnotation : new ArrayList<EEnumLiteralAnnotation>((Collection<EEnumLiteralAnnotation>)sourceALiteral.getEEnumLiteralAnnotations())) {
                if (this.hasAnnotation(targetALiteral.getAllAnnotations(), eLiteralAnnotation)) continue;
                targetALiteral.getEEnumLiteralAnnotations().add((Object)eLiteralAnnotation);
            }
        }
    }

    private void mergeAnnotatedEDataType(AnnotatedEDataType sourceADataType) {
        AnnotatedEDataType targetADataType = this.getAnnotatedEDataType(sourceADataType.getEDataType(), true);
        if (targetADataType == null) {
            return;
        }
        for (EDataTypeAnnotation eDataTypeAnnotation : new ArrayList<EDataTypeAnnotation>((Collection<EDataTypeAnnotation>)sourceADataType.getEDataTypeAnnotations())) {
            if (this.hasAnnotation(targetADataType.getAllAnnotations(), eDataTypeAnnotation)) continue;
            targetADataType.getEDataTypeAnnotations().add((Object)eDataTypeAnnotation);
        }
    }

    private void mergeAnnotatedEClass(AnnotatedEClass sourceAClass) {
        AnnotatedEClass targetAClass = this.getAnnotatedEClass(sourceAClass.getEClass(), true);
        if (targetAClass == null) {
            return;
        }
        for (EClassAnnotation eClassAnnotation : new ArrayList<EClassAnnotation>((Collection<EClassAnnotation>)sourceAClass.getEClassAnnotations())) {
            if (this.hasAnnotation(targetAClass.getAllAnnotations(), eClassAnnotation)) continue;
            targetAClass.getEClassAnnotations().add((Object)eClassAnnotation);
        }
        for (AnnotatedEStructuralFeature aFeature : sourceAClass.getAnnotatedEStructuralFeatures()) {
            if (aFeature instanceof AnnotatedEReference) {
                AnnotatedEReference sourceAReference = (AnnotatedEReference)aFeature;
                AnnotatedEReference targetAReference = this.getAnnotatedEReference(sourceAReference.getEReference(), true);
                if (targetAReference == null) continue;
                for (EReferenceAnnotation eReferenceAnnotation : new ArrayList<EReferenceAnnotation>((Collection<EReferenceAnnotation>)sourceAReference.getEReferenceAnnotations())) {
                    if (this.hasAnnotation((List<?>)targetAReference.getEReferenceAnnotations(), eReferenceAnnotation)) continue;
                    targetAReference.getEReferenceAnnotations().add((Object)eReferenceAnnotation);
                }
                continue;
            }
            AnnotatedEAttribute sourceAAttribute = (AnnotatedEAttribute)aFeature;
            AnnotatedEAttribute targetAAttribute = this.getAnnotatedEAttribute(sourceAAttribute.getEAttribute(), true);
            if (targetAAttribute == null) continue;
            for (EAttributeAnnotation eAttributeAnnotation : new ArrayList<EAttributeAnnotation>((Collection<EAttributeAnnotation>)sourceAAttribute.getEAttributeAnnotations())) {
                if (this.hasAnnotation((List<?>)targetAAttribute.getEAttributeAnnotations(), eAttributeAnnotation)) continue;
                targetAAttribute.getEAttributeAnnotations().add((Object)eAttributeAnnotation);
            }
        }
    }

    private boolean hasAnnotation(List<?> annotations, ENamedElementAnnotation annotation) {
        for (Object annObject : annotations) {
            ENamedElementAnnotation elementAnnotation = (ENamedElementAnnotation)((Object)annObject);
            if (elementAnnotation.eClass() != annotation.eClass()) continue;
            return true;
        }
        return false;
    }

    public AnnotatedEClass getAnnotatedEClass(EClass eClass, boolean create) {
        if (eClass == null) {
            return null;
        }
        AnnotatedEPackage aPackage = this.getAnnotatedEPackage(eClass.getEPackage(), create);
        if (aPackage == null) {
            return null;
        }
        for (AnnotatedEClassifier aClassifier : aPackage.getAnnotatedEClassifiers()) {
            AnnotatedEClass aClass;
            if (!(aClassifier instanceof AnnotatedEClass) || (aClass = (AnnotatedEClass)aClassifier).getEClass() != eClass) continue;
            return aClass;
        }
        if (create) {
            AnnotatedEClass aClass = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEClass();
            aPackage.getAnnotatedEClassifiers().add((Object)aClass);
            aClass.setEClass(eClass);
            return aClass;
        }
        return null;
    }

    public AnnotatedEClassifier getAnnotatedEClassifier(EClassifier eClassifier, boolean create) {
        if (eClassifier instanceof EClass) {
            return this.getAnnotatedEClass((EClass)eClassifier, create);
        }
        if (eClassifier instanceof EEnum) {
            return this.getAnnotatedEEnum((EEnum)eClassifier, create);
        }
        return this.getAnnotatedEDataType((EDataType)eClassifier, create);
    }

    public AnnotatedEDataType getAnnotatedEDataType(EDataType eDataType, boolean create) {
        if (eDataType == null) {
            return null;
        }
        AnnotatedEPackage aPackage = this.getAnnotatedEPackage(eDataType.getEPackage(), create);
        if (aPackage == null) {
            return null;
        }
        for (AnnotatedEClassifier aClassifier : aPackage.getAnnotatedEClassifiers()) {
            AnnotatedEDataType aDataType;
            if (!(aClassifier instanceof AnnotatedEDataType) || (aDataType = (AnnotatedEDataType)aClassifier).getEDataType() != eDataType) continue;
            return aDataType;
        }
        if (create) {
            AnnotatedEDataType aDataType = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEDataType();
            aPackage.getAnnotatedEClassifiers().add((Object)aDataType);
            aDataType.setEDataType(eDataType);
            return aDataType;
        }
        return null;
    }

    public AnnotatedEEnum getAnnotatedEEnum(EEnum eEnum, boolean create) {
        if (eEnum == null) {
            return null;
        }
        AnnotatedEPackage aPackage = this.getAnnotatedEPackage(eEnum.getEPackage(), create);
        if (aPackage == null) {
            return null;
        }
        for (AnnotatedEClassifier aClassifier : aPackage.getAnnotatedEClassifiers()) {
            AnnotatedEEnum aEnum;
            if (!(aClassifier instanceof AnnotatedEEnum) || (aEnum = (AnnotatedEEnum)aClassifier).getEEnum() != eEnum) continue;
            return aEnum;
        }
        if (create) {
            AnnotatedEEnum aEnum = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEEnum();
            aPackage.getAnnotatedEClassifiers().add((Object)aEnum);
            aEnum.setEEnum(eEnum);
            return aEnum;
        }
        return null;
    }

    public AnnotatedEEnumLiteral getAnnotatedEEnumLiteral(EEnumLiteral eEnumLiteral, boolean create) {
        if (eEnumLiteral == null) {
            return null;
        }
        AnnotatedEEnum aEnum = this.getAnnotatedEEnum(eEnumLiteral.getEEnum(), create);
        for (AnnotatedEEnumLiteral aLiteral : aEnum.getAnnotatedEEnumLiterals()) {
            if (!aLiteral.getEEnumLiteral().equals(eEnumLiteral)) continue;
            return aLiteral;
        }
        if (create) {
            AnnotatedEEnumLiteral aLiteral;
            aLiteral = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEEnumLiteral();
            aEnum.getAnnotatedEEnumLiterals().add((Object)aLiteral);
            aLiteral.setEEnumLiteral(eEnumLiteral);
            return aLiteral;
        }
        return null;
    }

    public AnnotatedEReference getAnnotatedEReference(EReference eReference, boolean create) {
        if (eReference.getEContainingClass() == null) {
            return null;
        }
        AnnotatedEClass aClass = this.getAnnotatedEClass(eReference.getEContainingClass(), create);
        if (aClass == null) {
            return null;
        }
        for (AnnotatedEStructuralFeature aFeature : aClass.getAnnotatedEStructuralFeatures()) {
            AnnotatedEReference aReference;
            if (!(aFeature instanceof AnnotatedEReference) || (aReference = (AnnotatedEReference)aFeature).getEReference() != eReference) continue;
            return aReference;
        }
        if (create) {
            AnnotatedEReference aReference = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEReference();
            aClass.getAnnotatedEStructuralFeatures().add((Object)aReference);
            aReference.setEReference(eReference);
            return aReference;
        }
        return null;
    }

    public AnnotatedEAttribute getAnnotatedEAttribute(EAttribute eAttribute, boolean create) {
        if (eAttribute.getEContainingClass() == null) {
            return null;
        }
        AnnotatedEClass aClass = this.getAnnotatedEClass(eAttribute.getEContainingClass(), create);
        if (aClass == null) {
            return null;
        }
        for (AnnotatedEStructuralFeature aFeature : aClass.getAnnotatedEStructuralFeatures()) {
            AnnotatedEAttribute aAttribute;
            if (!(aFeature instanceof AnnotatedEAttribute) || (aAttribute = (AnnotatedEAttribute)aFeature).getEAttribute() != eAttribute) continue;
            return aAttribute;
        }
        if (create) {
            AnnotatedEAttribute aAttribute = AnnotationsmodelFactory.eINSTANCE.createAnnotatedEAttribute();
            aClass.getAnnotatedEStructuralFeatures().add((Object)aAttribute);
            aAttribute.setEAttribute(eAttribute);
            return aAttribute;
        }
        return null;
    }
}

