/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.datagenerator.DataGeneratorUtils;
import org.eclipse.emf.texo.datagenerator.EAttributeDataGenerator;
import org.eclipse.emf.texo.datagenerator.EClassDataGenerator;
import org.eclipse.emf.texo.datagenerator.EDataTypeDataGenerator;
import org.eclipse.emf.texo.datagenerator.EReferenceDataGenerator;
import org.eclipse.emf.texo.datagenerator.EStructuralFeatureDataGenerator;
import org.eclipse.emf.texo.datagenerator.FeatureMapDataGenerator;
import org.eclipse.emf.texo.datagenerator.ModelDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.BigDecimalDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.BigIntegerDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.BooleanDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.ByteArrayDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.ByteDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.CharDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.CollectionDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.DateDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.DoubleDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.DurationDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.EEnumDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.FloatDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.IntegerDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.JavaClassDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.LongDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.NullDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.QNameDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.ShortDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.StringDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.StringFileDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.XMLDateDataGenerator;
import org.eclipse.emf.texo.datagenerator.attributegenerators.XMLDateTimeDataGenerator;

public class DataGeneratorFactory {
    private boolean useDataFiles = true;

    public EClassDataGenerator createEClassDataGenerator(EClass eClass, ModelDataGenerator modelDataGenerator) {
        EClassDataGenerator eClassDataGenerator = new EClassDataGenerator();
        eClassDataGenerator.setModelDataGenerator(modelDataGenerator);
        eClassDataGenerator.setEClass(eClass);
        return eClassDataGenerator;
    }

    public EStructuralFeatureDataGenerator createEStructuralFeatureDataGenerator(EClass eClass, EStructuralFeature eStructuralFeature, ModelDataGenerator modelDataGenerator) {
        if (eStructuralFeature instanceof EReference) {
            return this.createEReferenceDataGenerator((EReference)eStructuralFeature, modelDataGenerator);
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
            FeatureMapDataGenerator featureMapDataGenerator = new FeatureMapDataGenerator();
            featureMapDataGenerator.setEStructuralFeature(eStructuralFeature);
            featureMapDataGenerator.setModelDataGenerator(modelDataGenerator);
            featureMapDataGenerator.setFeatures(eClass);
            return featureMapDataGenerator;
        }
        return this.createEAttributeDataGenerator((EAttribute)eStructuralFeature, modelDataGenerator);
    }

    protected EReferenceDataGenerator createEReferenceDataGenerator(EReference eReference, ModelDataGenerator modelDataGenerator) {
        EReferenceDataGenerator eReferenceDataGenerator = new EReferenceDataGenerator();
        eReferenceDataGenerator.setEReference(eReference);
        eReferenceDataGenerator.setModelDataGenerator(modelDataGenerator);
        return eReferenceDataGenerator;
    }

    protected EAttributeDataGenerator createEAttributeDataGenerator(EAttribute eAttribute, ModelDataGenerator modelDataGenerator) {
        EAttributeDataGenerator eAttributeDataGenerator = new EAttributeDataGenerator();
        eAttributeDataGenerator.setModelDataGenerator(modelDataGenerator);
        eAttributeDataGenerator.setEAttribute(eAttribute);
        return eAttributeDataGenerator;
    }

    protected EDataTypeDataGenerator createEDataTypeDataGenerator(EDataType eDataType, ModelDataGenerator modelDataGenerator, EAttribute eAttribute) {
        EDataTypeDataGenerator eDataTypeDataGenerator = null;
        if (DataGeneratorUtils.getEnumBaseDataTypeIfObject(eDataType) != null || eDataType instanceof EEnum) {
            eDataTypeDataGenerator = new EEnumDataGenerator();
        } else {
            Class<?> clz = DataGeneratorUtils.getInstanceClass(eDataType);
            boolean isArray = clz.isArray();
            if (isArray) {
                clz = clz.getComponentType();
            }
            if (QName.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new QNameDataGenerator();
            } else if (Class.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new JavaClassDataGenerator();
            } else if (Collection.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new CollectionDataGenerator();
            } else if (DataGeneratorUtils.getEnumBaseDataTypeIfObject(eDataType) != null || eDataType instanceof EEnum) {
                eDataTypeDataGenerator = new EEnumDataGenerator();
            } else if (Character.TYPE.isAssignableFrom(clz) || Character.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new CharDataGenerator();
            } else if (Boolean.TYPE.isAssignableFrom(clz) || Boolean.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new BooleanDataGenerator();
            } else if (Integer.TYPE.isAssignableFrom(clz) || Integer.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new IntegerDataGenerator();
            } else if (Short.TYPE.isAssignableFrom(clz) || Short.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new ShortDataGenerator();
            } else if (Byte.TYPE.isAssignableFrom(clz) || Byte.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new ByteDataGenerator();
            } else if (byte[].class.isAssignableFrom(clz) || Byte[].class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new ByteArrayDataGenerator();
            } else if (Long.TYPE.isAssignableFrom(clz) || Long.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new LongDataGenerator();
            } else if (Double.TYPE.isAssignableFrom(clz) || Double.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new DoubleDataGenerator();
            } else if (Float.TYPE.isAssignableFrom(clz) || Float.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new FloatDataGenerator();
            } else if (Date.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new DateDataGenerator();
            } else if (eDataType == XMLTypePackage.eINSTANCE.getDate()) {
                eDataTypeDataGenerator = new XMLDateDataGenerator();
            } else if (eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
                eDataTypeDataGenerator = new XMLDateTimeDataGenerator();
            } else if (BigDecimal.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new BigDecimalDataGenerator();
            } else if (BigInteger.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new BigIntegerDataGenerator();
            } else if (Duration.class.isAssignableFrom(clz)) {
                eDataTypeDataGenerator = new DurationDataGenerator();
            } else if (String.class.isAssignableFrom(clz) && eAttribute == null) {
                eDataTypeDataGenerator = new StringDataGenerator();
            } else if (String.class.isAssignableFrom(clz)) {
                String path = "/org/eclipse/emf/texo/datagenerator/data/general/";
                String name = eAttribute.getName().toLowerCase(Locale.ENGLISH);
                StringFileDataGenerator stringFileDataGenerator = null;
                if (eAttribute.isID()) {
                    eDataTypeDataGenerator = new StringDataGenerator();
                } else if (name.equals("description") || name.equals("title")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/description.txt");
                    stringFileDataGenerator.setValuesPerEAttribute(5);
                } else if (name.equals("name")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/description.txt");
                    stringFileDataGenerator.setValuesPerEAttribute(2);
                } else if (name.equals("city")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/city.txt");
                } else if (name.equals("firstname")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/firstname.txt");
                } else if (name.equals("lastname")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/lastname.txt");
                } else if (name.equals("zipcode")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/us_zip.txt");
                } else if (name.equals("zip")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/us_zip.txt");
                } else if (name.equals("street")) {
                    stringFileDataGenerator = new StringFileDataGenerator();
                    stringFileDataGenerator.setDataContent("/org/eclipse/emf/texo/datagenerator/data/general/street.txt");
                }
                eDataTypeDataGenerator = this.useDataFiles && stringFileDataGenerator != null ? stringFileDataGenerator : new StringDataGenerator();
            } else if (!eAttribute.isRequired()) {
                eDataTypeDataGenerator = new NullDataGenerator();
            } else {
                throw new UnsupportedOperationException("EAttribute " + eAttribute + " with EDataType " + eDataType.getName() + " not supported");
            }
        }
        eDataTypeDataGenerator.setModelDataGenerator(modelDataGenerator);
        eDataTypeDataGenerator.setEDataType(eDataType);
        return eDataTypeDataGenerator;
    }

    public boolean isUseDataFiles() {
        return this.useDataFiles;
    }

    public void setUseDataFiles(boolean useDataFiles) {
        this.useDataFiles = useDataFiles;
    }
}

