/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class DataGeneratorUtils {
    public static boolean addToEList(EList<EObject> eList, EObject value) {
        boolean isEMap = eList instanceof EMap;
        if (isEMap) {
            EStructuralFeature eKeyFeature = value.eClass().getEStructuralFeature("key");
            Object key = value.eGet(eKeyFeature);
            if (!((EMap)eList).containsKey(key)) {
                eList.add((Object)value);
                return true;
            }
        } else if (!eList.contains((Object)value)) {
            eList.add((Object)value);
            return true;
        }
        return false;
    }

    public static List<EClass> getRootEClasses(List<EPackage> ePackages) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (EPackage ePackage : ePackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || DataGeneratorUtils.isEMap((EClass)eClassifier) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface() || DataGeneratorUtils.isEMap(eClass)) continue;
                eClasses.add((EClass)eClassifier);
            }
        }
        return eClasses;
    }

    public static EDataType getItemType(EDataType eDataType) {
        if (eDataType == null) {
            return null;
        }
        EDataType itemDataType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemDataType != null) {
            return itemDataType;
        }
        List memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (memberTypes != null && memberTypes.size() > 0) {
            itemDataType = (EDataType)memberTypes.get(0);
        }
        if (itemDataType != null) {
            return itemDataType;
        }
        EDataType eBaseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (eBaseType == null) {
            return null;
        }
        return DataGeneratorUtils.getItemType(eBaseType);
    }

    public static boolean isEMap(EClass eClass) {
        return eClass != null && eClass.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(eClass.getInstanceClass()) && eClass.getEStructuralFeature("key") != null && eClass.getEStructuralFeature("value") != null;
    }

    public static EEnum getEnumBaseDataTypeIfObject(EDataType eDataType) {
        if (eDataType instanceof EEnum) {
            return null;
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EDataType baseDataType = eDataType;
        while (baseDataType != null) {
            if (baseDataType instanceof EEnum) {
                return (EEnum)baseDataType;
            }
            baseDataType = extendedMetaData.getBaseType(baseDataType);
        }
        return null;
    }

    public static Class<?> getInstanceClass(EDataType eDataType) {
        List memberTypes;
        Class clz = eDataType.getInstanceClass();
        if (clz != null && clz != Object.class) {
            return eDataType.getInstanceClass();
        }
        if (clz == Object.class && (memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType)) != null && memberTypes.size() > 0) {
            return DataGeneratorUtils.getInstanceClass((EDataType)memberTypes.get(0));
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return DataGeneratorUtils.getInstanceClass(baseType);
        }
        return String.class;
    }

    public static boolean isMixed(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        String name = (String)eAnnotation.getDetails().get((Object)"name");
        return kind != null && kind.compareTo("elementWildcard") == 0 && name != null && name.compareTo(":mixed") == 0;
    }

    public static EStructuralFeature getMixedEStructuralFeature(EClass eClass) {
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!DataGeneratorUtils.isMixed(eStructuralFeature)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public static boolean isAttribute(EStructuralFeature feature) {
        return DataGeneratorUtils.isKind(feature, "attribute");
    }

    private static boolean isKind(EStructuralFeature feature, String kindValue) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        return kind != null && kind.compareTo(kindValue) == 0;
    }
}

