/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.datagenerator.DataGenerator;
import org.eclipse.emf.texo.datagenerator.DataGeneratorFactory;
import org.eclipse.emf.texo.datagenerator.EStructuralFeatureDataGenerator;

public class EClassDataGenerator
extends DataGenerator {
    private List<EObject> eObjects = new ArrayList<EObject>();
    private int selectedIndex = 0;
    private EClass eClass;
    private List<EStructuralFeatureDataGenerator> dataGenerators = new ArrayList<EStructuralFeatureDataGenerator>();
    private List<EClass> concreteEClasses = null;
    private List<EClass> subEClasses = null;
    private int eClassIndex = 0;

    public EClass getEClass() {
        return this.eClass;
    }

    public EObject getCreateEObject(EObject owner, EReference eReference) {
        EObject eObject;
        if (!eReference.isContainment() && (eObject = this.findExistingObject(owner, eReference)) != null) {
            return eObject;
        }
        return this.createEObject();
    }

    protected EObject findExistingObject(EObject owner, EReference eReference) {
        EObject eObject;
        EClassDataGenerator eClassDataGenerator;
        EReference eOpposite = eReference.getEOpposite();
        for (int tries = 0; tries < this.eObjects.size(); ++tries) {
            EObject eObject2 = this.getNextEObject();
            if ((eReference.isContainer() || eReference.isContainment()) && (EcoreUtil.isAncestor((EObject)eObject2, (EObject)owner) || EcoreUtil.isAncestor((EObject)owner, (EObject)eObject2)) || eReference.isContainment() && eObject2.eContainer() != null) continue;
            if (eOpposite != null) continue;
            return eObject2;
        }
        if (this.subEClasses == null) {
            this.subEClasses = this.getModelDataGenerator().getAllSubEClasses(this.eClass);
        }
        for (EClass eSubClass : this.subEClasses) {
            eClassDataGenerator = this.getModelDataGenerator().getEClassDataGenerator(eSubClass);
            eObject = eClassDataGenerator.findExistingObject(owner, eReference);
            if (eObject == null) continue;
            return eObject;
        }
        for (EClass eSubClass : this.subEClasses) {
            eClassDataGenerator = this.getModelDataGenerator().getEClassDataGenerator(eSubClass);
            eObject = eClassDataGenerator.getCreateEObject(owner, eReference);
            if (eObject == null) continue;
            return eObject;
        }
        return null;
    }

    public void setData(EObject owner) {
        for (EStructuralFeatureDataGenerator dataGenerator : this.dataGenerators) {
            EReference eReference;
            if (dataGenerator.getEStructuralFeature() instanceof EReference && (eReference = (EReference)dataGenerator.getEStructuralFeature()).isContainer() && this.getModelDataGenerator().isRootObject(owner)) continue;
            dataGenerator.setData(owner);
        }
    }

    public EObject createEObject() {
        EClass nextEClass = this.getNextConcreteEClass();
        EObject eObject = EcoreUtil.create((EClass)nextEClass);
        this.eObjects.add(eObject);
        this.getModelDataGenerator().addToSetData(eObject);
        return eObject;
    }

    protected EObject getNextEObject() {
        if (this.selectedIndex == this.eObjects.size()) {
            this.selectedIndex = 0;
        }
        return this.eObjects.get(this.selectedIndex++);
    }

    public void setEClass(EClass eClass) {
        this.eClass = eClass;
        DataGeneratorFactory factory = this.getModelDataGenerator().getDataGeneratorFactory();
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (eStructuralFeature.isVolatile() || !eStructuralFeature.isChangeable() || this.getModelDataGenerator().getIgnoreEFeatures().contains(eStructuralFeature)) continue;
            this.dataGenerators.add(factory.createEStructuralFeatureDataGenerator(eClass, eStructuralFeature, this.getModelDataGenerator()));
        }
    }

    protected EClass getNextConcreteEClass() {
        if (this.eClassIndex == this.getConcreteEClasses().size()) {
            this.eClassIndex = 0;
        }
        if (this.eClassIndex > this.getConcreteEClasses().size()) {
            throw new IllegalStateException("No concrete sub EClasses for the EClass " + this.getEClass().getName() + ", did you set all required EPackages in the ModelDataGenerator");
        }
        return this.getConcreteEClasses().get(this.eClassIndex++);
    }

    protected List<EClass> getConcreteEClasses() {
        if (this.concreteEClasses == null) {
            this.concreteEClasses = this.getModelDataGenerator().getAllConcreteEClasses(this.eClass);
        }
        return this.concreteEClasses;
    }

    public List<EObject> getEObjects() {
        return this.eObjects;
    }

    public void setEObjects(List<EObject> objects) {
        this.eObjects = objects;
    }
}

