/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.texo.datagenerator.DataGenerator;
import org.eclipse.emf.texo.datagenerator.DataGeneratorUtils;

public abstract class EDataTypeDataGenerator
extends DataGenerator {
    private EDataType eDataType;
    private List<Object> values;
    private int currentIndex = 0;
    private int maxLength = -1;
    private boolean isArray = false;
    private Class<?> instanceClass = null;
    private boolean mustBeGloballyUnique;

    public String toString() {
        return this.eDataType.getName();
    }

    public Object createValue() {
        if (this.isArray) {
            Object array = Array.newInstance(this.getInstanceClass(), this.getModelDataGenerator().getCollectionSize());
            int i = 0;
            while (i < this.getModelDataGenerator().getCollectionSize()) {
                Array.set(array, i, this.correctLength(this.getNextValue()));
                ++i;
            }
            return array;
        }
        return this.correctLength(this.getNextValue());
    }

    private Object correctLength(Object value) {
        if (value instanceof String && this.maxLength != -1 && ((String)value).length() > this.maxLength) {
            return ((String)value).substring(0, this.maxLength);
        }
        return value;
    }

    protected Object getNextValue() {
        if (this.currentIndex == this.values.size()) {
            this.currentIndex = 0;
        }
        return this.values.get(this.currentIndex++);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(Class<?> instanceClass) {
        this.instanceClass = instanceClass;
    }

    public EDataType getEDataType() {
        return this.eDataType;
    }

    public void setEDataType(EDataType eDataType) {
        this.eDataType = eDataType;
        this.maxLength = ExtendedMetaData.INSTANCE.getMaxLengthFacet(eDataType);
        Class<?> localInstanceClass = DataGeneratorUtils.getInstanceClass(eDataType);
        if (localInstanceClass != null && localInstanceClass.isArray()) {
            this.isArray = true;
            this.setInstanceClass(localInstanceClass.getComponentType());
        } else {
            this.setInstanceClass(localInstanceClass);
        }
        this.initialize();
    }

    protected void initialize() {
    }

    public boolean isMustBeGloballyUnique() {
        return this.mustBeGloballyUnique;
    }

    public void setMustBeGloballyUnique(boolean mustBeGloballyUnique) {
        this.mustBeGloballyUnique = mustBeGloballyUnique;
    }
}

