/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.emf.texo.generator.TexoResourceManager;
import org.eclipse.jdt.core.IJavaProject;

public class ProjectPropertyUtil {
    public static final String TEMPLATES_LOCATION_PROPERTY = "TEMPLATE_FOLDER";
    public static final String OUTPUT_LOCATION_PROPERTY = "OUTPUT_FOLDER";
    public static final String TARGET_PROJECT_PROPERTY = "TARGET_PROJECT";
    public static final String MODEL_LOCATION_PROPERTY = "MODEL_FOLDER";
    public static final String ENABLE_AUTOGEN_PROPERTY = "ENABLE_AUTOGEN_PROPERTY";
    public static final String ENABLE_JPA_PROPERTY = "ENABLE_JPA_PROPERTY";
    public static final String ENABLE_DAO_PROPERTY = "ENABLE_DAO_PROPERTY";
    public static final String ORM_ADD_ORDER_COLUMN = "ORM_ADD_ORDER_COLUMN";
    public static final String ORM_ENFORCE_UNIQUE_NAMES = "ORM_ENFORCE_UNIQUE_NAMES";
    public static final String ORM_RENAME_SQL_RESERVED_NAMES = "ORM_RENAME_SQL_RESERVED_NAMES";
    public static final String ORM_GENERATE_FULL_DB_SCHEMA_NAMES = "ORM_GENERATE_FULL_DB_SCHEMA_NAMES";
    public static final String ORM_MAX_SQL_NAME_LENGTH = "ORM_MAX_SQL_NAME_LENGTH";
    public static final QualifiedName GEN_OUTPUT_FOLDER_PROPERTY = new QualifiedName("org.eclipse.emf.texo.eclipse", "GEN_OUTPUT_FOLDER");
    public static final String GEN_OUTPUT_FOLDER_PROPERTY_DEFAULT = "src-gen";

    public static IProject getTargetProject(IProject defaultProject) {
        String value = ProjectPropertyUtil.getProjectProperties(defaultProject).getProperty(TARGET_PROJECT_PROPERTY);
        if (value == null || value.trim().length() == 0) {
            return defaultProject;
        }
        return EclipseGeneratorUtils.getProject((String)value);
    }

    public static String getGenOutputFolder(IProject project) {
        String value = ProjectPropertyUtil.getProjectProperties(project).getProperty(OUTPUT_LOCATION_PROPERTY);
        if (value == null) {
            return GEN_OUTPUT_FOLDER_PROPERTY_DEFAULT;
        }
        return value;
    }

    public static Properties getProjectProperties(IProject project) {
        File file = ProjectPropertyUtil.getPropertiesFile(project);
        try {
            Properties props = new Properties();
            props.setProperty(TARGET_PROJECT_PROPERTY, "");
            props.setProperty(OUTPUT_LOCATION_PROPERTY, GEN_OUTPUT_FOLDER_PROPERTY_DEFAULT);
            String value = project.getPersistentProperty(TexoResourceManager.TEMPLATE_FOLDER_PROPERTY);
            if (value != null) {
                props.setProperty(TEMPLATES_LOCATION_PROPERTY, value);
            }
            if ((value = project.getPersistentProperty(GEN_OUTPUT_FOLDER_PROPERTY)) != null) {
                props.setProperty(OUTPUT_LOCATION_PROPERTY, value);
            }
            if (!file.exists()) {
                return props;
            }
            FileInputStream is = new FileInputStream(file);
            props.load(is);
            ((InputStream)is).close();
            return props;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error writing to file " + file.toString());
        }
    }

    public static void setProjectProperties(IProject project, Properties props) throws CoreException {
        File file = ProjectPropertyUtil.getPropertiesFile(project);
        try {
            FileOutputStream os = new FileOutputStream(file, false);
            props.store(os, null);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing to file " + file.toString());
        }
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private static File getPropertiesFile(IProject project) {
        IPath settingsPath = project.getLocation().append(".settings");
        File settingsDir = settingsPath.toFile();
        if (!settingsDir.exists()) {
            settingsDir.mkdir();
        }
        IPath iPath = settingsPath.append("org.eclipse.emf.texo.prefs");
        return iPath.toFile();
    }

    public static IProject getProject(Object object) {
        if (object instanceof IProject) {
            return (IProject)object;
        }
        if (object instanceof IJavaProject) {
            return ((IJavaProject)object).getProject();
        }
        throw new IllegalArgumentException("The argument " + object + " is not a Project");
    }
}

