/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.nature;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.eclipse.popup.actions.GenerateCode;

public class TexoAutoCodeGenerator
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.emf.texo.eclipse.TexoAutoCodeGenerator";

    public static void addRemoveProjectBuilder(IProject project, boolean add) {
        try {
            ICommand command;
            IProjectDescription desc = project.getDescription();
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            ICommand currentCommand = null;
            ICommand[] iCommandArray = desc.getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                command = iCommandArray[n2];
                commands.add(command);
                if (command.getBuilderName().equals(BUILDER_ID)) {
                    currentCommand = command;
                }
                ++n2;
            }
            if (currentCommand != null) {
                if (add) {
                    return;
                }
                commands.remove(currentCommand);
            } else {
                command = desc.newCommand();
                command.setBuilderName(BUILDER_ID);
                commands.add(0, command);
            }
            desc.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
            project.setDescription(desc, null);
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        IResourceDelta delta;
        if (kind != 6 && (delta = this.getDelta(this.getProject())) != null) {
            try {
                this.incrementalBuild(delta, monitor);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    if (delta.getKind() != 1 && delta.getKind() != 4) {
                        return false;
                    }
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile) {
                        String extension = resource.getRawLocation().getFileExtension();
                        if (extension == null) {
                            return true;
                        }
                        if (extension.endsWith("ecore")) {
                            files.add((IFile)resource);
                        } else if (extension.endsWith("xcore")) {
                            files.add((IFile)resource);
                        } else if (extension.endsWith("xsd")) {
                            files.add((IFile)resource);
                        } else if (extension.endsWith("annotationsmodel")) {
                            String name = resource.getName();
                            int dashIndex = name.indexOf("-");
                            if (dashIndex == -1) {
                                dashIndex = name.indexOf(".");
                            }
                            if (dashIndex != -1) {
                                IFile modelFile = null;
                                String modelFileName = String.valueOf(name.substring(0, dashIndex)) + ".xcore";
                                IPath path = resource.getParent().getFullPath().append(modelFileName);
                                modelFile = resource.getParent().getFile(path.makeRelativeTo(resource.getParent().getFullPath()));
                                if (!modelFile.exists()) {
                                    modelFileName = String.valueOf(name.substring(0, dashIndex)) + ".ecore";
                                    path = resource.getParent().getFullPath().append(modelFileName);
                                    modelFile = resource.getParent().getFile(path.makeRelativeTo(resource.getParent().getFullPath()));
                                }
                                if (modelFile.exists()) {
                                    files.add(modelFile);
                                }
                            }
                        }
                    }
                    return true;
                }
            });
            Properties props = ProjectPropertyUtil.getProjectProperties(this.getProject());
            if (props.containsKey("MODEL_FOLDER") && props.getProperty("MODEL_FOLDER").trim().length() > 0) {
                String modelFilter = props.getProperty("MODEL_FOLDER");
                IPath modelPath = this.getProject().getFullPath().append(modelFilter);
                ArrayList<IFile> toIgnore = new ArrayList<IFile>();
                for (IFile file : files) {
                    if (modelPath == null || modelPath.isPrefixOf(file.getFullPath())) continue;
                    toIgnore.add(file);
                }
                files.removeAll(toIgnore);
            } else {
                files.clear();
            }
            if (files.size() > 0) {
                GenerateCode action = new GenerateCode();
                if (props.containsKey("ENABLE_DAO_PROPERTY")) {
                    action.setDoDao(true);
                }
                if (props.containsKey("ENABLE_JPA_PROPERTY")) {
                    action.setDoJpa(true);
                }
                action.setModelFiles(files);
                action.generate(monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

