/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class BaseGenerateAction
implements IObjectActionDelegate {
    private List<IFile> modelFiles = new ArrayList<IFile>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        WorkspaceModifyOperation runnable = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor progressMonitor) {
                BaseGenerateAction.this.generate(progressMonitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                BaseGenerateAction.showError(((InvocationTargetException)e).getTargetException());
            } else {
                BaseGenerateAction.showError(e);
            }
            throw new IllegalStateException(e);
        }
    }

    public void generate(IProgressMonitor monitor) {
        HashMap filesByProject = new HashMap();
        for (IFile modelFile : this.modelFiles) {
            IProject project = modelFile.getProject();
            if (filesByProject.get(project) == null) {
                filesByProject.put(project, new ArrayList());
            }
            ((List)filesByProject.get(project)).add(modelFile);
        }
        try {
            monitor.setTaskName(Messages.getString("generate.Artifacts"));
            for (IProject project : filesByProject.keySet()) {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                this.generate(monitor, project, (List)filesByProject.get(project));
                monitor.subTask(Messages.getString("generate.Refresh"));
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void generate(IProgressMonitor monitor, IProject project, List<IFile> projectModelFiles) {
        monitor.subTask(Messages.getString("generate.Reading"));
        ArrayList<IFile> localModelFiles = new ArrayList<IFile>();
        for (IFile modelFile : this.modelFiles) {
            localModelFiles.add(modelFile);
        }
        this.generateFromModelFiles(monitor, project, localModelFiles);
    }

    protected abstract void generateFromModelFiles(IProgressMonitor var1, IProject var2, List<IFile> var3);

    public static void showError(Throwable e) {
        e.printStackTrace(System.err);
        Status status = new Status(4, "org.eclipse.emf.texo.eclipse", 0, Messages.getString("error.click.details"), e);
        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"", (String)Messages.getString("error.during.artifact.generation"), (IStatus)status);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator it = structuredSelection.iterator();
        this.modelFiles.clear();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IFile)) continue;
            this.modelFiles.add((IFile)obj);
        }
    }

    public List<IFile> getModelFiles() {
        return this.modelFiles;
    }

    public void setModelFiles(List<IFile> modelFiles) {
        this.modelFiles = modelFiles;
    }
}

