/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.texo.eclipse.popup.actions.BaseGenerateAction;

public class GenerateEcoreFromXCore
extends BaseGenerateAction {
    @Override
    protected void generateFromModelFiles(IProgressMonitor monitor, IProject project, List<IFile> modelFiles) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            resourceSet.setPackageRegistry(EPackage.Registry.INSTANCE);
            resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
            ArrayList<Resource> resourcesToSave = new ArrayList<Resource>();
            for (IFile modelFile : modelFiles) {
                EObject rootObject;
                Resource metaDataResource;
                java.net.URI uri = new java.net.URI(modelFile.getFullPath().toString());
                URI emfURI = URI.createURI((String)uri.toString());
                Resource resource = resourceSet.createResource(emfURI);
                resource.load(Collections.emptyMap());
                if (!resource.getContents().isEmpty() && (metaDataResource = (rootObject = (EObject)resource.getContents().get(0)).eClass().eResource()) != null && metaDataResource.getResourceSet() != null) {
                    resourceSet.getResources().addAll((Collection)metaDataResource.getResourceSet().getResources());
                }
                boolean multipleFiles = false;
                for (EObject eObject : new ArrayList(resource.getContents())) {
                    if (!(eObject instanceof EPackage)) continue;
                    EPackage ePackage = (EPackage)eObject;
                    URI ecoreURI = emfURI.trimFileExtension().appendFileExtension("ecore");
                    if (multipleFiles) {
                        String strUri = ecoreURI.toString();
                        int lastDot = strUri.lastIndexOf(".");
                        strUri = String.valueOf(strUri.substring(0, lastDot)) + "_" + ePackage.getName() + strUri.substring(lastDot);
                        ecoreURI = URI.createURI((String)strUri);
                    }
                    Resource ePackageResource = resourceSet.createResource(ecoreURI);
                    ePackageResource.getContents().clear();
                    ePackageResource.getContents().add((Object)ePackage);
                    resourcesToSave.add(ePackageResource);
                    multipleFiles = true;
                }
            }
            for (Resource res : resourcesToSave) {
                res.save(Collections.emptyMap());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

