/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.generator.BaseMainTemplate;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.emf.texo.generator.FileCleaner;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.generator.SourceMerger;
import org.eclipse.emf.texo.generator.TexoResourceManager;
import org.eclipse.emf.texo.generator.XPandTemplate;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.NoChangesVetoStrategy;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xpand2.output.VetoStrategy;
import org.eclipse.xtend.expression.ExceptionHandler;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.type.impl.java.JavaMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;

public class ArtifactGenerator {
    static final String MODEL_CONTROLLER = "modelController";
    static final String DO_DAO = "doDao";
    private static final String FILE_ENCODING = "UTF-8";
    private IProgressMonitor monitor = new NullProgressMonitor();
    private TexoResourceManager resourceManager = (TexoResourceManager)((Object)ComponentProvider.getInstance().newInstance(TexoResourceManager.class));
    private String projectName;
    private String templateProjectName;
    private ModelController modelController;
    private String outputFolder;
    private String expand = "org::eclipse::emf::texo::modelgenerator::templates::model::root(modelController, doDao) FOREACH modelController.EPackages";
    private FileCleaner fileCleaner = new FileCleaner();
    private List<Outlet> outlets;
    private boolean doDao;
    private BaseMainTemplate xTendTemplate;

    public void run() {
        this.initializeOutlets();
        try {
            OutputImpl out = new OutputImpl();
            out.setAutomaticHyphens(false);
            for (Outlet outlet : this.getOutlets()) {
                out.addOutlet(outlet);
            }
            if (this.xTendTemplate != null) {
                this.xTendTemplate.setArtifactGenerator(this);
                for (EPackage ePackage : this.modelController.getEPackages()) {
                    this.xTendTemplate.generate(ePackage, this.modelController, this.doDao);
                    Map<String, String> xTendResult = this.xTendTemplate.getFiles();
                    for (String string : xTendResult.keySet()) {
                        String content = xTendResult.get(string);
                        boolean isJava = string.endsWith("java");
                        out.openFile(string, isJava ? "java" : null);
                        out.write(content);
                        out.closeFile();
                    }
                    this.xTendTemplate.clearFiles();
                }
                XPandTemplate xPandTemplate = new XPandTemplate();
                xPandTemplate.setArtifactGenerator(this);
                xPandTemplate.setXPandTemplate("org::eclipse::emf::texo::modelgenerator::templates::advices");
                xPandTemplate.setMainObject(this.getModelController());
                xPandTemplate.generate();
                Map<String, String> xPandResult = this.xTendTemplate.getFiles();
                for (String fileName : xPandResult.keySet()) {
                    String content = xPandResult.get(fileName);
                    boolean isJava = fileName.endsWith("java");
                    out.openFile(fileName, isJava ? "java" : null);
                    out.write(content);
                    out.closeFile();
                }
            } else {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put(MODEL_CONTROLLER, this.modelController);
                parameters.put(DO_DAO, this.isDoDao());
                XpandExecutionContextImpl executionContext = new XpandExecutionContextImpl((ResourceManager)this.resourceManager, (Output)out, null, new HashMap(), null, this.getExceptionHandler(), null, null);
                executionContext.registerMetaModel((MetaModel)new JavaMetaModel());
                ExpandStatement es = this.getStatement();
                for (String string : parameters.keySet()) {
                    executionContext = (XpandExecutionContextImpl)executionContext.cloneWithVariable(new Variable(string, parameters.get(string)));
                }
                executionContext.registerAdvices("org::eclipse::emf::texo::modelgenerator::templates::advices");
                es.evaluate((XpandExecutionContext)executionContext);
            }
            this.fileCleaner.clean();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private ExpandStatement getStatement() {
        Template tpl = XpandParseFacade.file((Reader)new StringReader("\u00abDEFINE test FOR test\u00bb\u00abEXPAND " + this.getExpand() + "\u00bb" + "\u00ab" + "ENDDEFINE" + "\u00bb"), null);
        return (ExpandStatement)((Definition)tpl.getDefinitions()[0]).getBody()[1];
    }

    protected ExceptionHandler getExceptionHandler() {
        return new ExceptionHandler(){

            public void handleRuntimeException(RuntimeException ex, SyntaxElement element, ExecutionContext ctx, Map<String, Object> additionalContextInfo) {
                throw ex;
            }
        };
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (this.templateProjectName == null) {
            this.setTemplateProjectName(projectName);
        }
    }

    public void setTemplateProjectName(String projectName) {
        this.templateProjectName = projectName;
        this.resourceManager.setProjectName(projectName);
    }

    protected void initializeOutlets() {
        if (this.outlets != null) {
            return;
        }
        this.outlets = new ArrayList<Outlet>();
        Outlet outlet = new Outlet();
        outlet.setFileEncoding(FILE_ENCODING);
        outlet.addVetoStrategy(this.fileCleaner.getNewOutputLocationTracker());
        outlet.addVetoStrategy((VetoStrategy)new NoChangesVetoStrategy());
        outlet.setPath(String.valueOf(EclipseGeneratorUtils.getProjectFilePath(this.getProjectName())) + "/" + this.outputFolder);
        this.outlets.add(outlet);
        outlet = new Outlet();
        outlet.setFileEncoding(FILE_ENCODING);
        outlet.setName("java");
        outlet.addVetoStrategy(this.fileCleaner.getNewOutputLocationTracker());
        outlet.addVetoStrategy((VetoStrategy)new NoChangesVetoStrategy());
        SourceMerger sourceMerger = new SourceMerger();
        sourceMerger.setProjectName(this.getProjectName());
        sourceMerger.setMonitor(this.monitor);
        outlet.addPostprocessor((PostProcessor)sourceMerger);
        outlet.setPath(String.valueOf(EclipseGeneratorUtils.getProjectFilePath(this.getProjectName())) + "/" + this.outputFolder);
        this.outlets.add(outlet);
    }

    public final List<Outlet> getOutlets() {
        if (this.outlets == null) {
            this.initializeOutlets();
        }
        return this.outlets;
    }

    public ModelController getModelController() {
        return this.modelController;
    }

    public void setModelController(ModelController modelController) {
        this.modelController = modelController;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public void setOutlets(List<Outlet> outlets) {
        this.outlets = outlets;
    }

    public boolean isDoDao() {
        return this.doDao;
    }

    public void setDoDao(boolean doDao) {
        this.doDao = doDao;
    }

    public TexoResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(TexoResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public BaseMainTemplate getXTendTemplate() {
        return this.xTendTemplate;
    }

    public void setXTendTemplate(BaseMainTemplate xTendTemplate) {
        this.xTendTemplate = xTendTemplate;
    }
}

