/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEStructuralFeature;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsmodelPackage;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.XbasePackage;

public class GeneratorUtils {
    private static int ASTLEVEL = -1;

    public static int getASTLevel() {
        if (ASTLEVEL == -1) {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = AST.class.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals("JLS8")) {
                    ASTLEVEL = 8;
                }
                ++n2;
            }
            if (ASTLEVEL == -1) {
                ASTLEVEL = 4;
            }
        }
        return ASTLEVEL;
    }

    public static boolean isOptional(EStructuralFeature eFeature) {
        if (eFeature.isMany()) {
            return false;
        }
        if (GeneratorUtils.isPartOfGroup(eFeature)) {
            return false;
        }
        return !eFeature.isRequired();
    }

    public static boolean setPropertyAccess(AnnotatedEStructuralFeature aFeature) {
        if (aFeature.getAnnotatedEClass().getAnnotatedEPackage().getAnnotatedModel().isGeneratingSources()) {
            return false;
        }
        EStructuralFeature eFeature = aFeature.getEStructuralFeature();
        if (GeneratorUtils.isPartOfGroup(eFeature)) {
            return false;
        }
        return !ExtendedMetaData.INSTANCE.isDocumentRoot(eFeature.getEContainingClass()) && eFeature.isDerived();
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNotEmptyAndNotNull(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static boolean isPartOfGroup(EStructuralFeature eFeature) {
        return ExtendedMetaData.INSTANCE.getGroup(eFeature) != null || !ModelUtils.isMixed((EStructuralFeature)eFeature) && ModelUtils.hasMixedEFeature((EClass)eFeature.getEContainingClass());
    }

    public static <T, E extends ModelFeatureMapEntry<?>> List<T> createUnModifiableList(Collection<E> featureMap, EStructuralFeature eStructuralFeature) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ModelFeatureMapEntry entry : featureMap) {
            if (entry.getEStructuralFeature() != eStructuralFeature) continue;
            result.add(entry.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isElement(EStructuralFeature feature) {
        return GeneratorUtils.isKind(feature, "element");
    }

    public static boolean isGroup(EStructuralFeature feature) {
        return GeneratorUtils.isKind(feature, "group");
    }

    public static boolean isAttribute(EStructuralFeature feature) {
        return GeneratorUtils.isKind(feature, "attribute");
    }

    public static EStructuralFeature getMixedEStructuralFeature(EClass eClass) {
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!ModelUtils.isMixed((EStructuralFeature)eStructuralFeature)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    private static boolean isKind(EStructuralFeature feature, String kindValue) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        return kind != null && kind.compareTo(kindValue) == 0;
    }

    public static EPackage.Registry createEPackageRegistry() {
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        registry.put((Object)"http://www.eclipse.org/emf/2011/Xcore", (Object)XcorePackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/xtext/xbase/Xbase", (Object)XbasePackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/xtext/common/JavaVMTypes", (Object)TypesPackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        registry.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/xsd/2002/XSD", (Object)XSDPackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/emf/texo/annotations/model", (Object)AnnotationsmodelPackage.eINSTANCE);
        if (EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/emf/texo/modelgenerator/modelannotations") != null) {
            EPackage modelGenEPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/texo/modelgenerator/modelannotations");
            registry.put((Object)modelGenEPackage.getNsURI(), (Object)modelGenEPackage);
        }
        if (EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/emf/texo/orm/ormannotations") != null) {
            EPackage modelOrmEPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/texo/orm/ormannotations");
            registry.put((Object)modelOrmEPackage.getNsURI(), (Object)modelOrmEPackage);
        }
        if (EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/eclipselink/xsds/persistence/orm") != null) {
            EPackage ormEPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/eclipselink/xsds/persistence/orm");
            registry.put((Object)ormEPackage.getNsURI(), (Object)ormEPackage);
        }
        return registry;
    }

    public static List<EPackage> readEPackage(java.net.URI uri, EPackage.Registry registry, boolean useWsUris) {
        ArrayList<java.net.URI> list = new ArrayList<java.net.URI>();
        list.add(uri);
        return GeneratorUtils.readEPackages(list, registry, useWsUris);
    }

    public static List<EPackage> readEPackages(List<java.net.URI> uris, EPackage.Registry registry, boolean useWsUris) {
        ResourceSet resourceSet = GeneratorUtils.createGenerationResourceSet(registry);
        return GeneratorUtils.readEPackages(uris, resourceSet, registry, useWsUris);
    }

    public static List<EPackage> readEPackages(List<java.net.URI> uris, ResourceSet resourceSet, EPackage.Registry registry, boolean useWsUris) {
        ArrayList<URI> emfUris = new ArrayList<URI>();
        for (java.net.URI uri : uris) {
            String uriStr = uri.toString();
            if (useWsUris) {
                emfUris.add(URI.createPlatformResourceURI((String)uriStr, (boolean)true));
                continue;
            }
            emfUris.add(URI.createURI((String)uriStr));
        }
        return GeneratorUtils.readEPackagesUsingEMFURI(emfUris, resourceSet, registry);
    }

    public static List<EPackage> readEPackagesUsingEMFURI(List<URI> uris, EPackage.Registry registry) {
        ResourceSet rs = GeneratorUtils.createGenerationResourceSet(registry);
        return GeneratorUtils.readEPackagesUsingEMFURI(uris, rs, registry);
    }

    public static List<EPackage> readEPackagesUsingEMFURI(List<URI> uris, ResourceSet resourceSet, EPackage.Registry registry) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        XSDEcoreBuilder ecoreBuilder = new XSDEcoreBuilder((ExtendedMetaData)new BasicExtendedMetaData(resourceSet.getPackageRegistry()));
        ecoreBuilder.setValidate(true);
        for (URI emfURI : uris) {
            if (emfURI.toString().endsWith("xsd")) {
                for (EObject eObject : ecoreBuilder.generate(emfURI)) {
                    GeneratorUtils.checkDiagnostics(ecoreBuilder);
                    EPackage ePackage = ModelUtils.registerEPackage((EPackage)((EPackage)eObject), (EPackage.Registry)registry);
                    if (ePackages.contains(ePackage)) continue;
                    ePackages.add(ePackage);
                }
                continue;
            }
            Resource res = resourceSet.createResource(emfURI);
            try {
                EObject rootObject;
                Resource metaDataResource;
                res.load(null);
                if (!res.getContents().isEmpty() && (metaDataResource = (rootObject = (EObject)res.getContents().get(0)).eClass().eResource()) != null && metaDataResource.getResourceSet() != null) {
                    resourceSet.getResources().addAll((Collection)metaDataResource.getResourceSet().getResources());
                }
                GeneratorUtils.checkErrors(res);
                TreeIterator it = res.getAllContents();
                while (it.hasNext()) {
                    EPackage ePackage;
                    Object obj = it.next();
                    if (!(obj instanceof EPackage) || ePackages.contains(ePackage = ModelUtils.registerEPackage((EPackage)((EPackage)obj), (EPackage.Registry)registry))) continue;
                    ePackages.add(ePackage);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception while loading resource from " + emfURI.toString(), e);
            }
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        for (Resource res : resourceSet.getResources()) {
            try {
                GeneratorUtils.checkErrors(res);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception while resolving proxies for resource " + res.getURI().toString(), e);
            }
        }
        return ePackages;
    }

    public static ResourceSet createGenerationResourceSet(EPackage.Registry registry) {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        rs.setPackageRegistry(registry);
        rs.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        return rs;
    }

    private static void checkErrors(Resource res) {
        if (res.getErrors().isEmpty() && res.getWarnings().isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Resource.Diagnostic diagnostic : res.getErrors()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(String.valueOf(diagnostic.getLocation()) + " (" + diagnostic.getLine() + "):" + diagnostic.getMessage());
        }
        for (Resource.Diagnostic diagnostic : res.getWarnings()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(String.valueOf(diagnostic.getLocation()) + " (" + diagnostic.getLine() + "):" + diagnostic.getMessage());
        }
        throw new IllegalStateException(sb.toString());
    }

    private static void checkDiagnostics(XSDEcoreBuilder ecoreBuilder) {
        StringBuilder sb = new StringBuilder();
        List diagnostics = ecoreBuilder.getDiagnostics();
        for (XSDDiagnostic xsdDiagnostic : diagnostics) {
            if (xsdDiagnostic.getSeverity() != XSDDiagnosticSeverity.ERROR_LITERAL && xsdDiagnostic.getSeverity() != XSDDiagnosticSeverity.FATAL_LITERAL) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(String.valueOf(xsdDiagnostic.getLocation()) + " (" + xsdDiagnostic.getLine() + ":" + xsdDiagnostic.getColumn() + "):" + xsdDiagnostic.getMessage());
        }
        if (sb.length() > 0) {
            throw new IllegalStateException(sb.toString());
        }
    }

    public static void readEPackagesFromFile(String nsUri, String ecoreFileName, EPackage.Registry registry) {
        Check.isNotEmpty((String)ecoreFileName, (String)"Ecore file of ModelPackage may not be empty.");
        if (ecoreFileName != null && ecoreFileName.length() > 0) {
            try {
                Resource res = new EcoreResourceFactoryImpl().createResource(URI.createURI((String)nsUri));
                InputStream is = GeneratorUtils.class.getResourceAsStream(ecoreFileName);
                res.load(is, Collections.EMPTY_MAP);
                is.close();
                TreeIterator it = res.getAllContents();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof EPackage)) continue;
                    EPackage epack = (EPackage)obj;
                    ModelUtils.registerEPackage((EPackage)epack, (EPackage.Registry)registry);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception while loading models from ecorefile " + ecoreFileName);
            }
        }
    }

    public static List<EPackage> getAllSubEPackages(List<EPackage> ePackages) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (EPackage ePackage : ePackages) {
            result.add(ePackage);
            result.addAll(GeneratorUtils.getAllSubEPackages(ePackage));
        }
        return result;
    }

    public static List<EPackage> getAllSubEPackages(EPackage ePackage) {
        ArrayList<EPackage> subEPackages = new ArrayList<EPackage>();
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            subEPackages.add(subEPackage);
            subEPackages.addAll(GeneratorUtils.getAllSubEPackages(subEPackage));
        }
        return subEPackages;
    }

    public static String getEAnnotationValue(EModelElement eModelElement, String source, String key) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(source);
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)key);
    }

    public static String toString(EStructuralFeature eFeature) {
        Check.isNotNullArgument((Object)eFeature, (String)"eFeature");
        return String.valueOf(eFeature.getClass().getSimpleName()) + ": " + eFeature.getEContainingClass().getName() + "." + eFeature.getName();
    }

    public static EPackage getEPackageInstance(String className) {
        try {
            Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(className);
            EPackage ePackage = (EPackage)clz.getField("eINSTANCE").get(null);
            return ePackage;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception when getting EPackage instance " + className, e);
        }
    }

    public static List<EObject> loadResource(String uri, EPackage.Registry registry) {
        ResourceSet resourceSet = GeneratorUtils.createDataResourceSet(registry);
        Resource resource = resourceSet.createResource(URI.createURI((String)uri));
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        try {
            options.put("EXTENDED_META_DATA", Boolean.TRUE);
            options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            options.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
            options.put("LAX_WILDCARD_PROCESSING", Boolean.TRUE);
            options.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
            resource.load(options);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception when loading uri " + uri, e);
        }
        return resource.getContents();
    }

    public static ResourceSet createDataResourceSet(EPackage.Registry registry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(registry);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        return resourceSet;
    }

    public static List<XSDSchema> getXSDSchemas(String uri, EPackage.Registry registry) {
        ArrayList<XSDSchema> xsdSchemas = new ArrayList<XSDSchema>();
        ResourceSet resourceSet = GeneratorUtils.getXSDResourceSet(registry);
        Resource resource = resourceSet.getResource(URI.createURI((String)uri), true);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof XSDSchema)) continue;
            xsdSchemas.add((XSDSchema)eObject);
        }
        return xsdSchemas;
    }

    public static ResourceSet getXSDResourceSet(EPackage.Registry registry) {
        ResourceSetImpl result = new ResourceSetImpl();
        result.setPackageRegistry(registry);
        result.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        Map extensionToFactoryMap = result.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("wsdl", new XSDResourceFactoryImpl());
        extensionToFactoryMap.put("xsd", new XSDResourceFactoryImpl());
        extensionToFactoryMap.put("ecore", new EcoreResourceFactoryImpl());
        return result;
    }

    public static byte[] getEPackageAsByteArray(EPackage ePackage, EPackage.Registry packageRegistry) {
        try {
            Resource resource = ePackage.eResource();
            if (resource == null) {
                resource = GeneratorUtils.createEcoreResource(ePackage.getNsURI(), packageRegistry);
                resource.getContents().add((Object)ePackage);
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("ZIP", true);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            resource.save((OutputStream)os, options);
            return os.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static EPackage createEPackage(String nsUri, byte[] bytes, EPackage.Registry packageRegistry) {
        if (packageRegistry.getEPackage(nsUri) != null) {
            return packageRegistry.getEPackage(nsUri);
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Resource resource = GeneratorUtils.createEcoreResource(nsUri, packageRegistry);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("ZIP", true);
            resource.load((InputStream)bais, options);
            EList contents = resource.getContents();
            EPackage ePackage = (EPackage)contents.get(0);
            return ePackage;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Resource createEcoreResource(String uri, EPackage.Registry packageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(packageRegistry);
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("*", resourceFactory);
        return resourceSet.createResource(URI.createURI((String)uri));
    }
}

