/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.ExtensionPointUtils;

public abstract class ModelAnnotator {
    private static ModelAnnotator codeGenAnnotator = null;

    public static ModelAnnotator getCodeGenAnnotator() {
        return codeGenAnnotator;
    }

    public static void setCodeGenAnnotator(ModelAnnotator codeGenAnnotator) {
        ModelAnnotator.codeGenAnnotator = codeGenAnnotator;
    }

    public abstract String getAnnotationModelSuffix();

    public void annotate(List<EPackage> ePackages, AnnotationManager annotationManager) {
        ExtensionPointUtils.readAnnotationsModelsFromExtensions();
        for (EPackage ePackage : ePackages) {
            EClass annotationEClass = this.getAnnotationEClass((ENamedElement)ePackage);
            if (annotationEClass != null) {
                annotationManager.getAnnotation((ENamedElement)ePackage, annotationEClass);
            }
            TreeIterator iterator = ePackage.eAllContents();
            while (iterator.hasNext()) {
                ENamedElement eNamedElement;
                EClass annotationEClass2;
                Object object = iterator.next();
                if (!(object instanceof ENamedElement) || (annotationEClass2 = this.getAnnotationEClass(eNamedElement = (ENamedElement)object)) == null) continue;
                annotationManager.getAnnotation(eNamedElement, annotationEClass2);
            }
        }
    }

    public void postAnnotate(List<EPackage> ePackages, AnnotationManager annotationManager) {
        for (EPackage ePackage : ePackages) {
            EClass annotationEClass = this.getAnnotationEClass((ENamedElement)ePackage);
            if (annotationEClass != null) {
                Annotator<ENamedElementAnnotation> annotator = annotationManager.getAnnotator(annotationEClass);
                ENamedElementAnnotation annotation = annotationManager.getAnnotation((ENamedElement)ePackage, annotationEClass);
                if (annotator != null) {
                    annotator.postAnnotating(annotation);
                }
            }
            TreeIterator iterator = ePackage.eAllContents();
            while (iterator.hasNext()) {
                ENamedElement eNamedElement;
                EClass annotationEClass2;
                Object object = iterator.next();
                if (!(object instanceof ENamedElement) || (annotationEClass2 = this.getAnnotationEClass(eNamedElement = (ENamedElement)object)) == null) continue;
                Annotator<ENamedElementAnnotation> annotator = annotationManager.getAnnotator(annotationEClass2);
                ENamedElementAnnotation annotation = annotationManager.getAnnotation(eNamedElement, annotationEClass2);
                if (annotator == null) continue;
                annotator.postAnnotating(annotation);
            }
        }
    }

    protected abstract EClass getAnnotationEClass(ENamedElement var1);

    protected abstract List<Annotator<? extends ENamedElementAnnotation>> getAnnotators();
}

