/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.texo.annotations.AnnotationProvider;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.ExtensionPointUtils;
import org.eclipse.emf.texo.generator.ModelAnnotator;
import org.eclipse.emf.texo.generator.ModelAnnotatorRegistry;

public class ModelController
implements AnnotationProvider {
    private List<EPackage> ePackages = new ArrayList<EPackage>();
    private AnnotationManager annotationManager = new AnnotationManager();

    public void annotate(List<ModelAnnotator> modelAnnotators) {
        List<EPackage> allEPackages = this.collectEPackages();
        ExtensionPointUtils.readModelAnnotatorsFromExtensions();
        ModelAnnotator codeGenAnnotator = ModelAnnotator.getCodeGenAnnotator();
        this.annotationManager.addAnnotators(codeGenAnnotator);
        this.doAnnotate(codeGenAnnotator, allEPackages);
        for (ModelAnnotator modelAnnotator : ModelAnnotatorRegistry.getInstance().getModelAnnotators()) {
            if (modelAnnotator == codeGenAnnotator) continue;
            this.annotationManager.addAnnotators(modelAnnotator);
        }
        for (ModelAnnotator modelAnnotator : ModelAnnotatorRegistry.getInstance().getModelAnnotators()) {
            if (modelAnnotator == codeGenAnnotator) continue;
            this.doAnnotate(modelAnnotator, allEPackages);
        }
    }

    private List<EPackage> collectEPackages() {
        ArrayList<EPackage> collectedEPackages = new ArrayList<EPackage>(this.ePackages);
        ArrayList<EPackage> toCheckEPackages = new ArrayList<EPackage>(this.ePackages);
        ArrayList<EPackage> newFoundEPackages = new ArrayList<EPackage>();
        int cnt = 0;
        do {
            ++cnt;
            if (!newFoundEPackages.isEmpty()) {
                toCheckEPackages.clear();
                toCheckEPackages.addAll(newFoundEPackages);
                newFoundEPackages.clear();
            }
            for (EPackage ePackage : toCheckEPackages) {
                List<EPackage> newDependsOn = this.getNewDependsOn(ePackage, collectedEPackages);
                newFoundEPackages.addAll(newDependsOn);
            }
            collectedEPackages.addAll(newFoundEPackages);
            if (cnt <= 1000) continue;
            throw new IllegalStateException("More than a 1000 iterations, infinite cycle, illegal case, report on forum");
        } while (!newFoundEPackages.isEmpty());
        for (EPackage toCheckEPackage : new ArrayList<EPackage>(collectedEPackages)) {
            if (!toCheckEPackage.getNsURI().equals("http://www.eclipse.org/emf/2002/Ecore") && !toCheckEPackage.getNsURI().equals("http://www.eclipse.org/emf/2003/XMLType")) continue;
            collectedEPackages.remove(toCheckEPackage);
        }
        return collectedEPackages;
    }

    private List<EPackage> getNewDependsOn(EPackage ePackage, List<EPackage> collectedEPackages) {
        ArrayList<EPackage> epacks = new ArrayList<EPackage>();
        if (ePackage.getESuperPackage() != null && !collectedEPackages.contains(ePackage.getESuperPackage())) {
            epacks.add(ePackage.getESuperPackage());
        }
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EPackage refEPackage;
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EClass superEClass : eClass.getESuperTypes()) {
                if (superEClass.getEPackage() == ePackage || epacks.contains(superEClass.getEPackage())) continue;
                epacks.add(superEClass.getEPackage());
            }
            for (EReference eref : eClass.getEReferences()) {
                if (eref == null) {
                    throw new IllegalStateException("ERef is null " + eClass.getName());
                }
                if (eref.getEReferenceType() == null) {
                    throw new IllegalStateException("EReferenceType is null " + eref.getEContainingClass().getName() + "." + eref.getName());
                }
                refEPackage = eref.getEReferenceType().getEPackage();
                if (refEPackage == ePackage || epacks.contains(refEPackage)) continue;
                epacks.add(refEPackage);
            }
            for (EAttribute eattr : eClass.getEAttributes()) {
                if (eattr.getEType() == null || (refEPackage = eattr.getEType().getEPackage()) == ePackage || epacks.contains(refEPackage)) continue;
                epacks.add(refEPackage);
            }
        }
        epacks.removeAll(collectedEPackages);
        return epacks;
    }

    private void doAnnotate(ModelAnnotator modelAnnotator, List<EPackage> toHandleEPackages) {
        modelAnnotator.annotate(toHandleEPackages, this.annotationManager);
        modelAnnotator.postAnnotate(toHandleEPackages, this.annotationManager);
    }

    public List<EPackage> getEPackages() {
        return this.ePackages;
    }

    public void setEPackages(List<EPackage> ePackages) {
        this.ePackages = ePackages;
    }

    public boolean isAnnotated(ENamedElement eNamedElement, String nsPrefix) {
        return this.getAnnotation(eNamedElement, nsPrefix) != null;
    }

    public ENamedElementAnnotation getAnnotation(ENamedElement eNamedElement, String nsURI) {
        List<ENamedElementAnnotation> annotations = this.getAnnotationManager().getAnnotations(eNamedElement);
        for (ENamedElementAnnotation annotation : annotations) {
            if (annotation.getENamedElement() != eNamedElement || !annotation.eClass().getEPackage().getNsURI().equals(nsURI)) continue;
            return annotation;
        }
        ENamedElement localElement = eNamedElement;
        while (!(localElement instanceof EPackage)) {
            localElement = (ENamedElement)localElement.eContainer();
        }
        for (ModelAnnotator modelAnnotator : ModelAnnotatorRegistry.getInstance().getModelAnnotators()) {
            modelAnnotator.annotate(Collections.singletonList((EPackage)localElement), this.annotationManager);
            modelAnnotator.postAnnotate(Collections.singletonList((EPackage)localElement), this.annotationManager);
        }
        return this.getAnnotation(eNamedElement, nsURI);
    }

    public String getJavaAnnotations(ENamedElement eNamedElement, String identifier) {
        return this.getJavaAnnotations(eNamedElement, identifier, null);
    }

    public String getJavaAnnotations(ENamedElement eNamedElement, String identifier, ENamedElement context) {
        if (eNamedElement instanceof EEnumLiteral) {
            return this.getEEnumLiteralAnnotations(eNamedElement);
        }
        List<ENamedElementAnnotation> annotations = this.getAnnotationManager().getAnnotations(eNamedElement);
        StringBuilder sb = new StringBuilder();
        for (ENamedElementAnnotation annotation : annotations) {
            String javaAnnotation;
            if (context != null && !annotation.isValidForContext(context) || annotation.getENamedElement() != eNamedElement || annotation.getLastIdentifier() != null && (annotation.getLastIdentifier().equals("field") && (identifier.equals("getter") || identifier.equals("setter")) || annotation.getLastIdentifier().equals("featureMap.field") && (identifier.equals("featureMap.getter") || identifier.equals("featureMap.setter"))) || (javaAnnotation = annotation.getJavaAnnotation((AnnotationProvider)this, identifier)) == null || javaAnnotation.trim().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(javaAnnotation);
            annotation.setLastIdentifier(identifier);
        }
        return sb.toString();
    }

    private String getEEnumLiteralAnnotations(ENamedElement eNamedElement) {
        String identifier = "type";
        StringBuilder sb = new StringBuilder();
        for (EAnnotation eAnnotation : eNamedElement.getEAnnotations()) {
            if (!"texo.java.annotation".equals(eAnnotation.getSource())) continue;
            if (eAnnotation.getDetails().get((Object)"value") != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append((String)eAnnotation.getDetails().get((Object)"value"));
            }
            if (eAnnotation.getDetails().get((Object)"type") == null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append((String)eAnnotation.getDetails().get((Object)"type"));
        }
        return sb.toString();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public void setAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }
}

