/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.emf.texo.generator.ImportResolver;
import org.eclipse.emf.texo.generator.MergingOutputHandler;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.xpand2.output.FileHandle;

public class SourceMerger
extends MergingOutputHandler {
    private JControlModel jControlModel;
    private Object codeFormatter;
    private IJavaProject javaProject;

    @Override
    protected void merge(FileHandle fileHandle) {
        String targetLocation = fileHandle.getAbsolutePath();
        File targetFile = new File(targetLocation);
        Check.isNotNull((Object)targetFile, (String)("Targetfile is null, for outlet " + fileHandle.getOutlet().getPath()));
        String generatedSource = fileHandle.getBuffer().toString();
        generatedSource = generatedSource.replace("\t", "    ");
        try {
            if (targetFile.exists()) {
                this.mergeImportAndFormat(fileHandle, targetFile);
                return;
            }
            String source = this.organizeImports(targetLocation, generatedSource);
            source = EclipseGeneratorUtils.formatSource(source, this.getCodeFormatter());
            fileHandle.setBuffer((CharSequence)source);
        }
        catch (IllegalStateException c) {
            throw c;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while merging and saving source file in sourcemerger " + targetLocation + " " + e.getMessage() + " " + e + "\n" + generatedSource, e);
        }
    }

    private void mergeImportAndFormat(FileHandle fileHandle, File targetFile) throws Exception {
        String targetLocation = targetFile.getAbsolutePath();
        JControlModel localJControlModel = this.getJControlModel();
        JMerger jMerger = new JMerger(localJControlModel);
        jMerger.setFixInterfaceBrace(localJControlModel.getFacadeHelper().fixInterfaceBrace());
        String generatedSource = fileHandle.getBuffer().toString();
        String source = this.organizeImports(targetLocation, generatedSource);
        try {
            jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(source));
        }
        catch (WrappedException e) {
            throw new IllegalStateException("Syntax error in generated source for " + targetLocation + " :" + this.getExceptionMessage(e) + "\nSource>>>>>>>>>>>>>>>>>>>>>>>>>\n" + source, e);
        }
        FileInputStream is = new FileInputStream(targetFile);
        String newSource = "";
        int location = 0;
        try {
            try {
                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)is, "UTF-8"));
                location = 1;
                jMerger.merge();
                location = 2;
                newSource = jMerger.getTargetCompilationUnitContents();
                location = 3;
                newSource = this.organizeImports(targetLocation, newSource);
                location = 4;
                newSource = EclipseGeneratorUtils.formatSource(newSource, this.getCodeFormatter());
                this.jControlModel.getFacadeHelper().reset();
                location = 5;
                fileHandle.setBuffer((CharSequence)newSource);
            }
            catch (WrappedException e) {
                throw new IllegalStateException("Syntax error in current source for " + targetLocation + " :" + this.getExceptionMessage(e) + " location " + location + " old source \n" + source + " new source \n" + newSource, e);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Throwable caught for current source for " + targetLocation + " :" + this.getExceptionMessage(t) + " location " + location + " old source \n" + source + " new source \n" + newSource, t);
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private String organizeImports(String location, String source) throws Exception {
        ImportResolver importResolver = new ImportResolver();
        importResolver.setJavaProject(this.javaProject);
        importResolver.setSource(source);
        String resolvedSource = importResolver.resolve();
        return resolvedSource;
    }

    private String getExceptionMessage(Throwable t) {
        if (t.getCause() instanceof DiagnosticException) {
            DiagnosticException d = (DiagnosticException)t.getCause();
            StringBuilder message = new StringBuilder(d.getDiagnostic().getMessage());
            for (Diagnostic cd : d.getDiagnostic().getChildren()) {
                message.append("\n\t").append(cd.getMessage());
            }
            return message.toString();
        }
        return t.getMessage();
    }

    private JControlModel getJControlModel() {
        if (this.jControlModel == null) {
            this.jControlModel = new JControlModel();
            this.jControlModel.initialize((FacadeHelper)new ASTFacadeHelper(), this.getClass().getResource("texo-merge.xml").toExternalForm());
        }
        return this.jControlModel;
    }

    private Object getCodeFormatter() {
        if (this.codeFormatter == null) {
            this.codeFormatter = ToolFactory.createCodeFormatter((Map)this.javaProject.getOptions(true));
        }
        return this.codeFormatter;
    }

    @Override
    protected String[] getSupportedExtensions() {
        return new String[]{".java"};
    }

    @Override
    public void setProjectName(String projectName) {
        super.setProjectName(projectName);
        this.javaProject = EclipseGeneratorUtils.getJavaProject(projectName);
    }
}

