/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.generator.BaseTemplate;
import org.eclipse.emf.texo.generator.TexoResourceManager;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xtend.expression.ExceptionHandler;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.type.impl.java.JavaMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;

public class XPandTemplate
extends BaseTemplate
implements TexoComponent {
    private static final String MAIN_OBJECT = "mainObject";
    private Object mainObject;
    private String expand;
    private String template;
    private String generatedContent = "";
    private Map<String, String> files = new HashMap<String, String>();

    public void generate() {
        TexoResourceManager resourceManager = this.getArtifactGenerator().getResourceManager();
        if (!resourceManager.doesCustomTemplateExists(this.template)) {
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("modelController", this.getModelController());
        parameters.put("doDao", this.getArtifactGenerator().isDoDao());
        parameters.put(MAIN_OBJECT, this.mainObject);
        OutputCapture out = new OutputCapture();
        XpandExecutionContextImpl executionContext = new XpandExecutionContextImpl((ResourceManager)resourceManager, (Output)out, null, new HashMap(), null, this.getExceptionHandler(), null, null);
        executionContext.registerMetaModel((MetaModel)new JavaMetaModel());
        ExpandStatement es = this.getStatement();
        for (String name : parameters.keySet()) {
            executionContext = (XpandExecutionContextImpl)executionContext.cloneWithVariable(new Variable(name, parameters.get(name)));
        }
        es.evaluate((XpandExecutionContext)executionContext);
        if (out.getCurrentFile() == null && out.getCurrentContent().trim().length() > 0) {
            this.generatedContent = out.getCurrentContent().trim();
        }
    }

    public String getAllContent() {
        StringBuilder sb = new StringBuilder();
        for (String content : this.getFiles().values()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(content);
        }
        sb.append(this.generatedContent);
        return sb.toString();
    }

    private ExpandStatement getStatement() {
        Check.isNotNull((Object)this.expand, (String)"Template/expand not set");
        Template tpl = XpandParseFacade.file((Reader)new StringReader("\u00abDEFINE test FOR test\u00bb\u00abEXPAND " + this.expand + "\u00bb" + "\u00ab" + "ENDDEFINE" + "\u00bb"), null);
        return (ExpandStatement)((Definition)tpl.getDefinitions()[0]).getBody()[1];
    }

    protected ExceptionHandler getExceptionHandler() {
        return new ExceptionHandler(){

            public void handleRuntimeException(RuntimeException ex, SyntaxElement element, ExecutionContext ctx, Map<String, Object> additionalContextInfo) {
                throw ex;
            }
        };
    }

    @Override
    public void addFile(String name, String content) {
        this.files.put(name, content);
    }

    @Override
    public void addFiles(Map<String, String> newFiles) {
        this.files.putAll(newFiles);
    }

    @Override
    public void clearFiles() {
        this.files.clear();
    }

    @Override
    public Map<String, String> getFiles() {
        return this.files;
    }

    protected Object getMainObject() {
        return this.mainObject;
    }

    protected void setMainObject(Object mainObject) {
        this.mainObject = mainObject;
    }

    public void setXPandTemplate(String template) {
        this.template = template;
        this.expand = template.endsWith("modelpackage") ? String.valueOf(template) + "::root(modelController, doDao) FOR mainObject" : String.valueOf(template) + "::root(modelController) FOR mainObject";
    }

    private class OutputCapture
    extends OutputImpl {
        private String currentFile;
        private String currentContent = "";

        private OutputCapture() {
        }

        public void write(String bytes) {
            this.currentContent = String.valueOf(this.currentContent) + bytes;
            super.write(bytes);
        }

        public void openFile(String path, String outletName) {
            if (super.getOutlet(outletName) == null) {
                Outlet localOutlet = new Outlet();
                localOutlet.setName(outletName);
                super.addOutlet(localOutlet);
            }
            this.currentFile = path;
            this.currentContent = "";
            super.openFile(path, outletName);
        }

        public void closeFile() {
            XPandTemplate.this.addFile(this.currentFile, this.current().getBuffer().toString());
        }

        protected String getCurrentFile() {
            return this.currentFile;
        }

        protected String getCurrentContent() {
            return this.currentContent.trim();
        }
    }
}

