/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.json;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.client.model.request.ActionType;
import org.eclipse.emf.texo.client.model.request.Parameter;
import org.eclipse.emf.texo.client.model.request.QueryReferingObjectsType;
import org.eclipse.emf.texo.client.model.request.QueryType;
import org.eclipse.emf.texo.client.model.request.RequestFactory;
import org.eclipse.emf.texo.client.model.request.RequestPackage;
import org.eclipse.emf.texo.client.model.response.ResponsePackage;
import org.eclipse.emf.texo.client.model.response.ResponseType;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.json.EMFJSONConverter;
import org.eclipse.emf.texo.json.JSONEMFConverter;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.store.EObjectStore;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONEObjectStore
extends EObjectStore {
    private static final String UTF8 = "UTF-8";
    private static final String POST_METHOD = "POST";
    private static final String GET_METHOD = "GET";

    public static void initEPackages() {
        RequestPackage.eINSTANCE.getActionType();
        ResponsePackage.eINSTANCE.getDocumentRoot();
    }

    public JSONEObjectStore() {
        this.setUseWebServiceUriFormat(true);
        JSONEObjectStore.initEPackages();
    }

    protected String doHTTPRequest(String urlStr, String method, String content) throws Exception {
        String line;
        String localUrlStr = urlStr == null ? this.getUri().toString() : urlStr;
        URL url = new URL(this.adaptUrl(localUrlStr));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Accept-Charset", UTF8);
        this.beforeConnect(conn);
        if (content != null) {
            byte[] bytes = content.getBytes(UTF8);
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            OutputStream os = conn.getOutputStream();
            os.write(bytes);
            os.flush();
            os.close();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), UTF8));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        rd.close();
        return this.afterRead(conn, sb.toString());
    }

    protected String afterRead(HttpURLConnection conn, String content) {
        return content;
    }

    protected String adaptUrl(String url) {
        return url;
    }

    protected void beforeConnect(HttpURLConnection conn) {
    }

    public void persist(List<EObject> eObjectsToInsert, List<EObject> eObjectsToUpdate, List<EObject> eObjectsToDelete) {
        List<EObject> toInsert = this.removeMapEntries(eObjectsToInsert);
        List<EObject> toUpdate = this.removeMapEntries(eObjectsToUpdate);
        List<EObject> toDelete = this.removeMapEntries(eObjectsToDelete);
        toUpdate.removeAll(toDelete);
        toInsert.removeAll(toDelete);
        toUpdate.removeAll(toInsert);
        for (EObject eObject : toInsert) {
            URI tempURI = ModelUtils.makeTempURI((URI)this.toURI(eObject.eClass(), "" + System.currentTimeMillis()));
            ((InternalEObject)eObject).eSetProxyURI(tempURI);
            this.addToCache(eObject);
        }
        ActionType actionType = RequestFactory.eINSTANCE.createActionType();
        actionType.getDelete().addAll(EcoreUtil.copyAll(toDelete));
        actionType.getInsert().addAll(EcoreUtil.copyAll(toInsert));
        actionType.getUpdate().addAll(EcoreUtil.copyAll(toUpdate));
        JSONObject jsonObject = this.doRequest(actionType, POST_METHOD);
        JSONEMFConverter jsonEmfConverter = (JSONEMFConverter)ComponentProvider.getInstance().newInstance(JSONEMFConverter.class);
        jsonEmfConverter.setObjectResolver((ObjectResolver)this);
        try {
            JSONArray insertedJsonArray = jsonObject.getJSONArray(ResponsePackage.eINSTANCE.getResultType_Inserted().getName());
            int i = 0;
            for (EObject insertedEObject : toInsert) {
                JSONObject insertedJsonObject = insertedJsonArray.getJSONObject(i++);
                boolean hasIdEAttribute = IdProvider.getInstance().hasIdEAttribute(insertedEObject.eClass());
                if (!hasIdEAttribute) continue;
                EAttribute idEAttribute = IdProvider.getInstance().getIdEAttribute(insertedEObject.eClass());
                Object id = insertedJsonObject.get(idEAttribute.getName());
                this.removeFromCache(((InternalEObject)insertedEObject).eProxyURI());
                URI newUri = this.toURI(insertedEObject.eClass(), "" + id);
                ((InternalEObject)insertedEObject).eSetProxyURI(null);
                this.addToCache(newUri.toString(), insertedEObject);
            }
            ArrayList allInsertedUpdated = new ArrayList();
            ArrayList<EObject> allToInsertedUpdated = new ArrayList<EObject>();
            allToInsertedUpdated.addAll(toInsert);
            allToInsertedUpdated.addAll(toUpdate);
            allInsertedUpdated.addAll(jsonEmfConverter.convert(insertedJsonArray));
            allInsertedUpdated.addAll(jsonEmfConverter.convert(jsonObject.getJSONArray(ResponsePackage.eINSTANCE.getResultType_Updated().getName())));
            if (allInsertedUpdated.size() != allToInsertedUpdated.size()) {
                throw new IllegalStateException("Unexpected size of returned data " + allInsertedUpdated.size() + " - " + allToInsertedUpdated.size());
            }
            for (EObject eObject : allInsertedUpdated) {
                boolean hasIdEAttribute = IdProvider.getInstance().hasIdEAttribute(eObject.eClass());
                if (!hasIdEAttribute) continue;
                boolean found = false;
                for (EObject otherObject : allToInsertedUpdated) {
                    if (otherObject != eObject) continue;
                    if (found) {
                        throw new IllegalStateException("Object " + eObject + " occurs multiple times in result set");
                    }
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException("Object " + eObject + " not found in result set");
            }
            for (EObject eObject : toDelete) {
                this.deleted(eObject);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<EObject> removeMapEntries(List<EObject> list) {
        ArrayList<EObject> result = new ArrayList<EObject>(list);
        ListIterator iterator = result.listIterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Map.Entry)) continue;
            iterator.remove();
        }
        return result;
    }

    protected JSONObject doRequest(EObject requestObject, String method) {
        String result = "";
        try {
            EMFJSONConverter emfJsonConverter = (EMFJSONConverter)((Object)ComponentProvider.getInstance().newInstance(EMFJSONConverter.class));
            emfJsonConverter.setObjectResolver((ObjectResolver)this);
            String json = null;
            if (requestObject != null) {
                json = emfJsonConverter.convert(requestObject).toString();
            }
            result = this.doHTTPRequest(null, method, json);
            return new JSONObject(result);
        }
        catch (JSONException je) {
            throw new RuntimeException(String.valueOf(je.getMessage()) + result, je);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<EObject> query(String qryStr, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        QueryType queryType = RequestFactory.eINSTANCE.createQueryType();
        for (String key : namedParameters.keySet()) {
            Object value = namedParameters.get(key);
            if (value == null) continue;
            Parameter parameter = RequestFactory.eINSTANCE.createParameter();
            parameter.setName(key);
            if (value instanceof Timestamp) {
                parameter.setType("dateTime");
            } else if (value instanceof Date) {
                parameter.setType("date");
            }
            parameter.setValue(value);
            queryType.getParameters().add((Object)parameter);
        }
        queryType.setQuery(qryStr);
        queryType.setFirstResult(firstResult);
        queryType.setMaxResults(maxResults);
        queryType.setDoCount(false);
        queryType.setCountOperation(false);
        JSONObject jsonObject = this.doRequest(queryType, POST_METHOD);
        JSONEMFConverter jsonEmfConverter = (JSONEMFConverter)ComponentProvider.getInstance().newInstance(JSONEMFConverter.class);
        jsonEmfConverter.setObjectResolver((ObjectResolver)this);
        try {
            List<EObject> data = jsonEmfConverter.convert(jsonObject.getJSONArray(ResponsePackage.eINSTANCE.getResponseType_Data().getName()));
            for (EObject eObject : data) {
                this.addToCache(eObject);
            }
            return data;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public long count(String qry, Map<String, Object> namedParameters) {
        QueryType queryType = RequestFactory.eINSTANCE.createQueryType();
        for (String key : namedParameters.keySet()) {
            Object value = namedParameters.get(key);
            if (value == null) continue;
            Parameter parameter = RequestFactory.eINSTANCE.createParameter();
            parameter.setName(key);
            if (value instanceof Timestamp) {
                parameter.setType("dateTime");
            } else if (value instanceof Date) {
                parameter.setType("date");
            }
            parameter.setValue(value);
            queryType.getParameters().add((Object)parameter);
        }
        queryType.setQuery(qry);
        queryType.setDoCount(false);
        queryType.setCountOperation(true);
        JSONObject jsonObject = this.doRequest(queryType, POST_METHOD);
        JSONEMFConverter jsonEmfConverter = (JSONEMFConverter)ComponentProvider.getInstance().newInstance(JSONEMFConverter.class);
        jsonEmfConverter.setObjectResolver((ObjectResolver)this);
        ResponseType response = (ResponseType)jsonEmfConverter.convert(jsonObject);
        return response.getTotalRows();
    }

    protected EObject loadEObject(EClass eClass, String idString) {
        try {
            URI uri = this.toURI(eClass, idString);
            String json = this.doHTTPRequest(uri.toString(), GET_METHOD, null);
            JSONEMFConverter jsonEmfConverter = (JSONEMFConverter)ComponentProvider.getInstance().newInstance(JSONEMFConverter.class);
            jsonEmfConverter.setObjectResolver((ObjectResolver)this);
            EObject response = (EObject)jsonEmfConverter.convert(new JSONObject(json));
            this.addToCache(response);
            return response;
        }
        catch (FileNotFoundException f) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void refresh(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (!IdProvider.getInstance().hasIdEAttribute(eClass)) {
            return;
        }
        String idString = "" + eObject.eGet((EStructuralFeature)IdProvider.getInstance().getIdEAttribute(eClass));
        this.loadEObject(eClass, idString);
    }

    public List<EObject> getReferingObjects(EObject eTarget, int maxResult, boolean includeContainerReferences) {
        URI uri = this.toUri(eTarget);
        if (uri == null) {
            return Collections.emptyList();
        }
        QueryReferingObjectsType queryType = RequestFactory.eINSTANCE.createQueryReferingObjectsType();
        queryType.setMaxResults(maxResult);
        queryType.setTargetUri(uri.toString());
        queryType.setIncludeContainerReferences(includeContainerReferences);
        JSONObject jsonObject = this.doRequest(queryType, POST_METHOD);
        JSONEMFConverter jsonEmfConverter = (JSONEMFConverter)ComponentProvider.getInstance().newInstance(JSONEMFConverter.class);
        jsonEmfConverter.setObjectResolver((ObjectResolver)this);
        try {
            List<EObject> data = jsonEmfConverter.convert(jsonObject.getJSONArray(ResponsePackage.eINSTANCE.getResponseType_Data().getName()));
            for (EObject eObject : data) {
                this.addToCache(eObject);
            }
            return data;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

