/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.json;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.json.BaseJSONModelConverter;
import org.eclipse.emf.texo.model.DynamicModelObject;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONModelConverter
extends BaseJSONModelConverter<Object> {
    private Object lastObject = null;
    private ModelObject<?> lastModelObject = null;

    private ModelObject<?> getModelObject(Object target) {
        if (target == this.lastObject) {
            return this.lastModelObject;
        }
        this.lastObject = target;
        this.lastModelObject = ModelResolver.getInstance().getModelObject(target);
        return this.lastModelObject;
    }

    @Override
    protected boolean setBidirectionalReferences() {
        return true;
    }

    @Override
    protected Object fromUri(String uriString) {
        return this.getObjectResolver().fromUri(URI.createURI((String)uriString));
    }

    @Override
    protected Object create(EClass eClass, String uriString) {
        if (ModelResolver.getInstance().isModeledEClassifier((EClassifier)eClass)) {
            return ModelResolver.getInstance().create(eClass);
        }
        DynamicModelObject dmo = (DynamicModelObject)ComponentProvider.getInstance().newInstance(DynamicModelObject.class);
        dmo.setEClass(eClass);
        return dmo;
    }

    @Override
    protected EClass eClass(Object target) {
        return this.getModelObject(target).eClass();
    }

    @Override
    protected void eSet(Object target, EStructuralFeature eFeature, Object value) {
        this.getModelObject(target).eSet(eFeature, value);
    }

    @Override
    protected Object eGet(Object target, EStructuralFeature eFeature) {
        return this.getModelObject(target).eGet(eFeature);
    }

    @Override
    protected Object createFeatureMapEntry(Object target, EStructuralFeature eFeature, JSONObject jValue) {
        try {
            Object featureMapEntry = ModelResolver.getInstance().createFeatureMapEntry(eFeature);
            ModelFeatureMapEntry mEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, featureMapEntry);
            EStructuralFeature entryFeature = ModelUtils.getEStructuralFeatureFromQualifiedName((String)jValue.getString("_efeature"));
            mEntry.setEStructuralFeature(entryFeature);
            Object convertedValue = mEntry.getEStructuralFeature() instanceof EAttribute ? this.getJSONValueConverter().fromJSON(target, jValue.get("value"), ((EAttribute)entryFeature).getEAttributeType()) : this.doConvert(jValue.getJSONObject("value"));
            mEntry.setValue(convertedValue);
            return mEntry.getTarget();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void eRemoveFrom(Object target, EStructuralFeature eFeature, Object value) {
        this.getModelObject(target).eRemoveFrom(eFeature, value);
    }

    @Override
    protected void eAddTo(Object target, EStructuralFeature eFeature, Object value) {
        this.getModelObject(target).eAddTo(eFeature, value);
    }
}

