/**
 * Copyright (c) 2012 Springsite BV (http://www.springsite.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Author - Martin Taal
 */
package org.eclipse.emf.texo.modelgenerator.xtend;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.generator.BaseTemplate;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.xtend.TemplateUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class FeatureGroupTemplate extends BaseTemplate {
  public void generate(final EStructuralFeatureModelGenAnnotation eStructuralFeatureModelGenAnnotation) {
    EClassModelGenAnnotation _ownerEClassAnnotation = eStructuralFeatureModelGenAnnotation.getOwnerEClassAnnotation();
    EClassModelGenAnnotation eClassAnnotation = ((EClassModelGenAnnotation) _ownerEClassAnnotation);
    EPackageModelGenAnnotation _ownerEPackageAnnotation = eClassAnnotation.getOwnerEPackageAnnotation();
    EPackageModelGenAnnotation ePackageAnnotation = ((EPackageModelGenAnnotation) _ownerEPackageAnnotation);
    boolean _executeOverrides = this.executeOverrides(eStructuralFeatureModelGenAnnotation);
    if (_executeOverrides) {
      return;
    }
    String fileName = TemplateUtil.classFileName(eStructuralFeatureModelGenAnnotation);
    ModelController _modelController = this.getModelController();
    String content = this.generateContent(_modelController, eStructuralFeatureModelGenAnnotation, eClassAnnotation, ePackageAnnotation);
    this.addFile(fileName, content);
  }
  
  @Override
  public List<String> getTemplateOverrides() {
    List<String> list = new ArrayList<String>();
    list.add("org::eclipse::emf::texo::modelgenerator::templates::featuregroup");
    list.add("org::eclipse::emf::texo::modelgenerator::xtend::FeatureGroupTemplate");
    return list;
  }
  
  public String generateContent(final ModelController modelController, final EStructuralFeatureModelGenAnnotation eStructuralFeatureModelGenAnnotation, final EClassModelGenAnnotation eClassAnnotation, final EPackageModelGenAnnotation ePackageAnnotation) {
    StringConcatenation _builder = new StringConcatenation();
    String _javaFileHeader = ePackageAnnotation.getJavaFileHeader();
    _builder.append(_javaFileHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    String _packagePath = ePackageAnnotation.getPackagePath();
    _builder.append(_packagePath, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* A representation for the Feature Group \'<em><b>");
    EClass _eClass = eClassAnnotation.getEClass();
    String _name = _eClass.getName();
    _builder.append(_name, " ");
    _builder.append(".");
    String _name_1 = eStructuralFeatureModelGenAnnotation.getName();
    _builder.append(_name_1, " ");
    _builder.append("</b></em>\'.");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    {
      String _documentation = eStructuralFeatureModelGenAnnotation.getDocumentation();
      boolean _notEquals = (!Objects.equal(_documentation, null));
      if (_notEquals) {
        _builder.append("* <!-- begin-model-doc -->");
        _builder.newLine();
        _builder.append("* ");
        String _documentation_1 = eStructuralFeatureModelGenAnnotation.getDocumentation();
        _builder.append(_documentation_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("* <!-- end-model-doc -->");
        _builder.newLine();
      }
    }
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("*/");
    _builder.newLine();
    EStructuralFeature _eStructuralFeature = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
    String _javaAnnotations = modelController.getJavaAnnotations(_eStructuralFeature, "featureMap.type");
    _builder.append(_javaAnnotations, "");
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _featureMapSimpleClassName = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName, "");
    _builder.newLineIfNotEmpty();
    {
      if (((!Objects.equal(ePackageAnnotation.getFeatureMapClassExtends(), null)) && (ePackageAnnotation.getFeatureMapClassExtends().trim().length() > 0))) {
        _builder.append(" extends ");
        String _featureMapClassExtends = ePackageAnnotation.getFeatureMapClassExtends();
        _builder.append(_featureMapClassExtends, "");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* Is used to identify which feature is set in this feature group.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static enum Feature {");
    _builder.newLine();
    _builder.append("    ");
    {
      EStructuralFeature _eStructuralFeature_1 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
      boolean _isMixed = TemplateUtil.isMixed(_eStructuralFeature_1);
      if (_isMixed) {
        _builder.append("TEXT, CDATA, COMMENT");
        {
          List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
          int _size = _allMemberFeatureMapFeatures.size();
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            _builder.append(",");
          }
        }
      }
    }
    _builder.newLineIfNotEmpty();
    {
      List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_1 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
      boolean _hasElements = false;
      for(final EStructuralFeatureModelGenAnnotation memberFeatureAnnotation : _allMemberFeatureMapFeatures_1) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "    ");
        }
        {
          boolean _isGenerateCode = memberFeatureAnnotation.isGenerateCode();
          if (_isGenerateCode) {
            String _name_2 = memberFeatureAnnotation.getName();
            String _upperCase = TemplateUtil.toUpperCase(_name_2);
            _builder.append(_upperCase, "");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* Returns only the values from the feature group which have the feature equal to the parameter.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param featureGroup the featureGroup List to filter");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param filterByFeature filters by this enum");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @return a list with instances corresponding to the feature kind");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @see java.util.Collections#unmodifiableList(List)");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@SuppressWarnings(\"unchecked\")");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static <T> java.util.List<T> createUnmodifiableValueList(java.util.List<");
    String _featureMapSimpleClassName_1 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_1, "    ");
    _builder.append("> featureGroup, Feature filterByFeature) {");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("final java.util.List<Object> result = new java.util.ArrayList<Object>();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("for (final ");
    String _featureMapSimpleClassName_2 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_2, "        ");
    _builder.append(" group : featureGroup) {");
    _builder.newLineIfNotEmpty();
    _builder.append("            ");
    _builder.append("if (group.getFeature() == filterByFeature) {");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("result.add(group.getValue());");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return (List<T>) Collections.unmodifiableList(result);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* Returns a single value from the feature group which has the feature equal to the parameter.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* The first found value is returned. If no value can be found then null is returned.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param featureGroup the featureGroup List to filter");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param filterByFeature filters by this enum");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @return an instance corresponding to the feature kind or null if not found.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@SuppressWarnings(\"unchecked\")");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static <T> T getSingleFeatureMapValue(java.util.List<");
    String _featureMapSimpleClassName_3 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_3, "    ");
    _builder.append("> featureGroup, Feature filterByFeature) {");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("for (final ");
    String _featureMapSimpleClassName_4 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_4, "        ");
    _builder.append(" group : featureGroup) {");
    _builder.newLineIfNotEmpty();
    _builder.append("            ");
    _builder.append("if (group.getFeature() == filterByFeature) {");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("return (T)group.getValue();");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* Sets a single value in a feature group, if there is already a value set in the feature");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* for the feature in question then it is replaced by the new value.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param featureGroup the featureGroup List to find the value");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param feature sets this feature");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param value the value to set");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static void setSingleFeatureMapValue(java.util.List<");
    String _featureMapSimpleClassName_5 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_5, "    ");
    _builder.append("> featureGroup, Feature feature, Object value) {");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("for (final ");
    String _featureMapSimpleClassName_6 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_6, "        ");
    _builder.append(" group : featureGroup) {");
    _builder.newLineIfNotEmpty();
    _builder.append("            ");
    _builder.append("if (group.getFeature() == feature) {");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("group.setValue(feature, value);");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("final ");
    String _featureMapSimpleClassName_7 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_7, "        ");
    _builder.append(" entry = new ");
    String _featureMapSimpleClassName_8 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_8, "        ");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("entry.setValue(feature, value);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("featureGroup.add(entry);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* Creates a list of group instances set with the passed feature and values.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param feature the feature to set");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param values the values to set as value of each group instance in the result.");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @return a list with instances of this class, set with the Feature and values");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static java.util.List<");
    String _featureMapSimpleClassName_9 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_9, "    ");
    _builder.append("> createFeatureGroupList(Feature feature, List<?> values) {");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("final java.util.List<");
    String _featureMapSimpleClassName_10 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_10, "        ");
    _builder.append("> result = new java.util.ArrayList<");
    String _featureMapSimpleClassName_11 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_11, "        ");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("for (Object value : values) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("final ");
    String _featureMapSimpleClassName_12 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_12, "            ");
    _builder.append(" group = new ");
    String _featureMapSimpleClassName_13 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
    _builder.append(_featureMapSimpleClassName_13, "            ");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("            ");
    _builder.append("group.setValue(feature, value);");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("result.add(group);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    EStructuralFeature _eStructuralFeature_2 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
    String _javaAnnotations_1 = modelController.getJavaAnnotations(_eStructuralFeature_2, "featureMap.feature");
    _builder.append(_javaAnnotations_1, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("private Feature feature = null;");
    _builder.newLine();
    _builder.newLine();
    {
      EStructuralFeature _eStructuralFeature_3 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
      boolean _isMixed_1 = TemplateUtil.isMixed(_eStructuralFeature_3);
      if (_isMixed_1) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_4 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        String _javaAnnotations_2 = modelController.getJavaAnnotations(_eStructuralFeature_4, "featureMap.text");
        _builder.append(_javaAnnotations_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append("private String text;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_5 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        String _javaAnnotations_3 = modelController.getJavaAnnotations(_eStructuralFeature_5, "featureMap.cdata");
        _builder.append(_javaAnnotations_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append("private String cDATA;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_6 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        String _javaAnnotations_4 = modelController.getJavaAnnotations(_eStructuralFeature_6, "featureMap.comment");
        _builder.append(_javaAnnotations_4, "");
        _builder.newLineIfNotEmpty();
        _builder.append("private String comment;");
        _builder.newLine();
      }
    }
    {
      EList<EStructuralFeatureModelGenAnnotation> _memberFeatureMapFeatures = eStructuralFeatureModelGenAnnotation.getMemberFeatureMapFeatures();
      for(final EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_1 : _memberFeatureMapFeatures) {
        _builder.newLine();
        {
          if ((memberFeatureAnnotation_1.isGenerateCode() && Objects.equal(memberFeatureAnnotation_1.getFeatureMapFeature(), eStructuralFeatureModelGenAnnotation))) {
            _builder.append("    ");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("    ");
            _builder.append(" ");
            _builder.append("* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append("    ");
            _builder.append(" ");
            _builder.append("* @generated");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("    ");
            EStructuralFeature _eStructuralFeature_7 = memberFeatureAnnotation_1.getEStructuralFeature();
            String _javaAnnotations_5 = modelController.getJavaAnnotations(_eStructuralFeature_7, "featureMap.field");
            _builder.append(_javaAnnotations_5, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("private ");
            String _itemType = memberFeatureAnnotation_1.getItemType();
            _builder.append(_itemType, "    ");
            _builder.append(" ");
            String _validJavaMemberName = memberFeatureAnnotation_1.getValidJavaMemberName();
            _builder.append(_validJavaMemberName, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @param feature the EStructuralFeature of this feature map entry");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public void setFeature(Feature feature) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("this.feature = feature;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @return feature the EStructuralFeature of this feature map entry");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public Feature getFeature() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return feature;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      EStructuralFeature _eStructuralFeature_8 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
      boolean _isMixed_2 = TemplateUtil.isMixed(_eStructuralFeature_8);
      if (_isMixed_2) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Returns the value of \'<em><b>text</b></em>\' feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the value of \'<em><b>text</b></em>\' feature");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public String getText() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return text;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Sets the <em>text</em> feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param newText the new value of the \'<em><b>text</b></em>\' feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public void setText(String newText) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("text = newText;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setFeature(Feature.TEXT);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Returns the value of \'<em><b>CDATA</b></em>\' feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the value of \'<em><b>CDATA</b></em>\' feature");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public String getCDATA() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return cDATA;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Sets the <em>cDATA</em> feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param newCDATA the new value of the \'<em><b>CDATA</b></em>\' feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public void setCDATA(String newCDATA) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("cDATA = newCDATA;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setFeature(Feature.CDATA);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Returns the value of \'<em><b>comment</b></em>\' feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the value of \'<em><b>comment</b></em>\' feature");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public String getComment() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return comment;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Sets the <em>comment</em> feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param newComment the new value of the \'<em><b>comment</b></em>\' feature.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public void setComment(String newComment) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("comment = newComment;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setFeature(Feature.COMMENT);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_2 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
      for(final EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_2 : _allMemberFeatureMapFeatures_2) {
        _builder.newLine();
        {
          boolean _isGenerateCode_1 = memberFeatureAnnotation_2.isGenerateCode();
          if (_isGenerateCode_1) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Returns the value of \'<em><b>");
            EStructuralFeature _eStructuralFeature_9 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_3 = _eStructuralFeature_9.getName();
            _builder.append(_name_3, " ");
            _builder.append("</b></em>\' feature.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @return the value of \'<em><b>");
            EStructuralFeature _eStructuralFeature_10 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_4 = _eStructuralFeature_10.getName();
            _builder.append(_name_4, " ");
            _builder.append("</b></em>\' feature");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* @generated");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_11 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _javaAnnotations_6 = modelController.getJavaAnnotations(_eStructuralFeature_11, "featureMap.getter");
            _builder.append(_javaAnnotations_6, "");
            _builder.newLineIfNotEmpty();
            _builder.append("public ");
            String _itemType_1 = memberFeatureAnnotation_2.getItemType();
            _builder.append(_itemType_1, "");
            _builder.append(" ");
            String _getter = memberFeatureAnnotation_2.getGetter();
            _builder.append(_getter, "");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            {
              EStructuralFeatureModelGenAnnotation _featureMapFeature = memberFeatureAnnotation_2.getFeatureMapFeature();
              boolean _equals = Objects.equal(_featureMapFeature, eStructuralFeatureModelGenAnnotation);
              if (_equals) {
                _builder.append("return ");
                String _validJavaMemberName_1 = memberFeatureAnnotation_2.getValidJavaMemberName();
                _builder.append(_validJavaMemberName_1, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("if (");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_1 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_1 = _featureMapFeature_1.getGetter();
                _builder.append(_getter_1, "");
                _builder.append("() == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("return null;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.append("return ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_2 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_2 = _featureMapFeature_2.getGetter();
                _builder.append(_getter_2, "");
                _builder.append("().");
                String _getter_3 = memberFeatureAnnotation_2.getGetter();
                _builder.append(_getter_3, "");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Sets the \'{@link ");
            String _simpleClassName = eClassAnnotation.getSimpleClassName();
            _builder.append(_simpleClassName, " ");
            _builder.append("#");
            String _getter_4 = memberFeatureAnnotation_2.getGetter();
            _builder.append(_getter_4, " ");
            _builder.append("() <em>");
            EStructuralFeature _eStructuralFeature_12 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_5 = _eStructuralFeature_12.getName();
            _builder.append(_name_5, " ");
            _builder.append("</em>}\' feature.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param new");
            String _name_6 = memberFeatureAnnotation_2.getName();
            String _firstUpper = TemplateUtil.toFirstUpper(_name_6);
            _builder.append(_firstUpper, " ");
            _builder.append(" the new value of the \'{@link ");
            String _simpleClassName_1 = eClassAnnotation.getSimpleClassName();
            _builder.append(_simpleClassName_1, " ");
            _builder.append("#");
            String _getter_5 = memberFeatureAnnotation_2.getGetter();
            _builder.append(_getter_5, " ");
            _builder.append("() ");
            EStructuralFeature _eStructuralFeature_13 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_7 = _eStructuralFeature_13.getName();
            _builder.append(_name_7, " ");
            _builder.append("}\' feature.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* @generated");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_14 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _javaAnnotations_7 = modelController.getJavaAnnotations(_eStructuralFeature_14, "featureMap.setter");
            _builder.append(_javaAnnotations_7, "");
            _builder.newLineIfNotEmpty();
            _builder.append("public void ");
            String _setter = memberFeatureAnnotation_2.getSetter();
            _builder.append(_setter, "");
            _builder.append("(");
            String _itemType_2 = memberFeatureAnnotation_2.getItemType();
            _builder.append(_itemType_2, "");
            _builder.append(" new");
            String _name_8 = memberFeatureAnnotation_2.getName();
            String _firstUpper_1 = TemplateUtil.toFirstUpper(_name_8);
            _builder.append(_firstUpper_1, "");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            {
              EStructuralFeatureModelGenAnnotation _featureMapFeature_3 = memberFeatureAnnotation_2.getFeatureMapFeature();
              boolean _equals_1 = Objects.equal(_featureMapFeature_3, eStructuralFeatureModelGenAnnotation);
              if (_equals_1) {
                _builder.append("    ");
                String _validJavaMemberName_2 = memberFeatureAnnotation_2.getValidJavaMemberName();
                _builder.append(_validJavaMemberName_2, "    ");
                _builder.append(" = new");
                String _name_9 = memberFeatureAnnotation_2.getName();
                String _firstUpper_2 = TemplateUtil.toFirstUpper(_name_9);
                _builder.append(_firstUpper_2, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("setFeature(Feature.");
                String _name_10 = memberFeatureAnnotation_2.getName();
                String _upperCase_1 = TemplateUtil.toUpperCase(_name_10);
                _builder.append(_upperCase_1, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("    ");
                _builder.append("if (");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_4 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_6 = _featureMapFeature_4.getGetter();
                _builder.append(_getter_6, "    ");
                _builder.append("() == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_5 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _setter_1 = _featureMapFeature_5.getSetter();
                _builder.append(_setter_1, "        ");
                _builder.append("(new ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_6 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _featureMapQualifiedClassName = _featureMapFeature_6.getFeatureMapQualifiedClassName();
                _builder.append(_featureMapQualifiedClassName, "        ");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_7 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_7 = _featureMapFeature_7.getGetter();
                _builder.append(_getter_7, "    ");
                _builder.append("().");
                String _setter_2 = memberFeatureAnnotation_2.getSetter();
                _builder.append(_setter_2, "    ");
                _builder.append("(new");
                String _name_11 = memberFeatureAnnotation_2.getName();
                String _firstUpper_3 = TemplateUtil.toFirstUpper(_name_11);
                _builder.append(_firstUpper_3, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* @return the value of this feature map entry. The type of the returned value is based on the feature.");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* @see #getFeature()");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public Object getValue() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("switch (getFeature()) {");
    _builder.newLine();
    {
      EStructuralFeature _eStructuralFeature_15 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
      boolean _isMixed_3 = TemplateUtil.isMixed(_eStructuralFeature_15);
      if (_isMixed_3) {
        _builder.append("case TEXT:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return getText();");
        _builder.newLine();
        _builder.append("case CDATA:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return getCDATA();");
        _builder.newLine();
        _builder.append("case COMMENT:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return getComment();");
        _builder.newLine();
      }
    }
    {
      List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_3 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
      for(final EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_3 : _allMemberFeatureMapFeatures_3) {
        _builder.append("    ");
        _builder.append("case ");
        String _name_12 = memberFeatureAnnotation_3.getName();
        String _upperCase_2 = TemplateUtil.toUpperCase(_name_12);
        _builder.append(_upperCase_2, "    ");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("    ");
        _builder.append("return ");
        String _getter_8 = memberFeatureAnnotation_3.getGetter();
        _builder.append(_getter_8, "        ");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("            ");
    _builder.append("default:");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("throw new IllegalStateException(\"Feature kind \" + getFeature() + \" is not supported for this object \" + this);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* <!-- begin-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* <!-- end-user-doc -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* @param feature the feature to set");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* @param value the value to set in this instance");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("* @see #getFeature()");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public void setValue(Feature feature, Object value) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("switch (feature) {");
    _builder.newLine();
    {
      EStructuralFeature _eStructuralFeature_16 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
      boolean _isMixed_4 = TemplateUtil.isMixed(_eStructuralFeature_16);
      if (_isMixed_4) {
        _builder.append("case TEXT:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setText((String)value);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("case CDATA:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setCDATA((String)value);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("case COMMENT:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setComment((String)value);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("break;");
        _builder.newLine();
      }
    }
    {
      List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_4 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
      for(final EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_4 : _allMemberFeatureMapFeatures_4) {
        {
          boolean _isGenerateCode_2 = memberFeatureAnnotation_4.isGenerateCode();
          if (_isGenerateCode_2) {
            _builder.append("case ");
            String _name_13 = memberFeatureAnnotation_4.getName();
            String _upperCase_3 = TemplateUtil.toUpperCase(_name_13);
            _builder.append(_upperCase_3, "");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            String _setter_3 = memberFeatureAnnotation_4.getSetter();
            _builder.append(_setter_3, "    ");
            _builder.append("((");
            String _itemType_3 = memberFeatureAnnotation_4.getItemType();
            _builder.append(_itemType_3, "    ");
            _builder.append(")value);");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("            ");
    _builder.append("default:");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("throw new IllegalStateException(\"Feature kind \" + getFeature() + \" is not supported for this object \" + this);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
}
