/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Literals {
    private static final SimpleDateFormat xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");

    private Literals() {
    }

    public static String toLiteral(Class<?> clz, Object value) {
        if (!clz.isArray()) {
            return Literals.toLiteral(clz, value.toString());
        }
        Class<?> componentType = clz.getComponentType();
        StringBuilder sb = new StringBuilder();
        sb.append("new " + componentType.getName() + "[]{");
        int i = 0;
        while (i < Array.getLength(value)) {
            Object o = Array.get(value, i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(Literals.toLiteral(componentType, o));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toLiteral(Class<?> clz, String literalValue) {
        if (clz.isArray()) {
            Class<?> componentType = clz.getComponentType();
            StringBuilder sb = new StringBuilder();
            String[] stringArray = literalValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arrayPart = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(Literals.toLiteral(componentType, arrayPart.trim()));
                ++n2;
            }
            return "new " + componentType.getName() + "[]{" + sb.toString() + "}";
        }
        if (clz == Boolean.class) {
            return "Boolean." + literalValue.toUpperCase(Locale.ENGLISH);
        }
        if (clz == Boolean.TYPE) {
            return literalValue.toLowerCase(Locale.ENGLISH);
        }
        if (clz == Byte.class) {
            return "new Byte((byte)" + literalValue + ")";
        }
        if (clz == Byte.TYPE) {
            return literalValue;
        }
        if (clz == Short.class) {
            return "new Short((short)" + literalValue + ")";
        }
        if (clz == Short.TYPE) {
            return literalValue;
        }
        if (clz == Integer.class) {
            return "new Integer(" + literalValue + ")";
        }
        if (clz == Integer.TYPE) {
            return literalValue;
        }
        if (clz == Long.class) {
            return "new Long(" + literalValue + ")";
        }
        if (clz == Long.TYPE) {
            return literalValue;
        }
        if (clz == Float.class) {
            return "new Float(" + literalValue + "f)";
        }
        if (clz == Float.TYPE) {
            return String.valueOf(literalValue) + "f";
        }
        if (clz == Double.class) {
            return "new Double(" + literalValue + ")";
        }
        if (clz == Double.TYPE) {
            return literalValue;
        }
        if (clz == Character.class) {
            return "new Character(" + Literals.toCharLiteral(literalValue) + ")";
        }
        if (clz == Character.TYPE) {
            return Literals.toCharLiteral(literalValue);
        }
        if (clz == String.class) {
            return Literals.toStringLiteral(literalValue);
        }
        if (clz == BigDecimal.class) {
            return "new " + BigDecimal.class.getName() + "(\"" + literalValue + "\")";
        }
        if (clz == BigInteger.class) {
            return "new " + BigInteger.class.getName() + "(\"" + literalValue + "\")";
        }
        if (clz == Date.class) {
            try {
                Date dt = xmlDateFormat.parse(literalValue);
                return "new " + Date.class.getName() + "(" + dt.getTime() + ")";
            }
            catch (ParseException e) {
                return "new Date(" + Literals.toStringLiteral(literalValue) + ")";
            }
        }
        if (clz == java.sql.Date.class) {
            try {
                Date dt = xmlDateFormat.parse(literalValue);
                return "new " + java.sql.Date.class.getName() + "(" + dt.getTime() + ")";
            }
            catch (ParseException e) {
                return "new Date(" + Literals.toStringLiteral(literalValue) + ")";
            }
        }
        if (clz == Timestamp.class) {
            try {
                Date dt = xmlDateFormat.parse(literalValue);
                return "new " + Timestamp.class.getName() + "(" + dt.getTime() + ")";
            }
            catch (ParseException e) {
                return "new Date(" + Literals.toStringLiteral(literalValue) + ")";
            }
        }
        return null;
    }

    private static String toCharLiteral(String literalValue) {
        StringBuilder result = new StringBuilder(8);
        result.append('\'');
        result.append(Literals.escapeChar(literalValue.toCharArray()[0]));
        result.append('\'');
        return result.toString();
    }

    public static String toStringLiteral(String s) {
        if (s == null) {
            return "null";
        }
        int len = s.length();
        StringBuilder result = new StringBuilder(len + 16);
        result.append('\"');
        int i = 0;
        while (i < len) {
            result.append(Literals.escapeChar(s.charAt(i)));
            ++i;
        }
        result.append('\"');
        return result.toString();
    }

    private static String escapeChar(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c >= ' ' && c < '\u007f') {
            return String.valueOf(c);
        }
        String num = Integer.toHexString(c);
        switch (num.length()) {
            case 1: {
                return "\\u000" + num;
            }
            case 2: {
                return "\\u00" + num;
            }
            case 3: {
                return "\\u0" + num;
            }
        }
        return "\\u" + num;
    }
}

