/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEClassifierAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

public class ModelEClassAnnotator
extends ModelEClassifierAnnotator
implements Annotator<EClassModelGenAnnotation> {
    private static final String SERIALIZABLE_NAME = Serializable.class.getName();

    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation();
    }

    public void setAnnotationFeatures(EClassModelGenAnnotation annotation) {
        Check.isNotNull((Object)annotation.getEClass(), (String)"eClass must be set");
        EClass eClass = annotation.getEClass();
        super.annotate(annotation);
        if (!annotation.isSetSerializable()) {
            annotation.setSerializable(this.isJavaSerializable(annotation, eClass));
        }
        if (annotation.getClassImplements().isEmpty()) {
            annotation.getClassImplements().addAll(this.getClassImplements(annotation, eClass));
        }
        List<String> classExtends = this.getClassExtends(annotation, eClass);
        if (annotation.getClassExtends().isEmpty()) {
            annotation.getClassExtends().addAll(classExtends);
        }
        if (!ModelUtils.isEMap((EClass)eClass) && GenUtils.useInstanceClassNames(eClass.getEPackage()) && !GeneratorUtils.isEmptyOrNull((String)eClass.getInstanceClassName())) {
            annotation.setQualifiedClassName(eClass.getInstanceClassName());
            annotation.setGenerateCode(false);
            int dotIndex = eClass.getInstanceClassName().lastIndexOf(".");
            if (dotIndex == -1) {
                annotation.setSimpleClassName(eClass.getInstanceClassName());
            } else {
                annotation.setSimpleClassName(eClass.getInstanceClassName().substring(dotIndex + 1));
            }
        } else {
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleClassName())) {
                if (!GeneratorUtils.isEmptyOrNull((String)annotation.getQualifiedClassName())) {
                    int index = annotation.getQualifiedClassName().lastIndexOf(".");
                    if (index == -1) {
                        annotation.setSimpleClassName(annotation.getQualifiedClassName());
                    } else {
                        annotation.setSimpleClassName(annotation.getQualifiedClassName().substring(1 + index));
                    }
                } else {
                    annotation.setSimpleClassName(this.getSimpleClassName((EClassifier)eClass));
                }
            }
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getQualifiedClassName()) && !ModelUtils.isEMap((EClass)eClass)) {
                annotation.setQualifiedClassName(this.getQualifiedClassName((EClassifier)eClass, annotation.getSimpleClassName()));
            }
        }
        if (!ModelUtils.isEMap((EClass)eClass) && GeneratorUtils.isEmptyOrNull((String)annotation.getDaoQualifiedClassName())) {
            EPackageModelGenAnnotation ePackageModelGenAnnotation = this.getEPackageModelGenAnnotation(eClass.getEPackage());
            String packagePath = ePackageModelGenAnnotation.getDaoClassesPackagePath();
            annotation.setDaoQualifiedClassName(String.valueOf(packagePath) + "." + annotation.getSimpleClassName() + this.getDaoPatternName(ePackageModelGenAnnotation));
        } else {
            annotation.setDaoQualifiedClassName(null);
        }
        annotation.setAbstract(eClass.isAbstract());
        if (!annotation.isSetHasSuperEClass()) {
            EClass superEClass = this.getSuperClassEClass(eClass);
            annotation.setHasSuperEClass(superEClass != null);
            if (superEClass != null) {
                annotation.setSuperEClass(this.getEClassModelGenAnnotation(superEClass));
            }
        }
        if (annotation.isSetHasSuperEClass()) {
            EClass superEClass = this.getSuperClassEClass(eClass);
            if (superEClass == null || this.getEClassModelGenAnnotation(superEClass) == null || superEClass.getEPackage() == null) {
                annotation.setHasSuperEClass(false);
            } else if (annotation.getSuperEClass() == null) {
                annotation.setSuperEClass(this.getEClassModelGenAnnotation(superEClass));
            }
        }
        if (!annotation.isSetGenerateCode()) {
            boolean doGenerateCode = !ModelUtils.isEMap((EClass)eClass);
            annotation.setGenerateCode(doGenerateCode);
        }
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eClass.getEPackage());
        annotation.setOwnerEPackageAnnotation(ePackageAnnotation);
        if (!annotation.isSetHasManyFeatures()) {
            ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
            if (annotation.getEStructuralFeatureModelGenAnnotations().isEmpty()) {
                for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
                    features.add(eStructuralFeature);
                }
                for (EStructuralFeature eStructuralFeature : this.getAllLocallyImplementedFeatures(eClass)) {
                    features.add(eStructuralFeature);
                }
            } else {
                for (EStructuralFeatureModelGenAnnotation featureAnnotation : annotation.getEStructuralFeatureModelGenAnnotations()) {
                    features.add(featureAnnotation.getEStructuralFeature());
                }
            }
            for (EStructuralFeature feature : features) {
                if (feature.isVolatile() || !feature.isMany()) continue;
                annotation.setHasManyFeatures(true);
                break;
            }
        }
    }

    protected String getDaoPatternName(EPackageModelGenAnnotation ePackageModelGenAnnotation) {
        String patternName = "dao";
        if (!GeneratorUtils.isEmptyOrNull((String)ePackageModelGenAnnotation.getDaoPatternName())) {
            patternName = ePackageModelGenAnnotation.getDaoPatternName();
        }
        return String.valueOf(patternName.substring(0, 1).toUpperCase()) + (patternName.length() > 1 ? patternName.substring(1) : "");
    }

    public void postAnnotating(EClassModelGenAnnotation annotation) {
        EClass eClass = annotation.getEClass();
        if (annotation.getEStructuralFeatureModelGenAnnotations().isEmpty()) {
            for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
                annotation.getEStructuralFeatureModelGenAnnotations().add((Object)this.getEStructuralFeatureModelGenAnnotation(eStructuralFeature));
            }
            for (EStructuralFeature eStructuralFeature : this.getAllLocallyImplementedFeatures(eClass)) {
                annotation.getEStructuralFeatureModelGenAnnotations().add((Object)this.getEStructuralFeatureModelGenAnnotation(eStructuralFeature));
            }
            for (EStructuralFeatureModelGenAnnotation featureAnnotation : annotation.getEStructuralFeatureModelGenAnnotations()) {
                if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)featureAnnotation.getEStructuralFeature())) continue;
                annotation.getFeatureMapFeatures().add((Object)featureAnnotation);
            }
        }
    }

    private List<EStructuralFeature> getAllLocallyImplementedFeatures(EClass eLocalClass) {
        EClass theSuperEClass = this.getSuperClassEClass(eLocalClass);
        ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>();
        for (EClass inheritedEClass : eLocalClass.getESuperTypes()) {
            if (inheritedEClass == theSuperEClass) continue;
            list.addAll((Collection<EStructuralFeature>)inheritedEClass.getEStructuralFeatures());
            list.addAll(this.getAllLocallyImplementedFeatures(inheritedEClass));
        }
        return list;
    }

    private List<String> getClassExtends(EClassModelGenAnnotation annotation, EClass eClass) {
        ArrayList<String> result = new ArrayList<String>();
        if (eClass.isInterface()) {
            for (EClass superEClass : eClass.getESuperTypes()) {
                EClassModelGenAnnotation superAnnotation = this.getEClassModelGenAnnotation(superEClass);
                result.add(superAnnotation.getQualifiedClassName());
            }
            EPackageModelGenAnnotation ePackageModelGenAnnotation = this.getEPackageModelGenAnnotation(eClass.getEPackage());
            if (GeneratorUtils.isNotEmptyAndNotNull((String)ePackageModelGenAnnotation.getRootInterfaceExtends()) && result.isEmpty()) {
                result.add(ePackageModelGenAnnotation.getRootInterfaceExtends());
            }
            if (annotation.isSerializable() && !this.isSuperClassSerializable(eClass)) {
                result.add(Serializable.class.getName());
            }
            return result;
        }
        EClass superEClass = this.getSuperClassEClass(eClass);
        if (superEClass == null) {
            EPackageModelGenAnnotation ePackageModelGenAnnotation = this.getEPackageModelGenAnnotation(eClass.getEPackage());
            if (GeneratorUtils.isNotEmptyAndNotNull((String)ePackageModelGenAnnotation.getRootClassExtends()) && result.isEmpty()) {
                result.add(ePackageModelGenAnnotation.getRootClassExtends());
            }
            return result;
        }
        EClassModelGenAnnotation superAnnotation = this.getEClassModelGenAnnotation(superEClass);
        result.add(superAnnotation.getQualifiedClassName());
        return result;
    }

    private List<String> getClassImplements(EClassModelGenAnnotation annotation, EClass eClass) {
        EList superTypes = eClass.getESuperTypes();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (EClass superEClass : superTypes) {
            if (!superEClass.isInterface()) continue;
            EClassModelGenAnnotation superAnnotation = this.getEClassModelGenAnnotation(superEClass);
            interfaces.add(superAnnotation.getQualifiedClassName());
        }
        if (annotation.isSerializable() && !this.isSuperClassSerializable(eClass)) {
            interfaces.add(Serializable.class.getName());
        }
        return interfaces;
    }

    private EClass getSuperClassEClass(EClass eClass) {
        EList superTypes = eClass.getESuperTypes();
        if (superTypes.isEmpty()) {
            return null;
        }
        for (EClass superEClass : superTypes) {
            if (superEClass.isInterface()) continue;
            return superEClass;
        }
        return null;
    }

    private boolean isJavaSerializable(EClassModelGenAnnotation annotation, EClass eClass) {
        for (String interf : this.getClassImplements(annotation, eClass)) {
            if (interf.compareTo(SERIALIZABLE_NAME) != 0) continue;
            return true;
        }
        return this.isSuperClassSerializable(eClass);
    }

    private boolean isSuperClassSerializable(EClass eClass) {
        for (EClass superEClass : eClass.getEAllSuperTypes()) {
            EClassModelGenAnnotation superAnnotation = this.getEClassModelGenAnnotation(superEClass);
            if (superAnnotation.getQualifiedClassName().equals(Serializable.class.getName())) {
                return true;
            }
            if (!superAnnotation.isSerializable()) continue;
            return true;
        }
        return false;
    }
}

