/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.Locale;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEClassifierAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotationDefinition;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

public class ModelEDataTypeAnnotator
extends ModelEClassifierAnnotator
implements Annotator<EDataTypeModelGenAnnotation> {
    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEDataTypeModelGenAnnotation();
    }

    public void setAnnotationFeatures(EDataTypeModelGenAnnotation annotation) {
        EEnum eEnumBaseType;
        boolean isTypeWithEnumBaseType;
        super.annotate(annotation);
        Check.isNotNull((Object)annotation.getEDataType(), (String)"eDataType must be set");
        EDataType eDataType = annotation.getEDataType();
        if (!annotation.isSetEnum()) {
            annotation.setEnum(eDataType instanceof EEnum);
        }
        boolean bl = isTypeWithEnumBaseType = (eEnumBaseType = ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType)) != null;
        String instanceClassName = !GeneratorUtils.isEmptyOrNull((String)annotation.getInstanceClassName()) ? annotation.getInstanceClassName() : (isTypeWithEnumBaseType ? this.getInstanceClassNameForEnum(eEnumBaseType) : this.getInstanceClassName(eDataType));
        Class<?> instanceClass = this.getInstanceClass(eDataType, instanceClassName);
        if (!annotation.isSetDateType()) {
            if (isTypeWithEnumBaseType) {
                annotation.setDateType(false);
            } else if (GenUtils.isDateOrDateTime(eDataType)) {
                annotation.setDateType(true);
            } else {
                annotation.setDateType(false);
            }
        }
        EDataType itemDataType = ExtendedMetaData.INSTANCE.getItemType(annotation.getEDataType());
        EDataType baseType = annotation.getEDataType();
        while (itemDataType == null && (baseType = ExtendedMetaData.INSTANCE.getBaseType(baseType)) != null) {
            itemDataType = ExtendedMetaData.INSTANCE.getItemType(baseType);
        }
        if (itemDataType != null) {
            EDataTypeModelGenAnnotationDefinition itemDataTypeAnnotation = this.getEDataTypeModelGenAnnotation(itemDataType);
            annotation.setItemType(itemDataTypeAnnotation.getInstanceClassName());
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getObjectClassName())) {
            if (isTypeWithEnumBaseType) {
                annotation.setObjectClassName(instanceClassName);
            } else if (instanceClass != null && instanceClass.isArray()) {
                annotation.setObjectClassName(instanceClass.getComponentType() + "[]");
            } else if (instanceClass != null && instanceClass.getTypeParameters().length > 0 && annotation.getItemType() != null) {
                annotation.setObjectClassName(String.valueOf(instanceClass.getName()) + "<" + annotation.getItemType() + ">");
            } else {
                annotation.setObjectClassName(GenUtils.getObjectClassName(eDataType, instanceClassName));
            }
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getItemType())) {
            annotation.setItemType(annotation.getObjectClassName());
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getQualifiedClassName())) {
            annotation.setQualifiedClassName(instanceClassName);
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getInstanceClassName())) {
            annotation.setInstanceClassName(instanceClassName);
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleClassName())) {
            annotation.setSimpleClassName(this.getSimpleClassName((EClassifier)eDataType));
        }
        if (!annotation.isSetGenerateCode()) {
            annotation.setGenerateCode(true);
        }
        if (!annotation.isSetAutomaticStringConversion()) {
            if (isTypeWithEnumBaseType) {
                annotation.setAutomaticStringConversion(false);
            } else {
                annotation.setAutomaticStringConversion(this.hasInstanceClassStringConstructor(instanceClass));
            }
        }
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eDataType.getEPackage());
        annotation.setOwnerEPackageAnnotation(ePackageAnnotation);
        if (isTypeWithEnumBaseType) {
            EDataTypeModelGenAnnotationDefinition baseTypeAnnotation = this.getEDataTypeModelGenAnnotation((EDataType)eEnumBaseType);
            annotation.setBaseTypeAnnotation(baseTypeAnnotation);
        }
    }

    public void postAnnotating(EDataTypeModelGenAnnotation annotation) {
    }

    private Class<?> getInstanceClass(EDataType eDataType, String instanceClassName) {
        return this.getClassForName(eDataType, instanceClassName);
    }

    private String getInstanceClassName(EDataType eDataType) {
        return GenUtils.getInstanceClassName(eDataType);
    }

    private boolean hasInstanceClassStringConstructor(Class<?> instanceClass) {
        Class<?> useClass;
        block4: {
            if (instanceClass == null) {
                return false;
            }
            try {
                useClass = instanceClass;
                if (useClass.getName().contains(".") || (useClass = GenUtils.getObjectClass(instanceClass)) != null) break block4;
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        useClass.getConstructor(String.class);
        return true;
    }

    protected String getInstanceClassNameForEnum(EEnum eEnum) {
        EPackageModelGenAnnotation annotation = this.getEPackageModelGenAnnotation(eEnum.getEPackage());
        String qualifiedClassName = String.valueOf(annotation.getPackagePath().toLowerCase(Locale.ENGLISH)) + "." + this.getSimpleClassName((EClassifier)eEnum);
        return qualifiedClassName;
    }
}

