/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.Locale;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelENamedElementAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

public abstract class ModelEStructuralFeatureAnnotator
extends ModelENamedElementAnnotator {
    protected void annotate(EStructuralFeatureModelGenAnnotation annotation) {
        EAnnotation eAnnotation;
        super.annotate(annotation);
        EStructuralFeature eFeature = annotation.getEStructuralFeature();
        if (eFeature.getEType() == null) {
            throw new IllegalStateException("The EType of the model element " + eFeature.getEContainingClass().getName() + "." + eFeature.getName() + " is not set, it is null");
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getValidJavaMemberName())) {
            String memberName = this.getValidJavaMemberName(eFeature);
            annotation.setValidJavaMemberName(memberName);
        }
        if ((eAnnotation = eFeature.getEAnnotation("org.eclipse.emf.texo")) == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("org.eclipse.emf.texo");
            eFeature.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)"java.member", (Object)annotation.getValidJavaMemberName());
        if (!annotation.isSetUseList()) {
            if (!this.isMany(eFeature)) {
                annotation.setUseList(false);
            } else {
                annotation.setUseList(eFeature.isOrdered());
            }
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getDefaultValue())) {
            annotation.setDefaultValue(this.getDefaultValue(eFeature, annotation));
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getGetter())) {
            annotation.setGetter(this.getGetter(eFeature));
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getSetter())) {
            annotation.setSetter(this.getSetter(eFeature));
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getType())) {
            annotation.setType(this.getType(eFeature, annotation));
        }
        if (!annotation.isSetItemType()) {
            annotation.setItemType(this.getItemType(eFeature));
        }
        if (!annotation.isSetMany()) {
            annotation.setMany(this.isMany(eFeature));
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getObjectType())) {
            annotation.setObjectType(this.getObjectType(eFeature, annotation));
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getFeatureMapQualifiedClassName())) {
                annotation.setFeatureMapQualifiedClassName(this.getFeatureMapQualifiedClassName(eFeature));
            }
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getFeatureMapSimpleClassName()) && GeneratorUtils.isNotEmptyAndNotNull((String)annotation.getFeatureMapQualifiedClassName())) {
                int lastIndex = annotation.getFeatureMapQualifiedClassName().lastIndexOf(".");
                if (lastIndex != -1) {
                    annotation.setFeatureMapSimpleClassName(annotation.getFeatureMapQualifiedClassName().substring(lastIndex + 1));
                } else {
                    annotation.setFeatureMapSimpleClassName(this.getFeatureMapSimpleClassName(eFeature));
                }
            }
        }
        EClassModelGenAnnotation eClassAnnotation = this.getEClassModelGenAnnotation(annotation.getEStructuralFeature().getEContainingClass());
        annotation.setOwnerEClassAnnotation(eClassAnnotation);
    }

    protected abstract String getItemType(EStructuralFeature var1);

    protected String getInstanceClassName(EStructuralFeature eFeature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
            return this.getFeatureMapQualifiedClassName(eFeature);
        }
        return this.getEDataTypeModelGenAnnotation(((EAttribute)eFeature).getEAttributeType()).getInstanceClassName();
    }

    protected boolean isMany(EStructuralFeature eFeature) {
        return eFeature.isMany();
    }

    protected String getValidJavaMemberName(EStructuralFeature eStructuralFeature) {
        return GenUtils.getValidJavaMemberName(this.getName((ENamedElement)eStructuralFeature));
    }

    protected String getGetter(EStructuralFeature eStructuralFeature) {
        String result = "get" + ModelUtils.upCaseFirst((String)this.getName((ENamedElement)eStructuralFeature));
        if (result.equals("getClass")) {
            return "get_Class";
        }
        return result;
    }

    protected String getSetter(EStructuralFeature eStructuralFeature) {
        return "set" + ModelUtils.upCaseFirst((String)this.getName((ENamedElement)eStructuralFeature));
    }

    @Override
    public String getName(ENamedElement eNamedElement) {
        boolean partOfMix;
        EStructuralFeature eStructuralFeature = (EStructuralFeature)eNamedElement;
        String defaultName = GenUtils.getValidJavaMemberName(super.getName((ENamedElement)eStructuralFeature));
        boolean partOfFeatureMap = ExtendedMetaData.INSTANCE.getGroup(eStructuralFeature) != null;
        boolean bl = partOfMix = GeneratorUtils.getMixedEStructuralFeature((EClass)eStructuralFeature.getEContainingClass()) != null;
        if (!partOfFeatureMap && !partOfMix) {
            return defaultName;
        }
        if (partOfMix && (defaultName.compareToIgnoreCase("comment") == 0 || defaultName.compareToIgnoreCase("text") == 0 || defaultName.compareToIgnoreCase("cdata") == 0)) {
            return String.valueOf(defaultName) + "_";
        }
        if (defaultName.compareToIgnoreCase("value") == 0 || defaultName.compareToIgnoreCase("feature") == 0) {
            return String.valueOf(defaultName) + "_";
        }
        return defaultName;
    }

    protected abstract String getType(EStructuralFeature var1, EStructuralFeatureModelGenAnnotation var2);

    protected String getObjectType(EStructuralFeature eStructuralFeature, EStructuralFeatureModelGenAnnotation genAnnotation) {
        return this.getType(eStructuralFeature, genAnnotation);
    }

    protected abstract String getDefaultValue(EStructuralFeature var1, EStructuralFeatureModelGenAnnotation var2);

    protected String getFeatureMapQualifiedClassName(EStructuralFeature eStructuralFeature) {
        Check.isTrue((boolean)FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature), (String)("The eStructuralFeature " + eStructuralFeature + " is not a feature map"));
        String qualifiedClassName = String.valueOf(this.getFeatureMapPackageName(eStructuralFeature)) + "." + this.getFeatureMapSimpleClassName(eStructuralFeature);
        return qualifiedClassName;
    }

    protected String getFeatureMapPackageName(EStructuralFeature eFeature) {
        return this.getEPackageModelGenAnnotation(eFeature.getEContainingClass().getEPackage()).getPackagePath().toLowerCase(Locale.ENGLISH);
    }

    private String getFeatureMapSimpleClassName(EStructuralFeature eStructuralFeature) {
        Check.isTrue((boolean)FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature), (String)("The eStructuralFeature " + eStructuralFeature + " is not a feature map"));
        EClassModelGenAnnotation eClassAnnotation = this.getEClassModelGenAnnotation(eStructuralFeature.getEContainingClass());
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eStructuralFeature.getEContainingClass().getEPackage());
        return String.valueOf(ModelUtils.upCaseFirst((String)eClassAnnotation.getName())) + ModelUtils.upCaseFirst((String)this.getName((ENamedElement)eStructuralFeature)) + ePackageAnnotation.getFeatureGroupClassNamePostFix();
    }

    protected void postAnnotating(EStructuralFeatureModelGenAnnotation annotation) {
        EStructuralFeature mixedFeature;
        EStructuralFeature eFeature = annotation.getEStructuralFeature();
        EStructuralFeature groupFeature = ExtendedMetaData.INSTANCE.getGroup(eFeature);
        if (groupFeature != null && eFeature != groupFeature) {
            EStructuralFeatureModelGenAnnotation groupAnnotation = this.getEStructuralFeatureModelGenAnnotation(groupFeature);
            groupAnnotation.getMemberFeatureMapFeatures().add((Object)annotation);
        } else if (!GeneratorUtils.isAttribute((EStructuralFeature)eFeature) && (mixedFeature = GeneratorUtils.getMixedEStructuralFeature((EClass)eFeature.getEContainingClass())) != null && mixedFeature != eFeature) {
            EStructuralFeatureModelGenAnnotation mixedAnnotation = this.getEStructuralFeatureModelGenAnnotation(mixedFeature);
            mixedAnnotation.getMemberFeatureMapFeatures().add((Object)annotation);
        }
    }
}

