/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.xtend;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.generator.BaseTemplate;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.xtend.TemplateUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class FeatureGroupTemplate
extends BaseTemplate {
    public void generate(EStructuralFeatureModelGenAnnotation eStructuralFeatureModelGenAnnotation) {
        EPackageModelGenAnnotation _ownerEPackageAnnotation;
        EClassModelGenAnnotation _ownerEClassAnnotation;
        EClassModelGenAnnotation eClassAnnotation = _ownerEClassAnnotation = eStructuralFeatureModelGenAnnotation.getOwnerEClassAnnotation();
        EPackageModelGenAnnotation ePackageAnnotation = _ownerEPackageAnnotation = eClassAnnotation.getOwnerEPackageAnnotation();
        boolean _executeOverrides = this.executeOverrides(eStructuralFeatureModelGenAnnotation);
        if (_executeOverrides) {
            return;
        }
        String fileName = TemplateUtil.classFileName(eStructuralFeatureModelGenAnnotation);
        ModelController _modelController = this.getModelController();
        String content = this.generateContent(_modelController, eStructuralFeatureModelGenAnnotation, eClassAnnotation, ePackageAnnotation);
        this.addFile(fileName, content);
    }

    public List<String> getTemplateOverrides() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org::eclipse::emf::texo::modelgenerator::templates::featuregroup");
        list.add("org::eclipse::emf::texo::modelgenerator::xtend::FeatureGroupTemplate");
        return list;
    }

    public String generateContent(ModelController modelController, EStructuralFeatureModelGenAnnotation eStructuralFeatureModelGenAnnotation, EClassModelGenAnnotation eClassAnnotation, EPackageModelGenAnnotation ePackageAnnotation) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _javaFileHeader = ePackageAnnotation.getJavaFileHeader();
        _builder.append((Object)_javaFileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        String _packagePath = ePackageAnnotation.getPackagePath();
        _builder.append((Object)_packagePath, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* A representation for the Feature Group '<em><b>");
        EClass _eClass = eClassAnnotation.getEClass();
        String _name = _eClass.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)".");
        String _name_1 = eStructuralFeatureModelGenAnnotation.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)"</b></em>'.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        String _documentation = eStructuralFeatureModelGenAnnotation.getDocumentation();
        boolean bl = _notEquals = !Objects.equal((Object)_documentation, null);
        if (_notEquals) {
            _builder.append((Object)"* <!-- begin-model-doc -->");
            _builder.newLine();
            _builder.append((Object)"* ");
            String _documentation_1 = eStructuralFeatureModelGenAnnotation.getDocumentation();
            _builder.append((Object)_documentation_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"* <!-- end-model-doc -->");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        EStructuralFeature _eStructuralFeature = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        String _javaAnnotations = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature, "featureMap.type");
        _builder.append((Object)_javaAnnotations, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        String _featureMapSimpleClassName = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName, "");
        _builder.newLineIfNotEmpty();
        if (!Objects.equal((Object)ePackageAnnotation.getFeatureMapClassExtends(), null) && ePackageAnnotation.getFeatureMapClassExtends().trim().length() > 0) {
            _builder.append((Object)" extends ");
            String _featureMapClassExtends = ePackageAnnotation.getFeatureMapClassExtends();
            _builder.append((Object)_featureMapClassExtends, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Is used to identify which feature is set in this feature group.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static enum Feature {");
        _builder.newLine();
        _builder.append((Object)"    ");
        EStructuralFeature _eStructuralFeature_1 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        boolean _isMixed = TemplateUtil.isMixed(_eStructuralFeature_1);
        if (_isMixed) {
            boolean _greaterThan;
            _builder.append((Object)"TEXT, CDATA, COMMENT");
            List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
            int _size = _allMemberFeatureMapFeatures.size();
            boolean bl2 = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append((Object)",");
            }
        }
        _builder.newLineIfNotEmpty();
        List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_1 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
        boolean _hasElements = false;
        for (EStructuralFeatureModelGenAnnotation memberFeatureAnnotation : _allMemberFeatureMapFeatures_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "    ");
            }
            boolean _isGenerateCode = memberFeatureAnnotation.isGenerateCode();
            if (!_isGenerateCode) continue;
            String _name_2 = memberFeatureAnnotation.getName();
            String _upperCase = TemplateUtil.toUpperCase(_name_2);
            _builder.append((Object)_upperCase, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Returns only the values from the feature group which have the feature equal to the parameter.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param featureGroup the featureGroup List to filter");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param filterByFeature filters by this enum");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return a list with instances corresponding to the feature kind");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @see java.util.Collections#unmodifiableList(List)");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static <T> java.util.List<T> createUnmodifiableValueList(java.util.List<");
        String _featureMapSimpleClassName_1 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_1, "    ");
        _builder.append((Object)"> featureGroup, Feature filterByFeature) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"final java.util.List<Object> result = new java.util.ArrayList<Object>();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (final ");
        String _featureMapSimpleClassName_2 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_2, "        ");
        _builder.append((Object)" group : featureGroup) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"if (group.getFeature() == filterByFeature) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"result.add(group.getValue());");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return (List<T>) Collections.unmodifiableList(result);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Returns a single value from the feature group which has the feature equal to the parameter.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* The first found value is returned. If no value can be found then null is returned.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param featureGroup the featureGroup List to filter");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param filterByFeature filters by this enum");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return an instance corresponding to the feature kind or null if not found.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static <T> T getSingleFeatureMapValue(java.util.List<");
        String _featureMapSimpleClassName_3 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_3, "    ");
        _builder.append((Object)"> featureGroup, Feature filterByFeature) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (final ");
        String _featureMapSimpleClassName_4 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_4, "        ");
        _builder.append((Object)" group : featureGroup) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"if (group.getFeature() == filterByFeature) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return (T)group.getValue();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Sets a single value in a feature group, if there is already a value set in the feature");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* for the feature in question then it is replaced by the new value.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param featureGroup the featureGroup List to find the value");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param feature sets this feature");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param value the value to set");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static void setSingleFeatureMapValue(java.util.List<");
        String _featureMapSimpleClassName_5 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_5, "    ");
        _builder.append((Object)"> featureGroup, Feature feature, Object value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (final ");
        String _featureMapSimpleClassName_6 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_6, "        ");
        _builder.append((Object)" group : featureGroup) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"if (group.getFeature() == feature) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"group.setValue(feature, value);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final ");
        String _featureMapSimpleClassName_7 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_7, "        ");
        _builder.append((Object)" entry = new ");
        String _featureMapSimpleClassName_8 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_8, "        ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"entry.setValue(feature, value);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"featureGroup.add(entry);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Creates a list of group instances set with the passed feature and values.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param feature the feature to set");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param values the values to set as value of each group instance in the result.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return a list with instances of this class, set with the Feature and values");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static java.util.List<");
        String _featureMapSimpleClassName_9 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_9, "    ");
        _builder.append((Object)"> createFeatureGroupList(Feature feature, List<?> values) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"final java.util.List<");
        String _featureMapSimpleClassName_10 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_10, "        ");
        _builder.append((Object)"> result = new java.util.ArrayList<");
        String _featureMapSimpleClassName_11 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_11, "        ");
        _builder.append((Object)">();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (Object value : values) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"final ");
        String _featureMapSimpleClassName_12 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_12, "            ");
        _builder.append((Object)" group = new ");
        String _featureMapSimpleClassName_13 = eStructuralFeatureModelGenAnnotation.getFeatureMapSimpleClassName();
        _builder.append((Object)_featureMapSimpleClassName_13, "            ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"group.setValue(feature, value);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"result.add(group);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        EStructuralFeature _eStructuralFeature_2 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        String _javaAnnotations_1 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_2, "featureMap.feature");
        _builder.append((Object)_javaAnnotations_1, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"private Feature feature = null;");
        _builder.newLine();
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_3 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        boolean _isMixed_1 = TemplateUtil.isMixed(_eStructuralFeature_3);
        if (_isMixed_1) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_4 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
            String _javaAnnotations_2 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_4, "featureMap.text");
            _builder.append((Object)_javaAnnotations_2, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private String text;");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_5 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
            String _javaAnnotations_3 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_5, "featureMap.cdata");
            _builder.append((Object)_javaAnnotations_3, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private String cDATA;");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_6 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
            String _javaAnnotations_4 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_6, "featureMap.comment");
            _builder.append((Object)_javaAnnotations_4, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private String comment;");
            _builder.newLine();
        }
        EList<EStructuralFeatureModelGenAnnotation> _memberFeatureMapFeatures = eStructuralFeatureModelGenAnnotation.getMemberFeatureMapFeatures();
        for (EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_1 : _memberFeatureMapFeatures) {
            _builder.newLine();
            if (!memberFeatureAnnotation_1.isGenerateCode() || !Objects.equal((Object)memberFeatureAnnotation_1.getFeatureMapFeature(), (Object)eStructuralFeatureModelGenAnnotation)) continue;
            _builder.append((Object)"    ");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"  ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"    ");
            EStructuralFeature _eStructuralFeature_7 = memberFeatureAnnotation_1.getEStructuralFeature();
            String _javaAnnotations_5 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_7, "featureMap.field");
            _builder.append((Object)_javaAnnotations_5, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"private ");
            String _itemType = memberFeatureAnnotation_1.getItemType();
            _builder.append((Object)_itemType, "    ");
            _builder.append((Object)" ");
            String _validJavaMemberName = memberFeatureAnnotation_1.getValidJavaMemberName();
            _builder.append((Object)_validJavaMemberName, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param feature the EStructuralFeature of this feature map entry");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public void setFeature(Feature feature) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"this.feature = feature;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return feature the EStructuralFeature of this feature map entry");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public Feature getFeature() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return feature;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_8 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        boolean _isMixed_2 = TemplateUtil.isMixed(_eStructuralFeature_8);
        if (_isMixed_2) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Returns the value of '<em><b>text</b></em>' feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the value of '<em><b>text</b></em>' feature");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public String getText() {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return text;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Sets the <em>text</em> feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param newText the new value of the '<em><b>text</b></em>' feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public void setText(String newText) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"text = newText;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"setFeature(Feature.TEXT);");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Returns the value of '<em><b>CDATA</b></em>' feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the value of '<em><b>CDATA</b></em>' feature");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public String getCDATA() {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return cDATA;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Sets the <em>cDATA</em> feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param newCDATA the new value of the '<em><b>CDATA</b></em>' feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public void setCDATA(String newCDATA) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"cDATA = newCDATA;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"setFeature(Feature.CDATA);");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Returns the value of '<em><b>comment</b></em>' feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the value of '<em><b>comment</b></em>' feature");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public String getComment() {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return comment;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Sets the <em>comment</em> feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param newComment the new value of the '<em><b>comment</b></em>' feature.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public void setComment(String newComment) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"comment = newComment;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"setFeature(Feature.COMMENT);");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_2 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
        for (EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_2 : _allMemberFeatureMapFeatures_2) {
            _builder.newLine();
            boolean _isGenerateCode_1 = memberFeatureAnnotation_2.isGenerateCode();
            if (!_isGenerateCode_1) continue;
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Returns the value of '<em><b>");
            EStructuralFeature _eStructuralFeature_9 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_3 = _eStructuralFeature_9.getName();
            _builder.append((Object)_name_3, " ");
            _builder.append((Object)"</b></em>' feature.");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the value of '<em><b>");
            EStructuralFeature _eStructuralFeature_10 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_4 = _eStructuralFeature_10.getName();
            _builder.append((Object)_name_4, " ");
            _builder.append((Object)"</b></em>' feature");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_11 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _javaAnnotations_6 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_11, "featureMap.getter");
            _builder.append((Object)_javaAnnotations_6, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public ");
            String _itemType_1 = memberFeatureAnnotation_2.getItemType();
            _builder.append((Object)_itemType_1, "");
            _builder.append((Object)" ");
            String _getter = memberFeatureAnnotation_2.getGetter();
            _builder.append((Object)_getter, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            EStructuralFeatureModelGenAnnotation _featureMapFeature = memberFeatureAnnotation_2.getFeatureMapFeature();
            boolean _equals = Objects.equal((Object)_featureMapFeature, (Object)eStructuralFeatureModelGenAnnotation);
            if (_equals) {
                _builder.append((Object)"return ");
                String _validJavaMemberName_1 = memberFeatureAnnotation_2.getValidJavaMemberName();
                _builder.append((Object)_validJavaMemberName_1, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"if (");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_1 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_1 = _featureMapFeature_1.getGetter();
                _builder.append((Object)_getter_1, "");
                _builder.append((Object)"() == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"return null;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_2 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_2 = _featureMapFeature_2.getGetter();
                _builder.append((Object)_getter_2, "");
                _builder.append((Object)"().");
                String _getter_3 = memberFeatureAnnotation_2.getGetter();
                _builder.append((Object)_getter_3, "");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Sets the '{@link ");
            String _simpleClassName = eClassAnnotation.getSimpleClassName();
            _builder.append((Object)_simpleClassName, " ");
            _builder.append((Object)"#");
            String _getter_4 = memberFeatureAnnotation_2.getGetter();
            _builder.append((Object)_getter_4, " ");
            _builder.append((Object)"() <em>");
            EStructuralFeature _eStructuralFeature_12 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_5 = _eStructuralFeature_12.getName();
            _builder.append((Object)_name_5, " ");
            _builder.append((Object)"</em>}' feature.");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- begin-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* <!-- end-user-doc -->");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param new");
            String _name_6 = memberFeatureAnnotation_2.getName();
            String _firstUpper = TemplateUtil.toFirstUpper(_name_6);
            _builder.append((Object)_firstUpper, " ");
            _builder.append((Object)" the new value of the '{@link ");
            String _simpleClassName_1 = eClassAnnotation.getSimpleClassName();
            _builder.append((Object)_simpleClassName_1, " ");
            _builder.append((Object)"#");
            String _getter_5 = memberFeatureAnnotation_2.getGetter();
            _builder.append((Object)_getter_5, " ");
            _builder.append((Object)"() ");
            EStructuralFeature _eStructuralFeature_13 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _name_7 = _eStructuralFeature_13.getName();
            _builder.append((Object)_name_7, " ");
            _builder.append((Object)"}' feature.");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            EStructuralFeature _eStructuralFeature_14 = memberFeatureAnnotation_2.getEStructuralFeature();
            String _javaAnnotations_7 = modelController.getJavaAnnotations((ENamedElement)_eStructuralFeature_14, "featureMap.setter");
            _builder.append((Object)_javaAnnotations_7, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public void ");
            String _setter = memberFeatureAnnotation_2.getSetter();
            _builder.append((Object)_setter, "");
            _builder.append((Object)"(");
            String _itemType_2 = memberFeatureAnnotation_2.getItemType();
            _builder.append((Object)_itemType_2, "");
            _builder.append((Object)" new");
            String _name_8 = memberFeatureAnnotation_2.getName();
            String _firstUpper_1 = TemplateUtil.toFirstUpper(_name_8);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            EStructuralFeatureModelGenAnnotation _featureMapFeature_3 = memberFeatureAnnotation_2.getFeatureMapFeature();
            boolean _equals_1 = Objects.equal((Object)_featureMapFeature_3, (Object)eStructuralFeatureModelGenAnnotation);
            if (_equals_1) {
                _builder.append((Object)"    ");
                String _validJavaMemberName_2 = memberFeatureAnnotation_2.getValidJavaMemberName();
                _builder.append((Object)_validJavaMemberName_2, "    ");
                _builder.append((Object)" = new");
                String _name_9 = memberFeatureAnnotation_2.getName();
                String _firstUpper_2 = TemplateUtil.toFirstUpper(_name_9);
                _builder.append((Object)_firstUpper_2, "    ");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"setFeature(Feature.");
                String _name_10 = memberFeatureAnnotation_2.getName();
                String _upperCase_1 = TemplateUtil.toUpperCase(_name_10);
                _builder.append((Object)_upperCase_1, "    ");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"    ");
                _builder.append((Object)"if (");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_4 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_6 = _featureMapFeature_4.getGetter();
                _builder.append((Object)_getter_6, "    ");
                _builder.append((Object)"() == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_5 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _setter_1 = _featureMapFeature_5.getSetter();
                _builder.append((Object)_setter_1, "        ");
                _builder.append((Object)"(new ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_6 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _featureMapQualifiedClassName = _featureMapFeature_6.getFeatureMapQualifiedClassName();
                _builder.append((Object)_featureMapQualifiedClassName, "        ");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                EStructuralFeatureModelGenAnnotation _featureMapFeature_7 = memberFeatureAnnotation_2.getFeatureMapFeature();
                String _getter_7 = _featureMapFeature_7.getGetter();
                _builder.append((Object)_getter_7, "    ");
                _builder.append((Object)"().");
                String _setter_2 = memberFeatureAnnotation_2.getSetter();
                _builder.append((Object)_setter_2, "    ");
                _builder.append((Object)"(new");
                String _name_11 = memberFeatureAnnotation_2.getName();
                String _firstUpper_3 = TemplateUtil.toFirstUpper(_name_11);
                _builder.append((Object)_firstUpper_3, "    ");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* @return the value of this feature map entry. The type of the returned value is based on the feature.");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* @see #getFeature()");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public Object getValue() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"switch (getFeature()) {");
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_15 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        boolean _isMixed_3 = TemplateUtil.isMixed(_eStructuralFeature_15);
        if (_isMixed_3) {
            _builder.append((Object)"case TEXT:");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return getText();");
            _builder.newLine();
            _builder.append((Object)"case CDATA:");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return getCDATA();");
            _builder.newLine();
            _builder.append((Object)"case COMMENT:");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return getComment();");
            _builder.newLine();
        }
        List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_3 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
        for (EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_3 : _allMemberFeatureMapFeatures_3) {
            _builder.append((Object)"    ");
            _builder.append((Object)"case ");
            String _name_12 = memberFeatureAnnotation_3.getName();
            String _upperCase_2 = TemplateUtil.toUpperCase(_name_12);
            _builder.append((Object)_upperCase_2, "    ");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"return ");
            String _getter_8 = memberFeatureAnnotation_3.getGetter();
            _builder.append((Object)_getter_8, "        ");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"            ");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"throw new IllegalStateException(\"Feature kind \" + getFeature() + \" is not supported for this object \" + this);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* <!-- begin-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* <!-- end-user-doc -->");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* @param feature the feature to set");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* @param value the value to set in this instance");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"* @see #getFeature()");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public void setValue(Feature feature, Object value) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"switch (feature) {");
        _builder.newLine();
        EStructuralFeature _eStructuralFeature_16 = eStructuralFeatureModelGenAnnotation.getEStructuralFeature();
        boolean _isMixed_4 = TemplateUtil.isMixed(_eStructuralFeature_16);
        if (_isMixed_4) {
            _builder.append((Object)"case TEXT:");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"setText((String)value);");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"case CDATA:");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"setCDATA((String)value);");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"case COMMENT:");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"setComment((String)value);");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        List<EStructuralFeatureModelGenAnnotation> _allMemberFeatureMapFeatures_4 = eStructuralFeatureModelGenAnnotation.getAllMemberFeatureMapFeatures();
        for (EStructuralFeatureModelGenAnnotation memberFeatureAnnotation_4 : _allMemberFeatureMapFeatures_4) {
            boolean _isGenerateCode_2 = memberFeatureAnnotation_4.isGenerateCode();
            if (!_isGenerateCode_2) continue;
            _builder.append((Object)"case ");
            String _name_13 = memberFeatureAnnotation_4.getName();
            String _upperCase_3 = TemplateUtil.toUpperCase(_name_13);
            _builder.append((Object)_upperCase_3, "");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            String _setter_3 = memberFeatureAnnotation_4.getSetter();
            _builder.append((Object)_setter_3, "    ");
            _builder.append((Object)"((");
            String _itemType_3 = memberFeatureAnnotation_4.getItemType();
            _builder.append((Object)_itemType_3, "    ");
            _builder.append((Object)")value);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"            ");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"throw new IllegalStateException(\"Feature kind \" + getFeature() + \" is not supported for this object \" + this);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

