/**
 * <copyright>
 * </copyright>
 *
 * $Id: OrmannotationsItemProviderAdapterFactory.java,v 1.7 2011/09/23 20:59:49 mtaal Exp $
 */
package org.eclipse.emf.texo.orm.ormannotations.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.texo.orm.ormannotations.util.OrmannotationsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The adapters generated by this
 * factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support Eclipse property sheets. Note that most of the adapters are shared among multiple instances. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class OrmannotationsItemProviderAdapterFactory extends OrmannotationsAdapterFactory implements
    ComposeableAdapterFactory, IChangeNotifier, IDisposable {
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public OrmannotationsItemProviderAdapterFactory() {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EPackageORMAnnotationItemProvider ePackageORMAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEPackageORMAnnotationAdapter() {
    if (ePackageORMAnnotationItemProvider == null) {
      ePackageORMAnnotationItemProvider = new EPackageORMAnnotationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return ePackageORMAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EClassORMAnnotationItemProvider eClassORMAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEClassORMAnnotationAdapter() {
    if (eClassORMAnnotationItemProvider == null) {
      eClassORMAnnotationItemProvider = new EClassORMAnnotationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return eClassORMAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.ormannotations.EAttributeORMAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EAttributeORMAnnotationItemProvider eAttributeORMAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.ormannotations.EAttributeORMAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEAttributeORMAnnotationAdapter() {
    if (eAttributeORMAnnotationItemProvider == null) {
      eAttributeORMAnnotationItemProvider = new EAttributeORMAnnotationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return eAttributeORMAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.ormannotations.EReferenceORMAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EReferenceORMAnnotationItemProvider eReferenceORMAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.ormannotations.EReferenceORMAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEReferenceORMAnnotationAdapter() {
    if (eReferenceORMAnnotationItemProvider == null) {
      eReferenceORMAnnotationItemProvider = new EReferenceORMAnnotationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return eReferenceORMAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.ormannotations.EEnumORMAnnotation} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected EEnumORMAnnotationItemProvider eEnumORMAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.ormannotations.EEnumORMAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEEnumORMAnnotationAdapter() {
    if (eEnumORMAnnotationItemProvider == null) {
      eEnumORMAnnotationItemProvider = new EEnumORMAnnotationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return eEnumORMAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.ormannotations.EDataTypeORMAnnotation} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EDataTypeORMAnnotationItemProvider eDataTypeORMAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.ormannotations.EDataTypeORMAnnotation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEDataTypeORMAnnotationAdapter() {
    if (eDataTypeORMAnnotationItemProvider == null) {
      eDataTypeORMAnnotationItemProvider = new EDataTypeORMAnnotationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return eDataTypeORMAnnotationItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public ComposeableAdapterFactory getRootAdapterFactory() {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object type) {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type) {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type) {
    if (isFactoryForType(type)) {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
        return adapter;
      }
    }

    return null;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void addListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  public void fireNotifyChanged(Notification notification) {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null) {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory. 
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public void dispose() {
    if (ePackageORMAnnotationItemProvider != null) ePackageORMAnnotationItemProvider.dispose();
    if (eClassORMAnnotationItemProvider != null) eClassORMAnnotationItemProvider.dispose();
    if (eAttributeORMAnnotationItemProvider != null) eAttributeORMAnnotationItemProvider.dispose();
    if (eReferenceORMAnnotationItemProvider != null) eReferenceORMAnnotationItemProvider.dispose();
    if (eEnumORMAnnotationItemProvider != null) eEnumORMAnnotationItemProvider.dispose();
    if (eDataTypeORMAnnotationItemProvider != null) eDataTypeORMAnnotationItemProvider.dispose();
  }

  private static class ChildPropertyDescriptorSorter implements Comparator<Object> {

    public int compare(Object o1, Object o2) {
      final CommandParameter cp1 = (CommandParameter) o1;
      final CommandParameter cp2 = (CommandParameter) o2;
      return cp1.getEStructuralFeature().getName().compareTo(cp2.getEStructuralFeature().getName());
    }

  }
}
