/**
 * <copyright>
 * </copyright>
 *
 * $Id: NamedNativeQuery.java,v 1.5 2011/10/25 13:21:26 mtaal Exp $
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.texo.orm.annotator.BaseOrmAnnotation;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Named Native Query</b></em>'. <!-- end-user-doc
 * -->
 * 
 * <!-- begin-model-doc -->
 * 
 * 
 * @Target({TYPE ) @Retention(RUNTIME) public @interface NamedNativeQuery { String name(); String query(); QueryHint[]
 *               hints() default {}; Class resultClass() default void.class; String resultSetMapping() default "";
 *               //named SqlResultSetMapping }
 * 
 * 
 *               <!-- end-model-doc -->
 * 
 *               <p>
 *               The following features are supported:
 *               <ul>
 *               <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getDescription <em>
 *               Description</em>}</li>
 *               <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getQuery <em>Query</em>}</li>
 *               <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getHint <em>Hint</em>}</li>
 *               <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getName <em>Name</em>}</li>
 *               <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getResultClass <em>Result
 *               Class</em>}</li>
 *               <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getResultSetMapping <em>
 *               Result Set Mapping</em>}</li>
 *               </ul>
 *               </p>
 * 
 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery()
 * @model extendedMetaData="name='named-native-query' kind='elementOnly'"
 * @generated
 */
public interface NamedNativeQuery extends BaseOrmAnnotation {
  /**
   * Returns the value of the '<em><b>Description</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Description</em>' attribute isn't clear, there really should be more of a description
   * here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Description</em>' attribute.
   * @see #setDescription(String)
   * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery_Description()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String"
   *        extendedMetaData="kind='element' name='description' namespace='##targetNamespace'"
   * @generated
   */
  String getDescription();

  /**
   * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getDescription <em>Description</em>}' attribute.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @param value the new value of the '<em>Description</em>' attribute.
   * @see #getDescription()
   * @generated
   */
  void setDescription(String value);

  /**
   * Returns the value of the '<em><b>Query</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Query</em>' attribute isn't clear, there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Query</em>' attribute.
   * @see #setQuery(String)
   * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery_Query()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
   *        extendedMetaData="kind='element' name='query' namespace='##targetNamespace'"
   * @generated
   */
  String getQuery();

  /**
   * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getQuery <em>Query</em>}' attribute.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @param value the new value of the '<em>Query</em>' attribute.
   * @see #getQuery()
   * @generated
   */
  void setQuery(String value);

  /**
   * Returns the value of the '<em><b>Hint</b></em>' containment reference list.
   * The list contents are of type {@link org.eclipse.emf.texo.orm.annotations.model.orm.QueryHint}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Hint</em>' containment reference list isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Hint</em>' containment reference list.
   * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery_Hint()
   * @model containment="true"
   *        extendedMetaData="kind='element' name='hint' namespace='##targetNamespace'"
   * @generated
   */
  EList<QueryHint> getHint();

  /**
   * Returns the value of the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Name</em>' attribute isn't clear, there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Name</em>' attribute.
   * @see #setName(String)
   * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery_Name()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
   *        extendedMetaData="kind='attribute' name='name'"
   * @generated
   */
  String getName();

  /**
   * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getName <em>Name</em>}' attribute.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @param value the new value of the '<em>Name</em>' attribute.
   * @see #getName()
   * @generated
   */
  void setName(String value);

  /**
   * Returns the value of the '<em><b>Result Class</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Result Class</em>' attribute isn't clear, there really should be more of a description
   * here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Result Class</em>' attribute.
   * @see #setResultClass(String)
   * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery_ResultClass()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String"
   *        extendedMetaData="kind='attribute' name='result-class'"
   * @generated
   */
  String getResultClass();

  /**
   * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getResultClass <em>Result Class</em>}' attribute.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @param value the new value of the '<em>Result Class</em>' attribute.
   * @see #getResultClass()
   * @generated
   */
  void setResultClass(String value);

  /**
   * Returns the value of the '<em><b>Result Set Mapping</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Result Set Mapping</em>' attribute isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Result Set Mapping</em>' attribute.
   * @see #setResultSetMapping(String)
   * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getNamedNativeQuery_ResultSetMapping()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String"
   *        extendedMetaData="kind='attribute' name='result-set-mapping'"
   * @generated
   */
  String getResultSetMapping();

  /**
   * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery#getResultSetMapping <em>Result Set Mapping</em>}' attribute.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @param value the new value of the '<em>Result Set Mapping</em>' attribute.
   * @see #getResultSetMapping()
   * @generated
   */
  void setResultSetMapping(String value);

} // NamedNativeQuery
