/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AccessType implements Enumerator
{
    PROPERTY(0, "PROPERTY", "PROPERTY"),
    FIELD(1, "FIELD", "FIELD"),
    VIRTUAL(2, "VIRTUAL", "VIRTUAL");

    public static final int PROPERTY_VALUE = 0;
    public static final int FIELD_VALUE = 1;
    public static final int VIRTUAL_VALUE = 2;
    private static final AccessType[] VALUES_ARRAY;
    public static final List<AccessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AccessType[]{PROPERTY, FIELD, VIRTUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AccessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType get(int value) {
        switch (value) {
            case 0: {
                return PROPERTY;
            }
            case 1: {
                return FIELD;
            }
            case 2: {
                return VIRTUAL;
            }
        }
        return null;
    }

    private AccessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

