/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BatchFetchType implements Enumerator
{
    JOIN(0, "JOIN", "JOIN"),
    EXISTS(1, "EXISTS", "EXISTS"),
    IN(2, "IN", "IN");

    public static final int JOIN_VALUE = 0;
    public static final int EXISTS_VALUE = 1;
    public static final int IN_VALUE = 2;
    private static final BatchFetchType[] VALUES_ARRAY;
    public static final List<BatchFetchType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BatchFetchType[]{JOIN, EXISTS, IN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BatchFetchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BatchFetchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BatchFetchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BatchFetchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BatchFetchType get(int value) {
        switch (value) {
            case 0: {
                return JOIN;
            }
            case 1: {
                return EXISTS;
            }
            case 2: {
                return IN;
            }
        }
        return null;
    }

    private BatchFetchType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

