/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CacheCoordinationType implements Enumerator
{
    SENDOBJECTCHANGES(0, "SENDOBJECTCHANGES", "SEND_OBJECT_CHANGES"),
    INVALIDATECHANGEDOBJECTS(1, "INVALIDATECHANGEDOBJECTS", "INVALIDATE_CHANGED_OBJECTS"),
    SENDNEWOBJECTSWITHCHANGES(2, "SENDNEWOBJECTSWITHCHANGES", "SEND_NEW_OBJECTS_WITH_CHANGES"),
    NONE(3, "NONE", "NONE");

    public static final int SENDOBJECTCHANGES_VALUE = 0;
    public static final int INVALIDATECHANGEDOBJECTS_VALUE = 1;
    public static final int SENDNEWOBJECTSWITHCHANGES_VALUE = 2;
    public static final int NONE_VALUE = 3;
    private static final CacheCoordinationType[] VALUES_ARRAY;
    public static final List<CacheCoordinationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheCoordinationType[]{SENDOBJECTCHANGES, INVALIDATECHANGEDOBJECTS, SENDNEWOBJECTSWITHCHANGES, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheCoordinationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheCoordinationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheCoordinationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheCoordinationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheCoordinationType get(int value) {
        switch (value) {
            case 0: {
                return SENDOBJECTCHANGES;
            }
            case 1: {
                return INVALIDATECHANGEDOBJECTS;
            }
            case 2: {
                return SENDNEWOBJECTSWITHCHANGES;
            }
            case 3: {
                return NONE;
            }
        }
        return null;
    }

    private CacheCoordinationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

