/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CacheKeyType implements Enumerator
{
    IDVALUE(0, "IDVALUE", "ID_VALUE"),
    CACHEKEY(1, "CACHEKEY", "CACHE_KEY"),
    AUTO(2, "AUTO", "AUTO");

    public static final int IDVALUE_VALUE = 0;
    public static final int CACHEKEY_VALUE = 1;
    public static final int AUTO_VALUE = 2;
    private static final CacheKeyType[] VALUES_ARRAY;
    public static final List<CacheKeyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheKeyType[]{IDVALUE, CACHEKEY, AUTO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheKeyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheKeyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheKeyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheKeyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheKeyType get(int value) {
        switch (value) {
            case 0: {
                return IDVALUE;
            }
            case 1: {
                return CACHEKEY;
            }
            case 2: {
                return AUTO;
            }
        }
        return null;
    }

    private CacheKeyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

