/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChangeTrackingType implements Enumerator
{
    ATTRIBUTE(0, "ATTRIBUTE", "ATTRIBUTE"),
    OBJECT(1, "OBJECT", "OBJECT"),
    DEFERRED(2, "DEFERRED", "DEFERRED"),
    AUTO(3, "AUTO", "AUTO");

    public static final int ATTRIBUTE_VALUE = 0;
    public static final int OBJECT_VALUE = 1;
    public static final int DEFERRED_VALUE = 2;
    public static final int AUTO_VALUE = 3;
    private static final ChangeTrackingType[] VALUES_ARRAY;
    public static final List<ChangeTrackingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChangeTrackingType[]{ATTRIBUTE, OBJECT, DEFERRED, AUTO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChangeTrackingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeTrackingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeTrackingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeTrackingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeTrackingType get(int value) {
        switch (value) {
            case 0: {
                return ATTRIBUTE;
            }
            case 1: {
                return OBJECT;
            }
            case 2: {
                return DEFERRED;
            }
            case 3: {
                return AUTO;
            }
        }
        return null;
    }

    private ChangeTrackingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

