/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DirectionType implements Enumerator
{
    IN(0, "IN", "IN"),
    OUT(1, "OUT", "OUT"),
    INOUT(2, "INOUT", "IN_OUT"),
    OUTCURSOR(3, "OUTCURSOR", "OUT_CURSOR");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    public static final int OUTCURSOR_VALUE = 3;
    private static final DirectionType[] VALUES_ARRAY;
    public static final List<DirectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DirectionType[]{IN, OUT, INOUT, OUTCURSOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DirectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionType get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
            case 3: {
                return OUTCURSOR;
            }
        }
        return null;
    }

    private DirectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

