/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IdValidation implements Enumerator
{
    NULL(0, "NULL", "NULL"),
    ZERO(1, "ZERO", "ZERO"),
    NONE(2, "NONE", "NONE");

    public static final int NULL_VALUE = 0;
    public static final int ZERO_VALUE = 1;
    public static final int NONE_VALUE = 2;
    private static final IdValidation[] VALUES_ARRAY;
    public static final List<IdValidation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IdValidation[]{NULL, ZERO, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IdValidation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdValidation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdValidation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdValidation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdValidation get(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return ZERO;
            }
            case 2: {
                return NONE;
            }
        }
        return null;
    }

    private IdValidation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

