/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LockModeType implements Enumerator
{
    READ(0, "READ", "READ"),
    WRITE(1, "WRITE", "WRITE"),
    OPTIMISTIC(2, "OPTIMISTIC", "OPTIMISTIC"),
    OPTIMISTICFORCEINCREMENT(3, "OPTIMISTICFORCEINCREMENT", "OPTIMISTIC_FORCE_INCREMENT"),
    PESSIMISTICREAD(4, "PESSIMISTICREAD", "PESSIMISTIC_READ"),
    PESSIMISTICWRITE(5, "PESSIMISTICWRITE", "PESSIMISTIC_WRITE"),
    PESSIMISTICFORCEINCREMENT(6, "PESSIMISTICFORCEINCREMENT", "PESSIMISTIC_FORCE_INCREMENT"),
    NONE(7, "NONE", "NONE");

    public static final int READ_VALUE = 0;
    public static final int WRITE_VALUE = 1;
    public static final int OPTIMISTIC_VALUE = 2;
    public static final int OPTIMISTICFORCEINCREMENT_VALUE = 3;
    public static final int PESSIMISTICREAD_VALUE = 4;
    public static final int PESSIMISTICWRITE_VALUE = 5;
    public static final int PESSIMISTICFORCEINCREMENT_VALUE = 6;
    public static final int NONE_VALUE = 7;
    private static final LockModeType[] VALUES_ARRAY;
    public static final List<LockModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LockModeType[]{READ, WRITE, OPTIMISTIC, OPTIMISTICFORCEINCREMENT, PESSIMISTICREAD, PESSIMISTICWRITE, PESSIMISTICFORCEINCREMENT, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LockModeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LockModeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LockModeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LockModeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LockModeType get(int value) {
        switch (value) {
            case 0: {
                return READ;
            }
            case 1: {
                return WRITE;
            }
            case 2: {
                return OPTIMISTIC;
            }
            case 3: {
                return OPTIMISTICFORCEINCREMENT;
            }
            case 4: {
                return PESSIMISTICREAD;
            }
            case 5: {
                return PESSIMISTICWRITE;
            }
            case 6: {
                return PESSIMISTICFORCEINCREMENT;
            }
            case 7: {
                return NONE;
            }
        }
        return null;
    }

    private LockModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

