/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OrderColumnCorrectionType implements Enumerator
{
    READ(0, "READ", "READ"),
    READWRITE(1, "READWRITE", "READ_WRITE"),
    EXCEPTION(2, "EXCEPTION", "EXCEPTION");

    public static final int READ_VALUE = 0;
    public static final int READWRITE_VALUE = 1;
    public static final int EXCEPTION_VALUE = 2;
    private static final OrderColumnCorrectionType[] VALUES_ARRAY;
    public static final List<OrderColumnCorrectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OrderColumnCorrectionType[]{READ, READWRITE, EXCEPTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OrderColumnCorrectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderColumnCorrectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderColumnCorrectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderColumnCorrectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderColumnCorrectionType get(int value) {
        switch (value) {
            case 0: {
                return READ;
            }
            case 1: {
                return READWRITE;
            }
            case 2: {
                return EXCEPTION;
            }
        }
        return null;
    }

    private OrderColumnCorrectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

