/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEStructuralFeature;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EAttributeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.orm.annotations.model.orm.AccessType;
import org.eclipse.emf.texo.orm.annotations.model.orm.Basic;
import org.eclipse.emf.texo.orm.annotations.model.orm.CollectionTable;
import org.eclipse.emf.texo.orm.annotations.model.orm.Column;
import org.eclipse.emf.texo.orm.annotations.model.orm.ElementCollection;
import org.eclipse.emf.texo.orm.annotations.model.orm.Entity;
import org.eclipse.emf.texo.orm.annotations.model.orm.EnumType;
import org.eclipse.emf.texo.orm.annotations.model.orm.Id;
import org.eclipse.emf.texo.orm.annotations.model.orm.JoinColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.Lob;
import org.eclipse.emf.texo.orm.annotations.model.orm.ManyToOne;
import org.eclipse.emf.texo.orm.annotations.model.orm.OneToMany;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrderColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotations.model.orm.TemporalType;
import org.eclipse.emf.texo.orm.annotations.model.orm.Transient;
import org.eclipse.emf.texo.orm.annotations.model.orm.UniqueConstraint;
import org.eclipse.emf.texo.orm.annotations.model.orm.Version;
import org.eclipse.emf.texo.orm.annotator.EStructuralFeatureORMAnnotator;
import org.eclipse.emf.texo.orm.annotator.ORMMappingOptions;
import org.eclipse.emf.texo.orm.annotator.ORMNamingStrategy;
import org.eclipse.emf.texo.orm.ormannotations.EAttributeORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EDataTypeORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EEnumORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.OrmannotationsPackage;

public class EAttributeORMAnnotator
extends EStructuralFeatureORMAnnotator
implements Annotator<EAttributeORMAnnotation> {
    public void setAnnotationFeatures(EAttributeORMAnnotation annotation) {
        Column column;
        EAttribute eAttribute = annotation.getEAttribute();
        EPackage ePackage = eAttribute.getEContainingClass().getEPackage();
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(ePackage);
        EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        EClass eClass = eAttribute.getEContainingClass();
        if (GenUtils.isDocumentRoot((EClass)eClass)) {
            return;
        }
        EClassORMAnnotation eClassORMAnnotation = (EClassORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClass, OrmannotationsPackage.eINSTANCE.getEClassORMAnnotation());
        if (eAttribute.getEAttributeType() instanceof EEnum) {
            this.copyAnnotationsFromEEnum(annotation);
        } else {
            this.copyAnnotationsFromDataType(annotation);
        }
        if (annotation.getTransient() != null) {
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getTransient().getName())) {
                annotation.getTransient().setName(this.getName(eAttribute));
            }
            return;
        }
        if (annotation.getId() != null) {
            Id id = annotation.getId();
            if (GeneratorUtils.isEmptyOrNull((String)id.getName())) {
                id.setName(this.getName(eAttribute));
            }
            if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
                id.setAccess(AccessType.PROPERTY);
            }
            return;
        }
        if (annotation.getVersion() != null) {
            Version version = annotation.getVersion();
            if (GeneratorUtils.isEmptyOrNull((String)version.getName())) {
                version.setName(this.getName(eAttribute));
            }
            if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
                version.setAccess(AccessType.PROPERTY);
            }
            return;
        }
        EAttributeModelGenAnnotation eAttributeModelGen = (EAttributeModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
        boolean isPartOfFeatureMap = GeneratorUtils.isPartOfGroup((EStructuralFeature)eAttribute);
        if (annotation.getTransient() != null) {
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getTransient().getName())) {
                annotation.getTransient().setName(eAttributeModelGen.getValidJavaMemberName());
            }
            return;
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
            Entity featureMapEntity;
            if (annotation.getFeatureMapEntity() == null) {
                annotation.setFeatureMapEntity(OrmFactory.eINSTANCE.createEntity());
            }
            if (GeneratorUtils.isEmptyOrNull((String)(featureMapEntity = annotation.getFeatureMapEntity()).getClass_())) {
                featureMapEntity.setClass(eAttributeModelGen.getFeatureMapQualifiedClassName());
            }
            if (GeneratorUtils.isEmptyOrNull((String)featureMapEntity.getName())) {
                featureMapEntity.setName(namingStrategy.getFeatureMapEntityName(eAttribute));
            }
            if (isPartOfFeatureMap) {
                if (annotation.getManyToOne() == null) {
                    annotation.setManyToOne(OrmFactory.eINSTANCE.createManyToOne());
                }
                ManyToOne ManyToOne2 = annotation.getManyToOne();
                ManyToOne2.setTargetEntity(eAttributeModelGen.getFeatureMapQualifiedClassName());
                ManyToOne2.setCascade(OrmFactory.eINSTANCE.createCascadeType());
                ManyToOne2.getCascade().setCascadeAll(OrmFactory.eINSTANCE.createEmptyType());
                ManyToOne2.setName(this.getName(eAttribute));
            } else {
                if (annotation.getOneToMany() == null) {
                    annotation.setOneToMany(OrmFactory.eINSTANCE.createOneToMany());
                }
                OneToMany oneToMany = annotation.getOneToMany();
                oneToMany.setTargetEntity(eAttributeModelGen.getFeatureMapQualifiedClassName());
                oneToMany.setCascade(OrmFactory.eINSTANCE.createCascadeType());
                oneToMany.setOrphanRemoval(true);
                oneToMany.getCascade().setCascadeAll(OrmFactory.eINSTANCE.createEmptyType());
                if (oneToMany.getJoinTable() == null) {
                    oneToMany.setJoinTable(OrmFactory.eINSTANCE.createJoinTable());
                }
                if (oneToMany.getJoinTable().getName() == null && namingStrategy.isGenerateAllDBSchemaNames()) {
                    oneToMany.getJoinTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eAttribute));
                }
                oneToMany.setName(this.getName(eAttribute));
            }
            return;
        }
        EDataType eDataType = eAttribute.getEAttributeType();
        boolean isLob = false;
        boolean isTime = false;
        boolean isDate = false;
        boolean isBigDecimal = false;
        if (eDataType.getInstanceClass() != null) {
            isLob = eDataType.getInstanceClass().isArray() && eDataType.getInstanceClass().getComponentType() == Byte.TYPE;
            isTime = Timestamp.class == eDataType.getInstanceClass() || eDataType == XMLTypePackage.eINSTANCE.getDateTime();
            isDate = eDataType == XMLTypePackage.eINSTANCE.getDate() || eDataType.getInstanceClass() != null && Date.class.isAssignableFrom(eDataType.getInstanceClass());
            isBigDecimal = BigDecimal.class == eDataType.getInstanceClass() || eDataType == XMLTypePackage.eINSTANCE.getDecimal();
        }
        boolean isEnum = eDataType instanceof EEnum;
        if (!isPartOfFeatureMap && eAttribute.isMany()) {
            ElementCollection elementCollection;
            if (annotation.getElementCollection() == null) {
                elementCollection = OrmFactory.eINSTANCE.createElementCollection();
                annotation.setElementCollection(elementCollection);
            } else {
                elementCollection = annotation.getElementCollection();
            }
            if (isLob) {
                Lob lob = OrmFactory.eINSTANCE.createLob();
                elementCollection.setLob(lob);
            } else if (isTime) {
                elementCollection.setTemporal(TemporalType.TIMESTAMP);
            } else if (isDate) {
                elementCollection.setTemporal(TemporalType.DATE);
            } else if (isBigDecimal && elementCollection.getColumn() == null && ORMMappingOptions.getDefaultOptions().isTestRun()) {
                Column column2 = OrmFactory.eINSTANCE.createColumn();
                column2.setScale(7);
                column2.setPrecision(15);
                elementCollection.setColumn(column2);
            } else if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)eAttributeModelGen)) {
                elementCollection.setConvert("TexoTestObjectConverter");
            } else if (this.doAddQNameConverter((EStructuralFeatureModelGenAnnotation)eAttributeModelGen)) {
                elementCollection.setConvert("TexoTestQNameConverter");
            }
            if (isEnum && elementCollection.getEnumerated() == null) {
                elementCollection.setEnumerated(EnumType.STRING);
            }
            if (elementCollection.getCollectionTable() == null) {
                CollectionTable collectionTable = OrmFactory.eINSTANCE.createCollectionTable();
                elementCollection.setCollectionTable(collectionTable);
                collectionTable.setName(null);
            }
            if (namingStrategy.isGenerateAllDBSchemaNames()) {
                if (GeneratorUtils.isEmptyOrNull((String)elementCollection.getCollectionTable().getName())) {
                    elementCollection.getCollectionTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eAttribute));
                }
                if (elementCollection.getColumn() == null) {
                    elementCollection.setColumn(OrmFactory.eINSTANCE.createColumn());
                }
                if (elementCollection.getColumn().getName() == null) {
                    elementCollection.getColumn().setName(namingStrategy.getCollectionElementColumnName((EStructuralFeature)eAttribute));
                }
                if (elementCollection.getCollectionTable().getJoinColumn().isEmpty()) {
                    elementCollection.getCollectionTable().getJoinColumn().add((Object)OrmFactory.eINSTANCE.createJoinColumn());
                    ((JoinColumn)elementCollection.getCollectionTable().getJoinColumn().get(0)).setName(namingStrategy.getJoinColumnName((EStructuralFeature)eAttribute));
                }
                if (eAttribute.isUnique()) {
                    UniqueConstraint uniqueConstraint = OrmFactory.eINSTANCE.createUniqueConstraint();
                    uniqueConstraint.getColumnName().add((Object)elementCollection.getColumn().getName());
                    uniqueConstraint.getColumnName().add((Object)((JoinColumn)elementCollection.getCollectionTable().getJoinColumn().get(0)).getName());
                }
            }
            EAttributeModelGenAnnotation eAttributeModelGenAnnotation = (EAttributeModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
            OrderColumn orderColumn = elementCollection.getOrderColumn();
            if (ePackageORMAnnotation.isAddOrderColumnToListMappings() && eAttributeModelGenAnnotation.isUseList() && elementCollection.getOrderBy() == null && elementCollection.getOrderColumn() == null) {
                orderColumn = OrmFactory.eINSTANCE.createOrderColumn();
                elementCollection.setOrderColumn(orderColumn);
            }
            if (orderColumn != null && GeneratorUtils.isEmptyOrNull((String)orderColumn.getName()) && namingStrategy.isGenerateAllDBSchemaNames()) {
                orderColumn.setName(namingStrategy.getIndexColumnName((EStructuralFeature)eAttribute));
            }
            if (GeneratorUtils.isEmptyOrNull((String)elementCollection.getName())) {
                elementCollection.setName(this.getName(eAttribute));
            }
            if (!eAttribute.isChangeable()) {
                elementCollection.setAccess(AccessType.FIELD);
            }
            return;
        }
        boolean basicSet = true;
        if (annotation.getBasic() == null) {
            basicSet = false;
            annotation.setBasic(OrmFactory.eINSTANCE.createBasic());
        }
        Basic basic = annotation.getBasic();
        if (!eAttribute.isChangeable()) {
            basic.setAccess(AccessType.FIELD);
        } else if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
            basic.setAccess(AccessType.PROPERTY);
        }
        if (GeneratorUtils.isEmptyOrNull((String)basic.getName())) {
            basic.setName(this.getName(eAttribute));
        }
        if (isLob) {
            Lob lob = OrmFactory.eINSTANCE.createLob();
            basic.setLob(lob);
        } else if (!basicSet && isTime) {
            basic.setTemporal(TemporalType.TIMESTAMP);
        } else if (!basicSet && isDate) {
            basic.setTemporal(TemporalType.DATE);
        } else if (isBigDecimal && basic.getColumn() == null && ORMMappingOptions.getDefaultOptions().isTestRun()) {
            column = OrmFactory.eINSTANCE.createColumn();
            column.setScale(7);
            column.setPrecision(15);
            basic.setColumn(column);
        } else if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)eAttributeModelGen)) {
            basic.setConvert("TexoTestObjectConverter");
        } else if (this.doAddQNameConverter((EStructuralFeatureModelGenAnnotation)eAttributeModelGen)) {
            basic.setConvert("TexoTestQNameConverter");
        }
        if (!basicSet && !GeneratorUtils.isOptional((EStructuralFeature)eAttribute)) {
            basic.setOptional(false);
        }
        if (isEnum && basic.getEnumerated() == null) {
            basic.setEnumerated(EnumType.STRING);
        }
        if (namingStrategy.isGenerateAllDBSchemaNames()) {
            if (basic.getColumn() == null) {
                basic.setColumn(OrmFactory.eINSTANCE.createColumn());
            }
            if ((column = basic.getColumn()).getName() == null) {
                column.setName(namingStrategy.getColumnName(annotation.getEStructuralFeature()));
            }
            if (!this.hasItsOwnTable(eClassORMAnnotation)) {
                column.setNullable(true);
            }
        }
    }

    private void copyAnnotationsFromDataType(EAttributeORMAnnotation annotation) {
        EDataTypeORMAnnotation eDataTypeORMAnnotation = (EDataTypeORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)annotation.getEAttribute().getEAttributeType(), OrmannotationsPackage.eINSTANCE.getEDataTypeORMAnnotation());
        if (annotation.getId() != null || annotation.getVersion() != null || annotation.getBasic() != null || annotation.getElementCollection() != null) {
            return;
        }
        if (eDataTypeORMAnnotation.getId() != null) {
            annotation.setId((Id)EcoreUtil.copy((EObject)eDataTypeORMAnnotation.getId()));
            return;
        }
        if (eDataTypeORMAnnotation.getBasic() != null) {
            annotation.setBasic((Basic)EcoreUtil.copy((EObject)eDataTypeORMAnnotation.getBasic()));
            return;
        }
        if (eDataTypeORMAnnotation.getTransient() != null) {
            annotation.setTransient((Transient)EcoreUtil.copy((EObject)eDataTypeORMAnnotation.getTransient()));
            return;
        }
        if (eDataTypeORMAnnotation.getVersion() != null) {
            annotation.setVersion((Version)EcoreUtil.copy((EObject)eDataTypeORMAnnotation.getVersion()));
            return;
        }
        if (annotation.getEAttribute().isMany() && annotation.getElementCollection() == null && eDataTypeORMAnnotation.getElementCollection() != null) {
            annotation.setElementCollection((ElementCollection)EcoreUtil.copy((EObject)eDataTypeORMAnnotation.getElementCollection()));
        }
    }

    private void copyAnnotationsFromEEnum(EAttributeORMAnnotation annotation) {
        EEnumORMAnnotation eEnumORMAnnotation = (EEnumORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)annotation.getEAttribute().getEAttributeType(), OrmannotationsPackage.eINSTANCE.getEEnumORMAnnotation());
        if (annotation.getId() != null || annotation.getVersion() != null || annotation.getBasic() != null || annotation.getElementCollection() != null) {
            return;
        }
        if (eEnumORMAnnotation.getBasic() != null) {
            annotation.setBasic((Basic)EcoreUtil.copy((EObject)eEnumORMAnnotation.getBasic()));
            return;
        }
        if (eEnumORMAnnotation.getTransient() != null) {
            annotation.setTransient((Transient)EcoreUtil.copy((EObject)eEnumORMAnnotation.getTransient()));
            return;
        }
        if (eEnumORMAnnotation.getVersion() != null) {
            annotation.setVersion((Version)EcoreUtil.copy((EObject)eEnumORMAnnotation.getVersion()));
            return;
        }
        if (annotation.getEAttribute().isMany() && annotation.getElementCollection() == null && eEnumORMAnnotation.getElementCollection() != null) {
            annotation.setElementCollection((ElementCollection)EcoreUtil.copy((EObject)eEnumORMAnnotation.getElementCollection()));
        }
    }

    public void postAnnotating(EAttributeORMAnnotation annotation) {
    }

    private String getName(EAttribute eAttribute) {
        EAttributeModelGenAnnotation modelGenAnnotation = (EAttributeModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
        return modelGenAnnotation.getValidJavaMemberName();
    }

    public EClass getAnnotationEClass() {
        return OrmannotationsPackage.eINSTANCE.getEAttributeORMAnnotation();
    }
}

