/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.orm.annotations.model.orm.Inheritance;
import org.eclipse.emf.texo.orm.annotations.model.orm.InheritanceType;
import org.eclipse.emf.texo.orm.annotator.ORMNamingStrategy;
import org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.OrmannotationsPackage;

public abstract class ENamedElementORMAnnotator {
    private AnnotationManager annotationManager;

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public void setAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }

    public ORMNamingStrategy getOrmNamingStrategy(EPackage ePackage) {
        EPackageORMAnnotation annotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        return annotation.getNamingStrategy();
    }

    private Inheritance getInheritance(EClassORMAnnotation orm) {
        if (orm.getEntity() != null && orm.getEntity().getInheritance() != null) {
            return orm.getEntity().getInheritance();
        }
        if (orm.getInheritance() != null) {
            return orm.getInheritance();
        }
        EClass eClass = orm.getAnnotatedEClass().getEClass();
        for (EClass eSuperType : eClass.getESuperTypes()) {
            EClassORMAnnotation superOrm = (EClassORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eSuperType, OrmannotationsPackage.eINSTANCE.getEClassORMAnnotation());
            Inheritance inheritance = this.getInheritance(superOrm);
            if (inheritance == null) continue;
            return inheritance;
        }
        EPackageORMAnnotation ePackageAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClass.getEPackage(), OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        if (ePackageAnnotation.getInheritance() != null) {
            return ePackageAnnotation.getInheritance();
        }
        return null;
    }

    protected boolean hasItsOwnTable(EClassORMAnnotation annotation) {
        boolean isRoot = this.isRoot(annotation);
        Inheritance inheritance = this.getInheritance(annotation);
        return isRoot || inheritance != null && inheritance.getStrategy() != InheritanceType.SINGLETABLE;
    }

    protected boolean isRoot(EClassORMAnnotation ormAnnotation) {
        EClass eClass = ormAnnotation.getEClass();
        if (eClass.getESuperTypes().isEmpty()) {
            return true;
        }
        for (EClass eSuperType : eClass.getESuperTypes()) {
            EClassORMAnnotation superOrmAnnotation = (EClassORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eSuperType, OrmannotationsPackage.eINSTANCE.getEClassORMAnnotation());
            if (superOrmAnnotation.getEClass().isInterface() || superOrmAnnotation.getMappedSuperclass() != null || superOrmAnnotation.getTransient() != null) continue;
            return false;
        }
        return true;
    }
}

