/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEStructuralFeature;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EReferenceModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.orm.annotations.model.orm.AccessType;
import org.eclipse.emf.texo.orm.annotations.model.orm.CascadeType;
import org.eclipse.emf.texo.orm.annotations.model.orm.CollectionTable;
import org.eclipse.emf.texo.orm.annotations.model.orm.ElementCollection;
import org.eclipse.emf.texo.orm.annotations.model.orm.Embedded;
import org.eclipse.emf.texo.orm.annotations.model.orm.JoinColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.JoinTable;
import org.eclipse.emf.texo.orm.annotations.model.orm.ManyToMany;
import org.eclipse.emf.texo.orm.annotations.model.orm.ManyToOne;
import org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.OneToMany;
import org.eclipse.emf.texo.orm.annotations.model.orm.OneToOne;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrderColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotations.model.orm.UniqueConstraint;
import org.eclipse.emf.texo.orm.annotator.EStructuralFeatureORMAnnotator;
import org.eclipse.emf.texo.orm.annotator.ORMNamingStrategy;
import org.eclipse.emf.texo.orm.annotator.ORMUtils;
import org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EReferenceORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.OrmannotationsPackage;
import org.eclipse.emf.texo.utils.ModelUtils;

public class EReferenceORMAnnotator
extends EStructuralFeatureORMAnnotator
implements Annotator<EReferenceORMAnnotation> {
    public void setAnnotationFeatures(EReferenceORMAnnotation annotation) {
        if (annotation.getTransient() != null) {
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getTransient().getName())) {
                annotation.getTransient().setName(this.getName(annotation.getEReference()));
            }
            return;
        }
        EReference eReference = annotation.getEReference();
        EClass eClass = eReference.getEContainingClass();
        if (GenUtils.isDocumentRoot((EClass)eClass)) {
            return;
        }
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        EReferenceModelGenAnnotation eReferenceModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
        boolean isPartOfFeatureMap = GeneratorUtils.isPartOfGroup((EStructuralFeature)annotation.getEReference());
        EReference eOpposite = eReference.getEOpposite();
        if (!isPartOfFeatureMap && eReference.isMany()) {
            if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)eReferenceModelGenAnnotation) || annotation.getEmbedded() != null) {
                this.addElementCollection(annotation);
            } else if (annotation.getElementCollection() != null) {
                this.annotateElementCollection(annotation);
            } else if (ModelUtils.isEMap((EClass)annotation.getEReference().getEReferenceType())) {
                this.mapMap(annotation);
            } else if (eOpposite != null && eOpposite.isMany()) {
                this.annotateManyToMany(annotation);
            } else if (eOpposite != null && !eOpposite.isMany()) {
                this.annotateOneToMany(annotation);
            } else if (eReference.isContainment() || annotation.getOneToMany() != null || !ePackageORMAnnotation.isUseJoinTablesForNonContainment()) {
                this.annotateOneToMany(annotation);
            } else {
                this.annotateManyToMany(annotation);
            }
        } else {
            EClass referencedEClass = eReference.getEReferenceType();
            EClassORMAnnotation referencedEClassORMAnnotation = (EClassORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)referencedEClass, OrmannotationsPackage.eINSTANCE.getEClassORMAnnotation());
            if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)eReferenceModelGenAnnotation)) {
                annotation.setBasic(OrmFactory.eINSTANCE.createBasic());
                annotation.getBasic().setConvert("TexoTestObjectConverter");
            } else if (annotation.getEmbedded() != null || referencedEClassORMAnnotation.getEmbeddable() != null && referencedEClassORMAnnotation.getEntity() == null) {
                this.annotateEmbedded(annotation);
            } else if (eOpposite != null && !eOpposite.isMany()) {
                this.annotateOneToOne(annotation);
            } else {
                this.annotateManyToOne(annotation);
            }
        }
    }

    public void postAnnotating(EReferenceORMAnnotation annotation) {
    }

    protected void annotateElementCollection(EReferenceORMAnnotation annotation) {
        EReference eReference = annotation.getEReference();
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(ePackage);
        EReferenceModelGenAnnotation eReferenceModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
        if (annotation.getEmbedded() != null) {
            annotation.getElementCollection().getAttributeOverride().addAll(annotation.getEmbedded().getAttributeOverride());
            annotation.getElementCollection().getAssociationOverride().addAll(annotation.getEmbedded().getAssociationOverride());
            annotation.getElementCollection().setAttributeType(annotation.getEmbedded().getAttributeType());
            annotation.setEmbedded(null);
        }
        ElementCollection elementCollection = annotation.getElementCollection();
        if (!eReference.isChangeable()) {
            elementCollection.setAccess(AccessType.FIELD);
        } else if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
            elementCollection.setAccess(AccessType.PROPERTY);
        }
        if (GeneratorUtils.isEmptyOrNull((String)elementCollection.getName())) {
            elementCollection.setName(this.getName(eReference));
        }
        if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)eReferenceModelGenAnnotation)) {
            elementCollection.setConvert("TexoTestObjectConverter");
        }
        if (!ModelUtils.isEMap((EClass)eReference.getEReferenceType()) && elementCollection.getOrderColumn() == null && eReferenceModelGenAnnotation.isUseList()) {
            OrderColumn orderColumn = OrmFactory.eINSTANCE.createOrderColumn();
            if (namingStrategy.isGenerateAllDBSchemaNames()) {
                orderColumn.setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
            }
            elementCollection.setOrderColumn(orderColumn);
        }
        if (elementCollection.getCollectionTable() == null && namingStrategy.isGenerateAllDBSchemaNames()) {
            CollectionTable collectionTable = OrmFactory.eINSTANCE.createCollectionTable();
            elementCollection.setCollectionTable(collectionTable);
        }
        if (eReference.isContainment()) {
            elementCollection.setCascadeOnDelete(true);
        }
        if (namingStrategy.isGenerateAllDBSchemaNames()) {
            if (elementCollection.getCollectionTable() != null && GeneratorUtils.isEmptyOrNull((String)elementCollection.getCollectionTable().getName())) {
                elementCollection.getCollectionTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eReference));
            }
            if (elementCollection.getOrderColumn() != null && GeneratorUtils.isEmptyOrNull((String)elementCollection.getOrderColumn().getName())) {
                elementCollection.getOrderColumn().setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
            }
        }
    }

    protected void annotateOneToMany(EReferenceORMAnnotation annotation) {
        boolean isOwner;
        OneToMany oneToMany;
        EReference eReference = annotation.getEReference();
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(ePackage);
        EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        if (annotation.getOneToMany() != null) {
            oneToMany = annotation.getOneToMany();
        } else {
            oneToMany = OrmFactory.eINSTANCE.createOneToMany();
            annotation.setOneToMany(oneToMany);
        }
        if (oneToMany.getJoinColumn().isEmpty()) {
            for (JoinColumn jc : annotation.getJoinColumn()) {
                oneToMany.getJoinColumn().add((Object)((JoinColumn)EcoreUtil.copy((EObject)jc)));
            }
        }
        if (oneToMany.getJoinTable() == null) {
            oneToMany.setJoinTable(annotation.getJoinTable());
        }
        if (!eReference.isChangeable()) {
            oneToMany.setAccess(AccessType.FIELD);
        } else if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
            oneToMany.setAccess(AccessType.PROPERTY);
        }
        if (oneToMany.getCascade() == null) {
            if (eReference.isContainment()) {
                oneToMany.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeContainment()));
            } else {
                oneToMany.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeNonContainment()));
            }
            if (oneToMany.getCascade() == null) {
                oneToMany.setCascade(OrmFactory.eINSTANCE.createCascadeType());
                if (eReference.isContainment()) {
                    oneToMany.getCascade().setCascadeAll(OrmFactory.eINSTANCE.createEmptyType());
                } else {
                    oneToMany.getCascade().setCascadeMerge(OrmFactory.eINSTANCE.createEmptyType());
                    oneToMany.getCascade().setCascadePersist(OrmFactory.eINSTANCE.createEmptyType());
                    oneToMany.getCascade().setCascadeRefresh(OrmFactory.eINSTANCE.createEmptyType());
                }
            }
        }
        if (GeneratorUtils.isEmptyOrNull((String)oneToMany.getName())) {
            oneToMany.setName(this.getName(eReference));
        }
        if (ModelUtils.isEMap((EClass)eReference.getEReferenceType())) {
            if (oneToMany.getJoinTable() == null) {
                JoinTable joinTable = OrmFactory.eINSTANCE.createJoinTable();
                oneToMany.setJoinTable(joinTable);
            }
            if (oneToMany.getJoinTable() != null && GeneratorUtils.isEmptyOrNull((String)oneToMany.getJoinTable().getName())) {
                oneToMany.getJoinTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eReference));
            }
            if (namingStrategy.isGenerateAllDBSchemaNames()) {
                this.addColumnsToJoinTable(namingStrategy, oneToMany.getJoinTable(), annotation);
            }
            if (oneToMany.getMapKeyColumn() == null) {
                MapKeyColumn mapKeyColumn = OrmFactory.eINSTANCE.createMapKeyColumn();
                mapKeyColumn.setTable(oneToMany.getJoinTable().getName());
                if (namingStrategy.isGenerateAllDBSchemaNames()) {
                    mapKeyColumn.setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
                }
                oneToMany.setMapKeyColumn(mapKeyColumn);
            }
            return;
        }
        EReferenceModelGenAnnotation eReferenceModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
        if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)eReferenceModelGenAnnotation)) {
            oneToMany.setConverter(ORMUtils.createDefaultConverter());
        }
        if (!ModelUtils.isEMap((EClass)eReference.getEReferenceType()) && oneToMany.getOrderBy() == null && ePackageORMAnnotation.isAddOrderColumnToListMappings() && eReferenceModelGenAnnotation.isUseList() && oneToMany.getOrderColumn() == null) {
            OrderColumn orderColumn = OrmFactory.eINSTANCE.createOrderColumn();
            if (namingStrategy.isGenerateAllDBSchemaNames()) {
                orderColumn.setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
            }
            oneToMany.setOrderColumn(orderColumn);
        }
        boolean bl = isOwner = eReferenceModelGenAnnotation.isUseList() || this.isOwner(eReference);
        if (!isOwner && eReference.getEOpposite() != null && GeneratorUtils.isEmptyOrNull((String)oneToMany.getMappedBy())) {
            oneToMany.setMappedBy(this.getMappedBy(eReference));
        }
        if (isOwner && oneToMany.getJoinColumn().isEmpty() && oneToMany.getJoinTable() == null) {
            JoinColumn joinColumn;
            JoinTable joinTable;
            if (eReference.isContainment()) {
                if (ePackageORMAnnotation.isUseJoinTablesForContainment()) {
                    joinTable = OrmFactory.eINSTANCE.createJoinTable();
                    oneToMany.setJoinTable(joinTable);
                } else if (namingStrategy.isGenerateAllDBSchemaNames()) {
                    joinColumn = OrmFactory.eINSTANCE.createJoinColumn();
                    oneToMany.getJoinColumn().add((Object)joinColumn);
                }
            } else if (ePackageORMAnnotation.isUseJoinTablesForNonContainment()) {
                joinTable = OrmFactory.eINSTANCE.createJoinTable();
                oneToMany.setJoinTable(joinTable);
            } else if (namingStrategy.isGenerateAllDBSchemaNames()) {
                joinColumn = OrmFactory.eINSTANCE.createJoinColumn();
                oneToMany.getJoinColumn().add((Object)joinColumn);
            }
        }
        if (namingStrategy.isGenerateAllDBSchemaNames()) {
            if (oneToMany.getJoinTable() != null) {
                if (GeneratorUtils.isEmptyOrNull((String)oneToMany.getJoinTable().getName())) {
                    oneToMany.getJoinTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eReference));
                }
                this.addColumnsToJoinTable(namingStrategy, oneToMany.getJoinTable(), annotation);
            }
            if (oneToMany.getOrderColumn() != null && GeneratorUtils.isEmptyOrNull((String)oneToMany.getOrderColumn().getName())) {
                oneToMany.getOrderColumn().setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
            }
            for (JoinColumn jc : oneToMany.getJoinColumn()) {
                if (!GeneratorUtils.isEmptyOrNull((String)jc.getName())) continue;
                jc.setName(namingStrategy.getJoinColumnName((EStructuralFeature)eReference));
            }
        }
    }

    protected void mapMap(EReferenceORMAnnotation annotation) {
        EClass mapEClass = annotation.getEReference().getEReferenceType();
        EStructuralFeature valueEFeature = mapEClass.getEStructuralFeature("value");
        if (valueEFeature instanceof EReference) {
            this.annotateOneToMany(annotation);
        } else {
            this.addElementCollection(annotation);
        }
    }

    protected void addElementCollection(EReferenceORMAnnotation annotation) {
        ElementCollection elementCollection;
        if (annotation.getElementCollection() == null) {
            elementCollection = OrmFactory.eINSTANCE.createElementCollection();
            annotation.setElementCollection(elementCollection);
        } else {
            elementCollection = annotation.getElementCollection();
        }
        annotation.setElementCollection(elementCollection);
        this.annotateElementCollection(annotation);
    }

    protected void annotateEmbedded(EReferenceORMAnnotation annotation) {
        Embedded embedded;
        EReference eReference = annotation.getEReference();
        if (annotation.getEmbedded() != null) {
            embedded = annotation.getEmbedded();
        } else {
            embedded = OrmFactory.eINSTANCE.createEmbedded();
            annotation.setEmbedded(embedded);
        }
        if (GeneratorUtils.isEmptyOrNull((String)embedded.getName())) {
            embedded.setName(this.getName(eReference));
        }
    }

    protected void annotateOneToOne(EReferenceORMAnnotation annotation) {
        OneToOne oneToOne;
        EReference eReference = annotation.getEReference();
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        boolean generatedOneToOne = false;
        if (annotation.getOneToOne() != null) {
            oneToOne = annotation.getOneToOne();
        } else {
            oneToOne = OrmFactory.eINSTANCE.createOneToOne();
            annotation.setOneToOne(oneToOne);
            generatedOneToOne = true;
        }
        if (!eReference.isChangeable()) {
            oneToOne.setAccess(AccessType.FIELD);
        } else if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
            oneToOne.setAccess(AccessType.PROPERTY);
        }
        if (GeneratorUtils.isEmptyOrNull((String)oneToOne.getName())) {
            oneToOne.setName(this.getName(eReference));
        }
        if (oneToOne.getCascade() == null) {
            if (eReference.isContainment()) {
                oneToOne.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeContainment()));
            } else {
                oneToOne.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeNonContainment()));
            }
            if (oneToOne.getCascade() == null) {
                oneToOne.setCascade(OrmFactory.eINSTANCE.createCascadeType());
                if (eReference.isContainment()) {
                    oneToOne.getCascade().setCascadeAll(OrmFactory.eINSTANCE.createEmptyType());
                } else {
                    oneToOne.getCascade().setCascadeMerge(OrmFactory.eINSTANCE.createEmptyType());
                    oneToOne.getCascade().setCascadePersist(OrmFactory.eINSTANCE.createEmptyType());
                    oneToOne.getCascade().setCascadeRefresh(OrmFactory.eINSTANCE.createEmptyType());
                }
            }
        }
        if (generatedOneToOne && !this.isOwner(eReference)) {
            oneToOne.setMappedBy(this.getMappedBy(eReference));
        }
        oneToOne.getJoinColumn().addAll(annotation.getJoinColumn());
        if (oneToOne.getJoinTable() == null) {
            oneToOne.setJoinTable(annotation.getJoinTable());
        }
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(eReference.getEContainingClass().getEPackage());
        if (oneToOne.getJoinColumn().isEmpty() && namingStrategy.isGenerateAllDBSchemaNames()) {
            oneToOne.getJoinColumn().add((Object)OrmFactory.eINSTANCE.createJoinColumn());
        }
        if (namingStrategy.isGenerateAllDBSchemaNames()) {
            if (oneToOne.getJoinTable() != null) {
                if (GeneratorUtils.isEmptyOrNull((String)oneToOne.getJoinTable().getName())) {
                    oneToOne.getJoinTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eReference));
                }
                this.addColumnsToJoinTable(namingStrategy, oneToOne.getJoinTable(), annotation);
            }
            for (JoinColumn jc : oneToOne.getJoinColumn()) {
                if (!GeneratorUtils.isEmptyOrNull((String)jc.getName())) continue;
                jc.setName(namingStrategy.getForeignKeyColumnName((EStructuralFeature)eReference));
            }
        }
        if (!GeneratorUtils.isOptional((EStructuralFeature)eReference)) {
            oneToOne.setOptional(false);
        }
    }

    protected void annotateManyToOne(EReferenceORMAnnotation annotation) {
        ManyToOne manyToOne;
        EReference eReference = annotation.getEReference();
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        EClassORMAnnotation eClassORMAnnotation = (EClassORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference.getEContainingClass(), OrmannotationsPackage.eINSTANCE.getEClassORMAnnotation());
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(eReference.getEContainingClass().getEPackage());
        if (annotation.getManyToOne() != null) {
            manyToOne = annotation.getManyToOne();
        } else {
            manyToOne = OrmFactory.eINSTANCE.createManyToOne();
            annotation.setManyToOne(manyToOne);
        }
        if (GeneratorUtils.isEmptyOrNull((String)manyToOne.getName())) {
            manyToOne.setName(this.getName(eReference));
        }
        if (!eReference.isChangeable()) {
            manyToOne.setAccess(AccessType.FIELD);
        } else if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
            manyToOne.setAccess(AccessType.PROPERTY);
        }
        if (manyToOne.getCascade() == null) {
            if (eReference.isContainment()) {
                manyToOne.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeContainment()));
            } else {
                manyToOne.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeNonContainment()));
            }
            if (manyToOne.getCascade() == null) {
                manyToOne.setCascade(OrmFactory.eINSTANCE.createCascadeType());
                if (eReference.isContainment()) {
                    manyToOne.getCascade().setCascadeAll(OrmFactory.eINSTANCE.createEmptyType());
                } else {
                    manyToOne.getCascade().setCascadeMerge(OrmFactory.eINSTANCE.createEmptyType());
                    manyToOne.getCascade().setCascadePersist(OrmFactory.eINSTANCE.createEmptyType());
                    manyToOne.getCascade().setCascadeRefresh(OrmFactory.eINSTANCE.createEmptyType());
                }
            }
        }
        if (!GeneratorUtils.isOptional((EStructuralFeature)eReference)) {
            manyToOne.setOptional(false);
        }
        manyToOne.getJoinColumn().addAll(annotation.getJoinColumn());
        if (manyToOne.getJoinTable() == null) {
            manyToOne.setJoinTable(annotation.getJoinTable());
        }
        if (manyToOne.getJoinColumn().isEmpty() && manyToOne.getJoinTable() == null) {
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite != null) {
                JoinColumn joinColumn;
                boolean isOwner;
                EReferenceModelGenAnnotation eOppositeModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eOpposite, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
                boolean bl = isOwner = !eOppositeModelGenAnnotation.isUseList() && this.isOwner(eReference);
                if (isOwner) {
                    JoinTable joinTable;
                    if (eOpposite.isContainment()) {
                        if (ePackageORMAnnotation.isUseJoinTablesForContainment()) {
                            joinTable = OrmFactory.eINSTANCE.createJoinTable();
                            manyToOne.setJoinTable(joinTable);
                        } else if (namingStrategy.isGenerateAllDBSchemaNames()) {
                            joinColumn = OrmFactory.eINSTANCE.createJoinColumn();
                            manyToOne.getJoinColumn().add((Object)joinColumn);
                        }
                    } else if (ePackageORMAnnotation.isUseJoinTablesForNonContainment()) {
                        joinTable = OrmFactory.eINSTANCE.createJoinTable();
                        manyToOne.setJoinTable(joinTable);
                    } else if (namingStrategy.isGenerateAllDBSchemaNames()) {
                        joinColumn = OrmFactory.eINSTANCE.createJoinColumn();
                        manyToOne.getJoinColumn().add((Object)joinColumn);
                    }
                } else if (eOppositeModelGenAnnotation.isUseList()) {
                    joinColumn = OrmFactory.eINSTANCE.createJoinColumn();
                    manyToOne.getJoinColumn().add((Object)joinColumn);
                }
            } else if (namingStrategy.isGenerateAllDBSchemaNames()) {
                JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn();
                manyToOne.getJoinColumn().add((Object)joinColumn);
            }
        }
        if (namingStrategy.isGenerateAllDBSchemaNames()) {
            if (manyToOne.getJoinTable() != null) {
                if (GeneratorUtils.isEmptyOrNull((String)manyToOne.getJoinTable().getName())) {
                    manyToOne.getJoinTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eReference));
                }
                this.addColumnsToJoinTable(namingStrategy, manyToOne.getJoinTable(), annotation);
            }
            for (JoinColumn jc : manyToOne.getJoinColumn()) {
                if (!GeneratorUtils.isEmptyOrNull((String)jc.getName())) continue;
                jc.setName(namingStrategy.getForeignKeyColumnName((EStructuralFeature)eReference));
            }
        }
        if (!this.hasItsOwnTable(eClassORMAnnotation)) {
            if (manyToOne.getJoinColumn().isEmpty()) {
                if (!manyToOne.isOptional()) {
                    manyToOne.setOptional(true);
                }
            } else {
                for (JoinColumn jc : manyToOne.getJoinColumn()) {
                    jc.setNullable(true);
                }
            }
        }
    }

    protected void annotateManyToMany(EReferenceORMAnnotation annotation) {
        EReferenceModelGenAnnotation eReferenceModelGenAnnotation;
        ManyToMany manyToMany;
        EReference eReference = annotation.getEReference();
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(ePackage);
        if (annotation.getManyToMany() != null) {
            manyToMany = annotation.getManyToMany();
        } else {
            manyToMany = OrmFactory.eINSTANCE.createManyToMany();
            annotation.setManyToMany(manyToMany);
        }
        if (!eReference.isChangeable()) {
            manyToMany.setAccess(AccessType.FIELD);
        } else if (GeneratorUtils.setPropertyAccess((AnnotatedEStructuralFeature)annotation.getAnnotatedEFeature())) {
            manyToMany.setAccess(AccessType.PROPERTY);
        }
        if (GeneratorUtils.isEmptyOrNull((String)manyToMany.getName())) {
            manyToMany.setName(this.getName(eReference));
        }
        if (manyToMany.getCascade() == null) {
            if (eReference.isContainment()) {
                manyToMany.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeContainment()));
            } else {
                manyToMany.setCascade((CascadeType)EcoreUtil.copy((EObject)ePackageORMAnnotation.getDefaultCascadeNonContainment()));
            }
            if (manyToMany.getCascade() == null) {
                manyToMany.setCascade(OrmFactory.eINSTANCE.createCascadeType());
                if (eReference.isContainment()) {
                    manyToMany.getCascade().setCascadeAll(OrmFactory.eINSTANCE.createEmptyType());
                } else {
                    manyToMany.getCascade().setCascadeMerge(OrmFactory.eINSTANCE.createEmptyType());
                    manyToMany.getCascade().setCascadePersist(OrmFactory.eINSTANCE.createEmptyType());
                    manyToMany.getCascade().setCascadeRefresh(OrmFactory.eINSTANCE.createEmptyType());
                }
            }
        }
        if (this.doAddConverter((EStructuralFeatureModelGenAnnotation)(eReferenceModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation())))) {
            manyToMany.setConverter(ORMUtils.createDefaultConverter());
        }
        if (manyToMany.getJoinTable() == null) {
            manyToMany.setJoinTable(annotation.getJoinTable());
        }
        if (eReference.getEOpposite() != null) {
            EReferenceModelGenAnnotation eOppositeModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference.getEOpposite(), ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
            if (eReferenceModelGenAnnotation.isUseList()) {
                if (manyToMany.getJoinTable() == null) {
                    JoinTable joinTable = OrmFactory.eINSTANCE.createJoinTable();
                    manyToMany.setJoinTable(joinTable);
                }
                if (ePackageORMAnnotation.isAddOrderColumnToListMappings() && eReferenceModelGenAnnotation.isUseList() && manyToMany.getOrderColumn() == null && manyToMany.getOrderBy() == null) {
                    OrderColumn orderColumn = OrmFactory.eINSTANCE.createOrderColumn();
                    if (namingStrategy.isGenerateAllDBSchemaNames()) {
                        orderColumn.setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
                    }
                    manyToMany.setOrderColumn(orderColumn);
                }
            } else if (eOppositeModelGenAnnotation.isUseList()) {
                manyToMany.setMappedBy(this.getMappedBy(eReference));
            } else if (!this.isOwner(eReference)) {
                manyToMany.setMappedBy(this.getMappedBy(eReference));
            }
        } else {
            if (manyToMany.getJoinTable() == null && namingStrategy.isGenerateAllDBSchemaNames()) {
                JoinTable joinTable = OrmFactory.eINSTANCE.createJoinTable();
                manyToMany.setJoinTable(joinTable);
            }
            if (ePackageORMAnnotation.isAddOrderColumnToListMappings() && eReferenceModelGenAnnotation.isUseList() && manyToMany.getOrderBy() == null && manyToMany.getOrderColumn() == null) {
                OrderColumn orderColumn = OrmFactory.eINSTANCE.createOrderColumn();
                if (namingStrategy.isGenerateAllDBSchemaNames()) {
                    orderColumn.setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
                }
                manyToMany.setOrderColumn(orderColumn);
            }
        }
        if (namingStrategy.isGenerateAllDBSchemaNames()) {
            if (manyToMany.getJoinTable() != null) {
                if (GeneratorUtils.isEmptyOrNull((String)manyToMany.getJoinTable().getName())) {
                    manyToMany.getJoinTable().setName(namingStrategy.getJoinTableName((EStructuralFeature)eReference));
                }
                this.addColumnsToJoinTable(namingStrategy, manyToMany.getJoinTable(), annotation);
            }
            if (manyToMany.getOrderColumn() != null && GeneratorUtils.isEmptyOrNull((String)manyToMany.getOrderColumn().getName())) {
                manyToMany.getOrderColumn().setName(namingStrategy.getIndexColumnName((EStructuralFeature)eReference));
            }
        }
    }

    private void addColumnsToJoinTable(ORMNamingStrategy namingStrategy, JoinTable joinTable, EReferenceORMAnnotation annotation) {
        boolean isOwner;
        EReference eReference = annotation.getEReference();
        EReferenceModelGenAnnotation eReferenceModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
        boolean bl = isOwner = eReferenceModelGenAnnotation.isUseList() || this.isOwner(eReference);
        if (!isOwner) {
            eReference = eReference.getEOpposite();
        }
        if (joinTable.getJoinColumn().isEmpty() && namingStrategy.isGenerateAllDBSchemaNames()) {
            joinTable.getJoinColumn().add((Object)OrmFactory.eINSTANCE.createJoinColumn());
            ((JoinColumn)joinTable.getJoinColumn().get(0)).setName(namingStrategy.getJoinColumnName((EStructuralFeature)eReference));
        }
        if (joinTable.getInverseJoinColumn().isEmpty() && namingStrategy.isGenerateAllDBSchemaNames()) {
            joinTable.getInverseJoinColumn().add((Object)OrmFactory.eINSTANCE.createJoinColumn());
            ((JoinColumn)joinTable.getInverseJoinColumn().get(0)).setName(namingStrategy.getInverseJoinColumnName(eReference));
        }
        if (eReference.isUnique()) {
            UniqueConstraint uniqueConstraint = OrmFactory.eINSTANCE.createUniqueConstraint();
            for (JoinColumn joinColumn : joinTable.getJoinColumn()) {
                uniqueConstraint.getColumnName().add((Object)joinColumn.getName());
            }
            for (JoinColumn joinColumn : joinTable.getInverseJoinColumn()) {
                uniqueConstraint.getColumnName().add((Object)joinColumn.getName());
            }
        }
    }

    private boolean isOwner(EReference eReference) {
        String sideTwo;
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite == null) {
            return true;
        }
        if (!eReference.isMany() && eOpposite.isMany()) {
            return true;
        }
        if (eReference.isMany() && !eOpposite.isMany()) {
            return false;
        }
        if (eOpposite.isContainment()) {
            return false;
        }
        if (eReference.isContainment()) {
            return true;
        }
        String sideOne = String.valueOf(eReference.getEContainingClass().getEPackage().getName()) + "_" + eReference.getEContainingClass().getName() + "_" + eReference.getName();
        return sideOne.compareTo(sideTwo = String.valueOf(eOpposite.getEContainingClass().getEPackage().getName()) + "_" + eOpposite.getEContainingClass().getName() + "_" + eOpposite.getName()) > 0;
    }

    private String getMappedBy(EReference eReference) {
        EReferenceModelGenAnnotation oppositeModelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference.getEOpposite(), ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
        return oppositeModelGenAnnotation.getValidJavaMemberName();
    }

    private String getName(EReference eReference) {
        EReferenceModelGenAnnotation modelGenAnnotation = (EReferenceModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
        return modelGenAnnotation.getValidJavaMemberName();
    }

    public EClass getAnnotationEClass() {
        return OrmannotationsPackage.eINSTANCE.getEReferenceORMAnnotation();
    }
}

