/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClass;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClassifier;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsmodelFactory;
import org.eclipse.emf.texo.annotations.annotationsmodel.EClassAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EPackageAnnotation;
import org.eclipse.emf.texo.eclipse.popup.actions.BaseGenerateAction;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.generator.ModelAnnotatorRegistry;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EAttributeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EReferenceModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.orm.annotations.model.orm.AccessType;
import org.eclipse.emf.texo.orm.annotations.model.orm.Attributes;
import org.eclipse.emf.texo.orm.annotations.model.orm.Basic;
import org.eclipse.emf.texo.orm.annotations.model.orm.DocumentRoot;
import org.eclipse.emf.texo.orm.annotations.model.orm.Embeddable;
import org.eclipse.emf.texo.orm.annotations.model.orm.Entity;
import org.eclipse.emf.texo.orm.annotations.model.orm.EntityMappingsType;
import org.eclipse.emf.texo.orm.annotations.model.orm.EnumType;
import org.eclipse.emf.texo.orm.annotations.model.orm.MappedSuperclass;
import org.eclipse.emf.texo.orm.annotations.model.orm.NamedQuery;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage;
import org.eclipse.emf.texo.orm.annotations.model.orm.PersistenceUnitDefaults;
import org.eclipse.emf.texo.orm.annotations.model.orm.PersistenceUnitMetadata;
import org.eclipse.emf.texo.orm.annotations.model.orm.SupportedVersionsType;
import org.eclipse.emf.texo.orm.annotations.model.orm.Transient;
import org.eclipse.emf.texo.orm.annotator.BaseOrmAnnotation;
import org.eclipse.emf.texo.orm.annotator.ModelORMAnnotator;
import org.eclipse.emf.texo.orm.annotator.ORMJavaAnnotationGenerator;
import org.eclipse.emf.texo.orm.annotator.ORMMappingOptions;
import org.eclipse.emf.texo.orm.annotator.ORMUtils;
import org.eclipse.emf.texo.orm.ormannotations.EAttributeORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EReferenceORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EStructuralFeatureORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.OrmannotationsPackage;
import org.eclipse.emf.texo.orm.ormannotations.util.OrmannotationsResourceFactoryImpl;
import org.eclipse.emf.texo.utils.ModelUtils;

public class ORMGenerator
extends BaseGenerateAction {
    private static final ThreadLocal<Boolean> inStandardsCompliantMode = new ThreadLocal();
    private static final String ORM_FILE_NAME = "orm.xml";

    public static boolean areInStandardsCompliantMode() {
        return inStandardsCompliantMode.get() != null && inStandardsCompliantMode.get() != false;
    }

    public static void setInStandardsCompliantMode(Boolean complianceMode) {
        inStandardsCompliantMode.set(complianceMode);
    }

    public static String generateJavaAnnotations(EObject annotationOwner, List<EReference> includes, List<EReference> excludes, String identifier) {
        if (!ORMGenerator.isValidIdentifier(annotationOwner, identifier)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (EReference eReference : annotationOwner.eClass().getEAllReferences()) {
            if (includes != null && !includes.contains(eReference) || excludes != null && excludes.contains(eReference)) continue;
            Object value = annotationOwner.eGet((EStructuralFeature)eReference);
            if (value instanceof Collection) {
                sb.append(ORMGenerator.getAnnotationArray((EClass)eReference.getEType(), identifier, (Collection)value));
                continue;
            }
            if (!(value instanceof BaseOrmAnnotation)) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(((BaseOrmAnnotation)value).getJavaAnnotation(identifier));
        }
        return sb.toString();
    }

    private static String getAnnotationArray(EClass eClassifier, String identifier, Collection<?> annotations) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n@" + ORMJavaAnnotationGenerator.getInstance().getJavaPackage((EClassifier)eClassifier) + "." + eClassifier.getName() + "s({");
        boolean validContent = false;
        for (Object value : annotations) {
            if (!(value instanceof BaseOrmAnnotation)) continue;
            if (validContent) {
                sb.append(", ");
            }
            sb.append("\n");
            sb.append(((BaseOrmAnnotation)value).getJavaAnnotation(identifier));
            validContent = true;
        }
        if (!validContent) {
            return "";
        }
        sb.append("\n})");
        return sb.toString();
    }

    private static boolean isValidIdentifier(EObject annotation, String identifier) {
        if (identifier.equals("type") || identifier.equals("featureMap.type")) {
            return true;
        }
        AccessType accessType = ORMGenerator.getAccessType(annotation, new ArrayList<EObject>());
        if (accessType == null) {
            accessType = AccessType.FIELD;
        }
        if (accessType == AccessType.FIELD && (identifier.equals("featureMap.field") || identifier.equals("field"))) {
            return true;
        }
        return accessType == AccessType.PROPERTY && (identifier.equals("featureMap.getter") || identifier.equals("getter"));
    }

    private static AccessType getAccessType(EObject annotation, List<EObject> visitedObjects) {
        visitedObjects.add(annotation);
        for (EStructuralFeature eFeature : annotation.eClass().getEAllStructuralFeatures()) {
            AccessType at;
            if (eFeature.isMany()) continue;
            if (eFeature.getEType() == OrmPackage.eINSTANCE.getAccessType() && annotation.eIsSet(eFeature)) {
                return (AccessType)((Object)annotation.eGet(eFeature));
            }
            if (!(eFeature instanceof EReference) || !annotation.eIsSet(eFeature) || visitedObjects.contains(annotation.eGet(eFeature)) || (at = ORMGenerator.getAccessType((EObject)annotation.eGet(eFeature), visitedObjects)) == null) continue;
            return at;
        }
        return null;
    }

    protected void generateFromModelFiles(IProgressMonitor monitor, IProject project, List<IFile> modelFiles) {
        for (IFile modelFile : modelFiles) {
            this.generateFromModelFile(monitor, project, modelFile);
        }
    }

    protected void generateFromModelFile(IProgressMonitor monitor, IProject project, IFile modelFile) {
        ORMUtils.setORMMappingOptionsFromProjectProperties(project);
        try {
            try {
                java.net.URI uri = new java.net.URI(modelFile.getFullPath().toString());
                List ePackages = GeneratorUtils.readEPackages(Collections.singletonList(uri), (EPackage.Registry)GeneratorUtils.createEPackageRegistry(), (boolean)true);
                URI parentUri = URI.createFileURI((String)modelFile.getLocation().toString()).trimSegments(1);
                URI ormUri = parentUri.appendSegment(ORM_FILE_NAME);
                this.generateStoreORM(ePackages, ormUri);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            ORMMappingOptions.setDefaultOptions(null);
        }
    }

    public ModelController generateStoreORM(List<EPackage> ePackages, URI ormUri) {
        AnnotatedModel aModel = AnnotationsmodelFactory.eINSTANCE.createAnnotatedModel();
        ModelController modelController = new ModelController();
        modelController.setEPackages(ePackages);
        modelController.getAnnotationManager().setAnnotatedModel(aModel);
        modelController.annotate(Collections.singletonList(ModelAnnotatorRegistry.getInstance().getModelAnnotator(ModelORMAnnotator.class)));
        EntityMappingsType entityMappings = this.createEntityMappings(ePackages, aModel, modelController.getAnnotationManager());
        this.storeORM(ormUri, aModel, modelController.getAnnotationManager(), entityMappings);
        return modelController;
    }

    protected void storeORM(URI fileUri, AnnotatedModel annotatedModel, AnnotationManager annotationManager, EntityMappingsType entityMappings) {
        Resource ormResource = new OrmannotationsResourceFactoryImpl().createResource(fileUri);
        FileOutputStream fos = null;
        try {
            try {
                File file = new File(fileUri.toFileString());
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                fos = new FileOutputStream(file);
                ormResource.getContents().clear();
                DocumentRoot docRoot = OrmFactory.eINSTANCE.createDocumentRoot();
                docRoot.setEntityMappings(entityMappings);
                ormResource.getContents().add((Object)docRoot);
                ormResource.save((OutputStream)fos, Collections.emptyMap());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void setPersistenceUnitMetaData(EntityMappingsType entityMappingsType) {
        PersistenceUnitMetadata metadata = OrmFactory.eINSTANCE.createPersistenceUnitMetadata();
        PersistenceUnitDefaults defaults = OrmFactory.eINSTANCE.createPersistenceUnitDefaults();
        defaults.setDelimitedIdentifiers(OrmFactory.eINSTANCE.createEmptyType());
        metadata.setPersistenceUnitDefaults(defaults);
        entityMappingsType.setPersistenceUnitMetadata(metadata);
    }

    protected EntityMappingsType createEntityMappings(List<EPackage> ePackages, AnnotatedModel annotatedModel, AnnotationManager annotationManager) {
        EntityMappingsType entityMappings = OrmFactory.eINSTANCE.createEntityMappingsType();
        for (EPackage ePackage : ePackages) {
            EPackageORMAnnotation ePackageORMAnnotation = (EPackageORMAnnotation)annotationManager.getAnnotation((ENamedElement)ePackage, OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
            if (ePackageORMAnnotation.getEntityMappings() == null) continue;
            this.mergeManyFeatures(entityMappings, ePackageORMAnnotation.getEntityMappings());
        }
        if (ORMGenerator.areInStandardsCompliantMode()) {
            entityMappings.setVersion(SupportedVersionsType._20);
        } else {
            entityMappings.setVersion(SupportedVersionsType._23);
        }
        entityMappings.setAccess(AccessType.FIELD);
        boolean addDelimitedIdentifierTag = false;
        boolean isLibraryExample = false;
        for (EPackage ePackage : ePackages) {
            isLibraryExample |= ePackage.getName().equals("library");
            AnnotatedEPackage aPackage = annotatedModel.getAnnotatedEPackage(ePackage, false);
            for (EPackageAnnotation ePackageAnnotation : aPackage.getEPackageAnnotations()) {
                if (!(ePackageAnnotation instanceof EPackageORMAnnotation)) continue;
                EPackageORMAnnotation ormAnnotation = (EPackageORMAnnotation)ePackageAnnotation;
                addDelimitedIdentifierTag |= ormAnnotation.isSetDelimitedIdentifierTagInORM();
            }
            for (AnnotatedEClassifier aClassifier : aPackage.getAnnotatedEClassifiers()) {
                if (!(aClassifier instanceof AnnotatedEClass)) continue;
                AnnotatedEClass aClass = (AnnotatedEClass)aClassifier;
                for (EClassAnnotation eClassAnnotation : aClass.getEClassAnnotations()) {
                    EClassORMAnnotation eClassORMAnnotation;
                    if (!(eClassAnnotation instanceof EClassORMAnnotation) || (eClassORMAnnotation = (EClassORMAnnotation)eClassAnnotation).getTransient() != null || aClass.getEClass().isInterface() || GenUtils.isDocumentRoot((EClass)aClass.getEClass()) || ModelUtils.isEMap((EClass)aClass.getEClass())) continue;
                    if (eClassORMAnnotation.getMappedSuperclass() != null) {
                        eClassORMAnnotation.getMappedSuperclass().setAttributes(this.collectAttributes(entityMappings, annotationManager, aClass.getEClass()));
                        entityMappings.getMappedSuperclass().add((Object)((MappedSuperclass)EcoreUtil.copy((EObject)eClassORMAnnotation.getMappedSuperclass())));
                        continue;
                    }
                    if (eClassORMAnnotation.getEmbeddable() != null) {
                        eClassORMAnnotation.getEmbeddable().setAttributes(this.collectAttributes(entityMappings, annotationManager, aClass.getEClass()));
                        entityMappings.getEmbeddable().add((Object)((Embeddable)EcoreUtil.copy((EObject)eClassORMAnnotation.getEmbeddable())));
                        continue;
                    }
                    if (eClassORMAnnotation.getEntity() == null) continue;
                    eClassORMAnnotation.getEntity().setAttributes(this.collectAttributes(entityMappings, annotationManager, aClass.getEClass()));
                    entityMappings.getEntity().add((Object)((Entity)EcoreUtil.copy((EObject)eClassORMAnnotation.getEntity())));
                }
            }
        }
        if (addDelimitedIdentifierTag) {
            this.setPersistenceUnitMetaData(entityMappings);
        }
        if (isLibraryExample && ORMMappingOptions.getDefaultOptions().isTestRun()) {
            this.addNamedQuery(entityMappings);
        }
        return entityMappings;
    }

    private void addNamedQuery(EntityMappingsType entityMappingsType) {
        NamedQuery namedQuery = OrmFactory.eINSTANCE.createNamedQuery();
        namedQuery.setName("testWriter");
        namedQuery.setQuery("select e, e.name from library_Writer e where e.name like :name");
        entityMappingsType.getNamedQuery().add((Object)namedQuery);
    }

    private Attributes collectAttributes(EntityMappingsType entityMappings, AnnotationManager annotationManager, EClass eClass) {
        Attributes attributes = OrmFactory.eINSTANCE.createAttributes();
        this.collectAttributes(entityMappings, annotationManager, eClass, attributes);
        return attributes;
    }

    private void collectAttributes(EntityMappingsType entityMappings, AnnotationManager annotationManager, EClass eClass, Attributes attributes) {
        for (EClass eSuperType : eClass.getESuperTypes()) {
            if (!eSuperType.isInterface()) continue;
            this.collectAttributes(entityMappings, annotationManager, eSuperType, attributes);
        }
        this.collectAttributes(entityMappings, annotationManager, (List<EReference>)eClass.getEReferences(), (List<EAttribute>)eClass.getEAttributes(), false, attributes);
    }

    private void collectAttributes(EntityMappingsType entityMappings, AnnotationManager annotationManager, List<EReference> eReferences, List<EAttribute> eAttributes, boolean mapFeatureMapFeatures, Attributes attributes) {
        Transient trsnt;
        EAttributeModelGenAnnotation genAnnotation;
        EStructuralFeatureORMAnnotation ormAnnotation;
        for (EAttribute eAttribute : eAttributes) {
            if (!mapFeatureMapFeatures && eAttribute.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
                this.mapFeatureMap(entityMappings, annotationManager, eAttribute);
            }
            ormAnnotation = (EAttributeORMAnnotation)annotationManager.getAnnotation((ENamedElement)eAttribute, OrmannotationsPackage.eINSTANCE.getEAttributeORMAnnotation());
            genAnnotation = (EAttributeModelGenAnnotation)annotationManager.getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
            if (!mapFeatureMapFeatures && genAnnotation.getFeatureMapFeature() != null) {
                trsnt = OrmFactory.eINSTANCE.createTransient();
                trsnt.setName(genAnnotation.getValidJavaMemberName());
                attributes.getTransient().add((Object)trsnt);
                continue;
            }
            this.copyFeatures(ormAnnotation, attributes);
        }
        for (EReference eReference : eReferences) {
            if (!mapFeatureMapFeatures && eReference.isVolatile()) continue;
            ormAnnotation = (EReferenceORMAnnotation)annotationManager.getAnnotation((ENamedElement)eReference, OrmannotationsPackage.eINSTANCE.getEReferenceORMAnnotation());
            genAnnotation = (EReferenceModelGenAnnotation)annotationManager.getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
            if (!mapFeatureMapFeatures && genAnnotation.getFeatureMapFeature() != null) {
                trsnt = OrmFactory.eINSTANCE.createTransient();
                trsnt.setName(genAnnotation.getValidJavaMemberName());
                attributes.getTransient().add((Object)trsnt);
                continue;
            }
            this.copyFeatures(ormAnnotation, attributes);
        }
    }

    private void copyFeatures(EObject sourceEObject, EObject targetEObject) {
        for (EReference eSourceReference : sourceEObject.eClass().getEAllReferences()) {
            Object value;
            EReference targetFeature;
            if (!eSourceReference.isContainment() || !sourceEObject.eIsSet((EStructuralFeature)eSourceReference) || (targetFeature = this.getTargetFeature(eSourceReference)) == null) continue;
            if (targetFeature.isMany()) {
                Collection targetCollection;
                if (eSourceReference.isMany()) {
                    Collection values = (Collection)sourceEObject.eGet((EStructuralFeature)eSourceReference);
                    targetCollection = (Collection)targetEObject.eGet((EStructuralFeature)targetFeature);
                    targetCollection.addAll(EcoreUtil.copyAll((Collection)values));
                    continue;
                }
                value = sourceEObject.eGet((EStructuralFeature)eSourceReference);
                targetCollection = (Collection)targetEObject.eGet((EStructuralFeature)targetFeature);
                targetCollection.add(EcoreUtil.copy((EObject)((EObject)value)));
                continue;
            }
            value = sourceEObject.eGet((EStructuralFeature)eSourceReference);
            targetEObject.eSet((EStructuralFeature)targetFeature, (Object)EcoreUtil.copy((EObject)((EObject)value)));
        }
    }

    private EReference getTargetFeature(EReference sourceFeature) {
        for (EReference eTargetFeature : OrmPackage.eINSTANCE.getAttributes().getEAllReferences()) {
            if (eTargetFeature.getEReferenceType() != sourceFeature.getEReferenceType()) continue;
            return eTargetFeature;
        }
        return null;
    }

    private void mapFeatureMap(EntityMappingsType entityMappings, AnnotationManager annotationManager, EAttribute eAttribute) {
        EAttributeModelGenAnnotation genAnnotation = (EAttributeModelGenAnnotation)annotationManager.getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
        EAttributeORMAnnotation ormAnnotation = (EAttributeORMAnnotation)annotationManager.getAnnotation((ENamedElement)eAttribute, OrmannotationsPackage.eINSTANCE.getEAttributeORMAnnotation());
        List modelGenFeatures = genAnnotation.getAllMemberFeatureMapFeatures();
        ArrayList<EAttribute> eAttributes = new ArrayList<EAttribute>();
        ArrayList<EReference> eReferences = new ArrayList<EReference>();
        for (EStructuralFeatureModelGenAnnotation modelGenFeature : modelGenFeatures) {
            if (modelGenFeature.getFeatureMapFeature() != null && modelGenFeature.getFeatureMapFeature().getEStructuralFeature() != eAttribute) continue;
            if (modelGenFeature.getEStructuralFeature() instanceof EAttribute) {
                eAttributes.add((EAttribute)modelGenFeature.getEStructuralFeature());
                continue;
            }
            eReferences.add((EReference)modelGenFeature.getEStructuralFeature());
        }
        Entity entity = ormAnnotation.getFeatureMapEntity();
        Attributes attributes = OrmFactory.eINSTANCE.createAttributes();
        this.collectAttributes(entityMappings, annotationManager, eReferences, eAttributes, true, attributes);
        if (ModelUtils.isMixed((EStructuralFeature)eAttribute)) {
            attributes.getBasic().add((Object)this.createBasic("text"));
            attributes.getBasic().add((Object)this.createBasic("cDATA"));
            attributes.getBasic().add((Object)this.createBasic("comment"));
        }
        Basic featureBasic = OrmFactory.eINSTANCE.createBasic();
        featureBasic.setEnumerated(EnumType.STRING);
        featureBasic.setName("feature");
        featureBasic.setOptional(false);
        attributes.getBasic().add((Object)featureBasic);
        entity.setAttributes(attributes);
        entityMappings.getEntity().add((Object)((Entity)EcoreUtil.copy((EObject)entity)));
    }

    private Basic createBasic(String name) {
        Basic basic = OrmFactory.eINSTANCE.createBasic();
        basic.setLob(OrmFactory.eINSTANCE.createLob());
        basic.setName(name);
        basic.setOptional(true);
        return basic;
    }

    private void mergeManyFeatures(EObject o1, EObject o2) {
        for (EStructuralFeature eFeature : o1.eClass().getEAllStructuralFeatures()) {
            List o2Values;
            List o1Values;
            if (!eFeature.isMany()) continue;
            if (eFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eFeature;
                o1Values = (List)o1.eGet((EStructuralFeature)eAttribute);
                o2Values = (List)o2.eGet((EStructuralFeature)eAttribute);
                o1Values.addAll(o2Values);
                continue;
            }
            EReference eReference = (EReference)eFeature;
            o1Values = (List)o1.eGet((EStructuralFeature)eReference);
            o2Values = (List)o2.eGet((EStructuralFeature)eReference);
            for (EObject o2Value : o2Values) {
                o1Values.add(EcoreUtil.copy((EObject)o2Value));
            }
        }
    }
}

