/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.orm.annotations.model.orm.DocumentRoot;
import org.eclipse.emf.texo.orm.annotations.model.orm.EntityMappingsType;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotations.model.orm.SupportedVersionsType;
import org.eclipse.emf.texo.orm.annotator.ORMGenerator;
import org.eclipse.emf.texo.orm.ormannotations.util.OrmannotationsResourceFactoryImpl;
import org.eclipse.emf.texo.orm.ormannotations.util.OrmannotationsResourceImpl;

public class StandardORMGenerator
extends ORMGenerator {
    private static final String STANDARD_ORM_NS = "http://java.sun.com/xml/ns/persistence/orm";
    private static final String ECLIPSELINK_ORM_NS = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static final List<String> eclipseLinkSpecificFeatureNames = new ArrayList<String>();

    static {
        eclipseLinkSpecificFeatureNames.add("creationSuffix");
    }

    @Override
    public ModelController generateStoreORM(List<EPackage> ePackages, URI ormUri) {
        try {
            ORMGenerator.setInStandardsCompliantMode(true);
            ModelController modelController = super.generateStoreORM(ePackages, ormUri);
            return modelController;
        }
        finally {
            ORMGenerator.setInStandardsCompliantMode(null);
        }
    }

    @Override
    protected void storeORM(URI fileUri, AnnotatedModel annotatedModel, AnnotationManager annotationManager, EntityMappingsType entityMappings) {
        if (ORMGenerator.areInStandardsCompliantMode()) {
            entityMappings.setVersion(SupportedVersionsType._20);
        } else {
            entityMappings.setVersion(SupportedVersionsType._23);
        }
        this.unsetEclipseLinkFeatures(entityMappings);
        OrmannotationsResourceImpl ormResource = (OrmannotationsResourceImpl)new OrmannotationsResourceFactoryImpl().createResource(fileUri);
        try {
            String fileUriStr = fileUri.toFileString();
            File file = new File(fileUriStr);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            DocumentRoot docRoot = OrmFactory.eINSTANCE.createDocumentRoot();
            docRoot.setEntityMappings(entityMappings);
            ormResource.getContents().add((Object)docRoot);
            StringWriter sw = new StringWriter();
            ormResource.save(sw, Collections.emptyMap());
            FileWriter fw = new FileWriter(file);
            String result = sw.toString();
            while (result.contains(ECLIPSELINK_ORM_NS)) {
                result = result.replace(ECLIPSELINK_ORM_NS, STANDARD_ORM_NS);
            }
            fw.write(result);
            fw.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void unsetEclipseLinkFeatures(EObject eObject) {
        if (eObject == null) {
            return;
        }
        for (EStructuralFeature eFeature : eObject.eClass().getEAllStructuralFeatures()) {
            Collection coll;
            Object value = eObject.eGet(eFeature);
            if (eFeature instanceof EReference) {
                EReference eReference = (EReference)eFeature;
                if (eReference.isContainment()) {
                    if (value instanceof Collection) {
                        coll = (Collection)value;
                        for (Object o : coll) {
                            this.unsetEclipseLinkFeatures((EObject)o);
                        }
                    } else {
                        this.unsetEclipseLinkFeatures((EObject)value);
                    }
                }
                if (!eclipseLinkSpecificFeatureNames.contains(eReference.getName())) continue;
                if (value instanceof Collection) {
                    coll = (Collection)value;
                    coll.clear();
                } else {
                    eObject.eSet((EStructuralFeature)eReference, null);
                }
                eObject.eUnset((EStructuralFeature)eReference);
                continue;
            }
            EAttribute eAttribute = (EAttribute)eFeature;
            if (!eclipseLinkSpecificFeatureNames.contains(eAttribute.getName())) continue;
            if (value instanceof Collection) {
                coll = (Collection)eObject.eGet((EStructuralFeature)eAttribute);
                coll.clear();
            } else {
                eObject.eSet((EStructuralFeature)eAttribute, null);
            }
            eObject.eUnset((EStructuralFeature)eAttribute);
        }
    }
}

