/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.server.model.request.QueryType;
import org.eclipse.emf.texo.server.model.response.ResponseModelPackage;
import org.eclipse.emf.texo.server.model.response.ResponseType;
import org.eclipse.emf.texo.server.service.ModelOperation;
import org.eclipse.emf.texo.server.service.QueryBuilder;
import org.eclipse.emf.texo.server.service.ServiceUtils;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

public class RetrieveModelOperation
extends ModelOperation {
    private static final String FALSE = Boolean.FALSE.toString();

    @Override
    protected void internalExecute() {
        String[] segments = ServiceUtils.getSegments(this.getServiceContext().getServiceRequestURI());
        QueryType queryType = this.getQueryType();
        if (queryType != null) {
            long cnt;
            int startRow;
            int maxResults = queryType.getMaxResults();
            int n = startRow = queryType.getFirstResult() == -1 ? 0 : queryType.getFirstResult();
            if (!queryType.isDoCount() && maxResults != -1 && maxResults != Integer.MAX_VALUE) {
                ++maxResults;
            }
            Map<String, Object> parameters = this.getParameters(queryType);
            List resultList = queryType.getNamedQuery() != null ? this.getObjectStore().namedQuery(queryType.getNamedQuery(), parameters, startRow, maxResults) : this.getObjectStore().query(queryType.getQuery(), parameters, startRow, maxResults);
            if (resultList.size() < maxResults) {
                cnt = resultList.size() + startRow;
            } else if (maxResults == -1 || maxResults == Integer.MAX_VALUE) {
                cnt = resultList.size() + startRow;
            } else if (queryType.isDoCount()) {
                cnt = queryType.getNamedQuery() != null ? this.getObjectStore().countNamedQuery(queryType.getNamedQuery(), parameters) : this.getObjectStore().count(queryType.getQuery(), parameters);
            } else {
                cnt = maxResults;
                resultList.remove(resultList.size() - 1);
            }
            ResponseType responseObject = queryType.isCountOperation() ? this.getResponse(Collections.emptyList(), 0, 0, (Long)resultList.get(0)) : this.getResponse(resultList, startRow, startRow + resultList.size() - 1, cnt);
            this.getServiceContext().setResultInResponse(responseObject);
        } else if (segments.length < 2 && this.getServiceContext().getRequestParameters().containsKey("id")) {
            URI uri = URI.createURI((String)((String)this.getServiceContext().getRequestParameters().get("id")));
            Object object = this.getObjectStore().fromUri(uri);
            this.getServiceContext().setResultInResponse(object);
        } else {
            if (segments.length == 0) {
                throw new IllegalArgumentException("Service path " + this.getServiceContext().getServiceRequestURI() + " not supported, uri " + this.getServiceContext().getRequestURI());
            }
            if (segments.length == 1) {
                long cnt;
                boolean doCount;
                EClass eClass = ModelUtils.getEClassFromQualifiedName((String)segments[0]);
                QueryBuilder queryBuilder = QueryBuilder.getQueryBuilder(this.getObjectStore().getEntityName(eClass), eClass, this.getServiceContext().getRequestParameters());
                List resultList = this.getObjectStore().query(queryBuilder.getSelectQuery(), Collections.emptyMap(), this.getFirstResult(), this.getMaxResults());
                int maxResults = this.getMaxResults();
                int startRow = this.getFirstResult() == -1 ? 0 : this.getFirstResult();
                String noCountParam = (String)this.getServiceContext().getRequestParameters().get("noCount");
                boolean bl = doCount = maxResults != -1 && (noCountParam == null || FALSE.equals(noCountParam));
                if (!doCount && maxResults != -1) {
                    ++maxResults;
                }
                if (resultList.size() < maxResults) {
                    cnt = resultList.size() + startRow;
                } else if (maxResults == -1) {
                    cnt = resultList.size() + startRow;
                } else if (doCount) {
                    cnt = this.getObjectStore().count(queryBuilder.getCountQuery(), Collections.emptyMap());
                } else {
                    cnt = maxResults;
                    resultList.remove(resultList.size() - 1);
                }
                ResponseType responseObject = this.getResponse(resultList, startRow, startRow + resultList.size() - 1, cnt);
                this.getServiceContext().setResultInResponse(responseObject);
            } else if (segments.length == 2) {
                if ("model".equals(segments[0])) {
                    EObject modelElement = this.retrieveModelInformation(segments[1]);
                    this.getServiceContext().setResultInResponse(modelElement);
                } else {
                    String idString = segments[1];
                    EClass eClass = ModelUtils.getEClassFromQualifiedName((String)segments[0]);
                    Object id = IdProvider.getInstance().convertIdStringToId(eClass, idString);
                    Object object = this.getObjectStore().get(eClass, id);
                    if (object == null) {
                        this.getServiceContext().createResourceNotFoundResult();
                    } else {
                        this.getServiceContext().setResultInResponse(object);
                    }
                }
            } else {
                throw new IllegalArgumentException("Service path " + this.getServiceContext().getServiceRequestURI() + " not supported, uri " + this.getServiceContext().getRequestURI());
            }
        }
    }

    protected EObject retrieveModelInformation(String modelType) {
        if ("eclass".equals(modelType) || "eclassifier".equals(modelType)) {
            boolean isRetrieveEClass = "eclass".equals(modelType);
            String ePackageidentifier = (String)this.getServiceContext().getRequestParameters().get("epackage");
            String name = (String)this.getServiceContext().getRequestParameters().get("name");
            String id = (String)this.getServiceContext().getRequestParameters().get("id");
            if (id != null) {
                return ModelUtils.getEClassFromQualifiedName((String)id);
            }
            Check.isNotNull((Object)name, (String)"name parameter should be set when retrieving an eclass(ifier)");
            Check.isNotNull((Object)ePackageidentifier, (String)"epackage parameter should be set when retrieving an eclass(ifier)");
            EPackage ePackage = ModelUtils.getEPackageFromNameUriOrPrefix((String)ePackageidentifier);
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!name.equals(eClassifier.getName())) continue;
                if (isRetrieveEClass) {
                    EClass eClass = (EClass)eClassifier;
                    return eClass;
                }
                return eClassifier;
            }
        }
        Check.isTrue((boolean)"epackage".equals(modelType), (String)("Excepted uri segment of eclass, eclassifier or epackage but found " + modelType));
        String id = (String)this.getServiceContext().getRequestParameters().get("id");
        Check.isNotNull((Object)id, (String)"id parameter should be set when retrieving an epackage");
        return ModelUtils.getEPackageFromNameUriOrPrefix((String)id);
    }

    protected ResponseType getResponse(List<Object> objects, int startRow, int endRow, long totalRows) {
        ResponseType responseType = ResponseModelPackage.INSTANCE.getModelFactory().createResponseType();
        responseType.setEndRow(endRow);
        responseType.setStartRow(startRow);
        responseType.setTotalRows(totalRows);
        responseType.setStatus("success");
        responseType.setData(objects);
        return responseType;
    }

    private boolean doCount(QueryType queryType, int maxResults, int firstResult) {
        if (this.getMaxResults() == -1 && this.getFirstResult() == -1) {
            return false;
        }
        String noCountParam = (String)this.getServiceContext().getRequestParameters().get("noCount");
        return noCountParam == null || FALSE.equals(noCountParam);
    }
}

