/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.server.model.request.ActionType;
import org.eclipse.emf.texo.server.model.request.QueryReferingObjectsType;
import org.eclipse.emf.texo.server.model.request.QueryType;
import org.eclipse.emf.texo.server.model.response.ResponseModelPackage;
import org.eclipse.emf.texo.server.model.response.ResponseType;
import org.eclipse.emf.texo.server.model.response.ResultType;
import org.eclipse.emf.texo.server.service.ModelOperation;
import org.eclipse.emf.texo.server.service.RetrieveModelOperation;
import org.eclipse.emf.texo.store.ObjectStore;

public class UpdateInsertModelOperation
extends ModelOperation {
    @Override
    protected void internalExecute() {
        Object o;
        List<Object> allConvertedObjects = this.getServiceContext().getRequestData();
        ObjectStore localObjectStore = this.getObjectStore();
        ResultType result = ResponseModelPackage.INSTANCE.getModelFactory().createResultType();
        Iterator<Object> it = allConvertedObjects.iterator();
        while (it.hasNext()) {
            Object updated;
            o = it.next();
            if (o instanceof QueryReferingObjectsType) {
                QueryReferingObjectsType qrt = (QueryReferingObjectsType)o;
                Object target = localObjectStore.fromUri(URI.createURI((String)qrt.getTargetUri()));
                List referers = localObjectStore.getReferingObjects(target, qrt.getMaxResults(), qrt.getIncludeContainerReferences().booleanValue());
                ResponseType responseType = ResponseModelPackage.INSTANCE.getModelFactory().createResponseType();
                responseType.setStatus("success");
                responseType.setData(referers);
                this.getServiceContext().setResultInResponse(responseType);
                return;
            }
            if (o instanceof QueryType) {
                RetrieveModelOperation retrieveModelOperation = (RetrieveModelOperation)ComponentProvider.getInstance().newInstance(RetrieveModelOperation.class);
                retrieveModelOperation.setServiceContext(this.getServiceContext());
                retrieveModelOperation.internalExecute();
                return;
            }
            if (!(o instanceof ActionType)) continue;
            ActionType actionType = (ActionType)o;
            for (Object object : actionType.getDelete()) {
                localObjectStore.remove(object);
                result.getDeleted().add(object);
            }
            for (Object object : actionType.getInsert()) {
                if (localObjectStore.isNew(object)) {
                    localObjectStore.insert(object);
                    result.getInserted().add(object);
                    continue;
                }
                updated = localObjectStore.update(object);
                result.getInserted().add(updated);
            }
            for (Object object : actionType.getUpdate()) {
                if (localObjectStore.isNew(object)) {
                    localObjectStore.insert(object);
                    result.getInserted().add(object);
                    continue;
                }
                updated = localObjectStore.update(object);
                result.getUpdated().add(updated);
            }
            it.remove();
            localObjectStore.flush();
        }
        it = allConvertedObjects.iterator();
        while (it.hasNext()) {
            o = it.next();
            if (!localObjectStore.isNew(o)) continue;
            localObjectStore.insert(o);
            result.getInserted().add(o);
            it.remove();
        }
        localObjectStore.flush();
        for (Object o2 : allConvertedObjects) {
            Object updated = localObjectStore.update(o2);
            result.getUpdated().add(updated);
        }
        localObjectStore.flush();
        this.getServiceContext().setResultInResponse(result);
    }
}

