/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.server.store.DaoRegistry;
import org.eclipse.emf.texo.server.store.EntityManagerProvider;
import org.eclipse.emf.texo.utils.ModelUtils;

public abstract class BaseDao<T>
implements TexoComponent {
    @PersistenceContext
    private EntityManager entityManager;
    private String entityName;

    public abstract Class<T> getEntityClass();

    public abstract EClass getEClass();

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = EntityManagerProvider.getInstance().getEntityManager();
        }
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public T get(Object id) {
        if (id == null) {
            return null;
        }
        return (T)this.getEntityManager().find(this.getEntityClass(), id);
    }

    public List<T> getAll() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getEntityClass());
        Root root = criteria.from(this.getEntityClass());
        criteria.select((Selection)root);
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    public int countAll() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(this.getEntityClass());
        criteria.select((Selection)builder.count((Expression)root));
        return ((Long)this.getEntityManager().createQuery(criteria).getSingleResult()).intValue();
    }

    public List<T> findBy(String property, Object value) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getEntityClass());
        Root root = criteria.from(this.getEntityClass());
        criteria.select((Selection)root);
        criteria.where((Expression)builder.equal((Expression)root.get(property), value));
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    public List<T> findBy(EStructuralFeature eFeature, Object value) {
        return this.findBy(this.getJavaPropertyName(eFeature), value);
    }

    public List<T> findByProperties(Map<String, Object> filterBy) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getEntityClass());
        Root root = criteria.from(this.getEntityClass());
        criteria.select((Selection)root);
        Predicate rootExpression = null;
        for (String property : filterBy.keySet()) {
            Object value = filterBy.get(property);
            rootExpression = rootExpression == null ? builder.equal((Expression)root.get(property), value) : builder.and((Expression)rootExpression, (Expression)builder.equal((Expression)root.get(property), value));
        }
        criteria.where(rootExpression);
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    public List<T> findByFeatures(Map<EStructuralFeature, Object> filterBy) {
        HashMap<String, Object> filterByProp = new HashMap<String, Object>();
        for (EStructuralFeature eFeature : filterBy.keySet()) {
            String prop = this.getJavaPropertyName(eFeature);
            filterByProp.put(prop, filterBy.get(eFeature));
        }
        return this.findByProperties(filterByProp);
    }

    public void refresh(T t) {
        this.getEntityManager().refresh(t);
    }

    public void remove(T t) {
        this.deleteCascade(new ArrayList<Object>(), t);
    }

    public void remove(List<T> ts) {
        for (T t : ts) {
            this.remove(t);
        }
    }

    public T update(T t) {
        return (T)this.getEntityManager().merge(t);
    }

    public void insert(T t) {
        this.getEntityManager().persist(t);
    }

    public boolean isReferenced(T t, boolean includeContainerReferences) {
        EClass localEClass = this.getEClass();
        List eRefs = ModelResolver.getInstance().getReferingEReferences(localEClass, includeContainerReferences);
        for (EReference eReference : eRefs) {
            if (eReference.isContainment() && !includeContainerReferences) continue;
            EClass referencingEClass = eReference.getEContainingClass();
            Class referencingClass = ModelResolver.getInstance().getImplementationClass((EClassifier)referencingEClass);
            BaseDao referencingDao = DaoRegistry.getInstance().getDaoForEntity(referencingClass);
            String refEntityName = referencingDao.getEntityName();
            String propertyName = referencingDao.getJavaPropertyName((EStructuralFeature)eReference);
            String qryStr = eReference.isMany() ? "select count(e) from " + refEntityName + " e where :target member of e." + propertyName : "select count(e) from " + refEntityName + " e where e." + propertyName + "=:target";
            Query qry = this.getEntityManager().createQuery(qryStr);
            qry.setParameter("target", t);
            Number result = (Number)qry.getSingleResult();
            if (result.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<Object> getReferingObjects(T t, int maxResult, boolean includeContainerReferences) {
        EClass localEClass = this.getEClass();
        List eRefs = ModelResolver.getInstance().getReferingEReferences(localEClass, includeContainerReferences);
        ArrayList<Object> result = new ArrayList<Object>();
        for (EReference eReference : eRefs) {
            if (eReference.isContainer() && !includeContainerReferences) continue;
            EClass referencingEClass = eReference.getEContainingClass();
            Class referencingClass = ModelResolver.getInstance().getImplementationClass((EClassifier)referencingEClass);
            BaseDao referencingDao = DaoRegistry.getInstance().getDaoForEntity(referencingClass);
            referencingDao.setEntityManager(this.getEntityManager());
            String refEntityName = referencingDao.getEntityName();
            String propertyName = referencingDao.getJavaPropertyName((EStructuralFeature)eReference);
            String qryStr = eReference.isMany() ? "select e from " + refEntityName + " e where :target member of e." + propertyName : "select e from " + refEntityName + " e where e." + propertyName + "=:target";
            Query qry = this.getEntityManager().createQuery(qryStr);
            qry.setParameter("target", t);
            if (maxResult > 0) {
                qry.setMaxResults(maxResult);
            }
            List resultList = qry.getResultList();
            result.removeAll(resultList);
            result.addAll(resultList);
            if (maxResult <= 0 || result.size() < maxResult) continue;
            if (result.size() > maxResult) {
                return result.subList(0, maxResult);
            }
            return result;
        }
        return result;
    }

    public String getEntityName() {
        if (this.entityName == null) {
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            EntityType entityType = metaModel.entity(this.getEntityClass());
            this.entityName = entityType.getName();
        }
        return this.entityName;
    }

    protected String getJavaPropertyName(EStructuralFeature eFeature) {
        String propertyName = ModelUtils.getEAnnotation((EModelElement)eFeature, (String)"java.member");
        if (propertyName == null) {
            return eFeature.getName();
        }
        return propertyName;
    }

    protected void deleteCascade(List<Object> deleteSet, Object object) {
        if (deleteSet.contains(object)) {
            return;
        }
        deleteSet.add(object);
        ModelObject modelObject = ModelResolver.getInstance().getModelObject(object);
        for (EReference eReference : modelObject.eClass().getEAllReferences()) {
            Object value;
            if (!eReference.isContainment() || eReference.isMany() || (value = modelObject.eGet((EStructuralFeature)eReference)) == null) continue;
            modelObject.eSet((EStructuralFeature)eReference, null);
            BaseDao<?> dao = DaoRegistry.getInstance().getDaoForEntity(value.getClass());
            dao.setEntityManager(this.getEntityManager());
            dao.deleteCascade(deleteSet, value);
        }
        this.getEntityManager().remove(object);
    }
}

