/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.server.store.EntityManagerObjectStore;
import org.eclipse.emf.texo.store.EMFResourceObjectStore;
import org.eclipse.emf.texo.store.MemoryObjectStore;
import org.eclipse.emf.texo.store.ObjectStore;

public class ObjectStoreFactory
implements TexoComponent {
    private static ObjectStoreFactory instance = null;

    public static ObjectStoreFactory getInstance() {
        if (instance == null) {
            instance = (ObjectStoreFactory)ComponentProvider.getInstance().newInstance(ObjectStoreFactory.class);
        }
        return instance;
    }

    public static void setInstance(ObjectStoreFactory objectStoreFactory) {
        instance = objectStoreFactory;
    }

    public ObjectStore createObjectStore(HttpServletRequest request, String objectStoreUri) {
        ObjectStore objectStore = this.createObjectStoreLocal(request, objectStoreUri);
        objectStore.setUri(objectStoreUri);
        return objectStore;
    }

    protected ObjectStore createObjectStoreLocal(HttpServletRequest request, String objectStoreUri) {
        return this.createEntityManagerObjectStore();
    }

    protected ObjectStore createEMFResourceObjectStore() {
        return (ObjectStore)ComponentProvider.getInstance().newInstance(EMFResourceObjectStore.class);
    }

    protected ObjectStore createMemoryObjectStore() {
        return (ObjectStore)ComponentProvider.getInstance().newInstance(MemoryObjectStore.class);
    }

    protected ObjectStore createEntityManagerObjectStore() {
        return (ObjectStore)ComponentProvider.getInstance().newInstance(EntityManagerObjectStore.class);
    }
}

