package org.eclipse.emf.texo.xml.model.texoextensions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.model.ModelFactory;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

/**
 * The <b>Package</b> for the model '<em><b>texoExtensions</b></em>'.
 * It contains initialization code and access to the Factory to instantiate types of this package.
 * 
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class TexoExtensionsModelPackage extends ModelPackage {

  /**
   * Is set when the package has been initialized.
   * @generated
   */
  private static boolean isInitialized = false;

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final String NS_URI = "http://www.eclipse.org/emf/texo/xml/model/texo_extensions";

  /**
   * The {@link ModelFactory} for this package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final TexoExtensionsModelFactory MODELFACTORY = new TexoExtensionsModelFactory();

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_CLASSIFIER_ID = 0;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_MIXED_FEATURE_ID = 0;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_XMLNSPREFIXMAP_FEATURE_ID = 1;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_XSISCHEMALOCATION_FEATURE_ID = 2;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_ID_FEATURE_ID = 3;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_TITLE_FEATURE_ID = 4;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final int DOCUMENTROOT_TYPE_FEATURE_ID = 5;

  /**
   * The static member with the instance of this {@link ModelPackage}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final TexoExtensionsModelPackage INSTANCE = initialize();

  /**
   * Initializes this {@link ModelPackage}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static TexoExtensionsModelPackage initialize() {

    if (isInitialized) {
      return (TexoExtensionsModelPackage) ModelResolver.getInstance().getModelPackage(NS_URI);
    }

    final TexoExtensionsModelPackage modelPackage = new TexoExtensionsModelPackage();

    ModelResolver.getInstance().registerModelPackage(modelPackage);

    isInitialized = true;

    // read the model from the ecore file, the EPackage is registered in the EPackage.Registry
    // see the ModelResolver getEPackageRegistry method
    ModelUtils.readEPackagesFromFile(modelPackage);

    // register the relation between a Class and its EClassifier
    ModelResolver.getInstance().registerClassModelMapping(DocumentRoot.class, modelPackage.getDocumentRootEClass(),
        modelPackage);

    // and return ourselves
    return modelPackage;
  }

  /**
   * Returns the {@link ModelFactory} of this ModelPackage.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @return the {@link TexoExtensionsModelFactory} instance.
   * @generated
   */
  @Override
  public TexoExtensionsModelFactory getModelFactory() {
    return MODELFACTORY;
  }

  /** 
   * Returns the nsUri of the {@link EPackage} managed by this Package instance.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @return the nsUri of the EPackage 
   * @generated
   */
  @Override
  public String getNsURI() {
    return NS_URI;
  }

  /** 
   * Returns the name of the ecore file containing the ecore model of the {@link EPackage} managed here.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @return the name of the ecore file 
   * @generated
   */
  @Override
  public String getEcoreFileName() {
    return "texoExtensions.ecore";
  }

  /**
   * Returns the {@link EClass} '<em><b>DocumentRoot</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EClass} '<em><b>DocumentRoot</b></em>' 
   * @generated
   */
  public EClass getDocumentRootEClass() {
    return (EClass) getEPackage().getEClassifiers().get(DOCUMENTROOT_CLASSIFIER_ID);
  }

  /**
   * Returns the {@link EStructuralFeature} '<em><b>DocumentRoot.mixed</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EStructuralFeature}: '<em><b>DocumentRoot.mixed</b></em>'.
   * @generated
   */
  public EAttribute getDocumentRoot_Mixed() {
    return (EAttribute) getDocumentRootEClass().getEAllStructuralFeatures().get(DOCUMENTROOT_MIXED_FEATURE_ID);
  }

  /**
   * Returns the {@link EStructuralFeature} '<em><b>DocumentRoot.xMLNSPrefixMap</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EStructuralFeature}: '<em><b>DocumentRoot.xMLNSPrefixMap</b></em>'.
   * @generated
   */
  public EReference getDocumentRoot_XMLNSPrefixMap() {
    return (EReference) getDocumentRootEClass().getEAllStructuralFeatures().get(DOCUMENTROOT_XMLNSPREFIXMAP_FEATURE_ID);
  }

  /**
   * Returns the {@link EStructuralFeature} '<em><b>DocumentRoot.xSISchemaLocation</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EStructuralFeature}: '<em><b>DocumentRoot.xSISchemaLocation</b></em>'.
   * @generated
   */
  public EReference getDocumentRoot_XSISchemaLocation() {
    return (EReference) getDocumentRootEClass().getEAllStructuralFeatures().get(
        DOCUMENTROOT_XSISCHEMALOCATION_FEATURE_ID);
  }

  /**
   * Returns the {@link EStructuralFeature} '<em><b>DocumentRoot.id</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EStructuralFeature}: '<em><b>DocumentRoot.id</b></em>'.
   * @generated
   */
  public EAttribute getDocumentRoot_Id() {
    return (EAttribute) getDocumentRootEClass().getEAllStructuralFeatures().get(DOCUMENTROOT_ID_FEATURE_ID);
  }

  /**
   * Returns the {@link EStructuralFeature} '<em><b>DocumentRoot.title</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EStructuralFeature}: '<em><b>DocumentRoot.title</b></em>'.
   * @generated
   */
  public EAttribute getDocumentRoot_Title() {
    return (EAttribute) getDocumentRootEClass().getEAllStructuralFeatures().get(DOCUMENTROOT_TITLE_FEATURE_ID);
  }

  /**
   * Returns the {@link EStructuralFeature} '<em><b>DocumentRoot.type</b></em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return an instance of the {@link EStructuralFeature}: '<em><b>DocumentRoot.type</b></em>'.
   * @generated
   */
  public EAttribute getDocumentRoot_Type() {
    return (EAttribute) getDocumentRootEClass().getEAllStructuralFeatures().get(DOCUMENTROOT_TYPE_FEATURE_ID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param eClassifier
   *            the {@link EClassifier}
   * @return the class implementing a specific {@link EClass}.
   * @generated
   */
  @Override
  public Class<?> getEClassifierClass(EClassifier eClassifier) {
    switch (eClassifier.getClassifierID()) {
    case DOCUMENTROOT_CLASSIFIER_ID:
      return DocumentRoot.class;
    }
    throw new IllegalArgumentException("The EClassifier '" + eClassifier + "' is not defined in this EPackage");
  }
}
