/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.ElementHandlerImpl;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.converter.EMFModelConverter;
import org.eclipse.emf.texo.xml.ModelXMIResourceImpl;
import org.eclipse.emf.texo.xml.ModelXMLResourceImpl;
import org.xml.sax.InputSource;

public class ModelXMLLoader
implements TexoComponent {
    private Reader reader;
    private XMLResource xmlResource;
    private Map<String, Object> options = new HashMap<String, Object>();
    private List<Object> modelObjects;
    private EMFModelConverter emfModelConverter = (EMFModelConverter)ComponentProvider.getInstance().newInstance(EMFModelConverter.class);
    private boolean loadAsXMI = false;

    public List<Object> read() {
        try {
            XMLResource localXMLResource = this.getXmlResource();
            this.setDefaultOptions("ENCODING", "UTF-8");
            if (!this.isLoadAsXMI()) {
                this.setDefaultOptions("EXTENDED_META_DATA", true);
                this.setDefaultOptions("SUPPRESS_DOCUMENT_ROOT", true);
                this.setDefaultOptions("SCHEMA_LOCATION", true);
                this.setDefaultOptions("USE_ENCODED_ATTRIBUTE_STYLE", true);
                this.setDefaultOptions("ELEMENT_HANDLER", new ElementHandlerImpl(true));
                this.setDefaultOptions("USE_LEXICAL_HANDLER", true);
            }
            this.setDefaultOptions("SAVE_TYPE_INFORMATION", true);
            this.setDefaultOptions("RECORD_ANY_TYPE_NAMESPACE_DECLARATIONS", true);
            localXMLResource.load(new InputSource(this.getReader()), this.options);
            this.getEMFModelConverter().getUriResolver().setUseWebServiceUriFormat(true);
            return this.getEMFModelConverter().convert((List)localXMLResource.getContents());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setDefaultOptions(String option, Object value) {
        if (this.options.get(option) != null) {
            return;
        }
        this.options.put(option, value);
    }

    public XMLResource getXmlResource() {
        ResourceSet resourceSet = (ResourceSet)ComponentProvider.getInstance().newInstance(ResourceSetImpl.class);
        if (this.xmlResource == null) {
            this.xmlResource = this.loadAsXMI ? (XMLResource)ComponentProvider.getInstance().newInstance(ModelXMIResourceImpl.class) : (XMLResource)ComponentProvider.getInstance().newInstance(ModelXMLResourceImpl.class);
        }
        resourceSet.getResources().add((Object)this.xmlResource);
        return this.xmlResource;
    }

    public void setXmlResource(XMLResource xmlResource) {
        this.xmlResource = xmlResource;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public List<Object> getModelObjects() {
        return this.modelObjects;
    }

    public void setModelObjects(List<Object> modelObjects) {
        this.modelObjects = modelObjects;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public EMFModelConverter getEMFModelConverter() {
        return this.emfModelConverter;
    }

    public void setEMFModelConverter(EMFModelConverter emfModelConverter) {
        this.emfModelConverter = emfModelConverter;
    }

    public boolean isLoadAsXMI() {
        return this.loadAsXMI;
    }

    public void setLoadAsXMI(boolean loadAsXMI) {
        this.loadAsXMI = loadAsXMI;
    }
}

