/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.ElementHandlerImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.converter.ModelEMFConverter;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.provider.TitleProvider;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.eclipse.emf.texo.xml.ModelXMIResourceImpl;
import org.eclipse.emf.texo.xml.ModelXMLResourceImpl;
import org.eclipse.emf.texo.xml.model.texoextensions.TexoExtensionsModelPackage;

public class ModelXMLSaver
implements TexoComponent {
    private Writer writer;
    private XMLResource xmlResource;
    private Map<String, Object> options = new HashMap<String, Object>();
    private List<Object> objects;
    private ModelEMFConverter modelEMFConverter = (ModelEMFConverter)ComponentProvider.getInstance().newInstance(ModelEMFConverter.class);
    private boolean saveAsXMI = false;
    private boolean objectsAreAlreadyEObjects = false;
    private boolean outputExtensionAttributes = false;

    public void write() {
        try {
            ArrayList<EObject> eObjects;
            XMLResource localXMLResource = this.getXmlResource();
            if (this.isObjectsAreAlreadyEObjects()) {
                eObjects = new ArrayList();
                for (Object o : this.getObjects()) {
                    eObjects.add((EObject)o);
                }
            } else {
                eObjects = this.getModelEMFConverter().convert(this.getObjects());
            }
            this.addObjectsToRoot(eObjects);
            localXMLResource.getContents().addAll(eObjects);
            if (this.isOutputExtensionAttributes()) {
                this.addExtensionAttributes();
            }
            if (!this.isSaveAsXMI()) {
                this.setDefaultOptions("ENCODING", "UTF-8");
                this.setDefaultOptions("SUPPRESS_DOCUMENT_ROOT", true);
                this.setDefaultOptions("EXTENDED_META_DATA", true);
                this.setDefaultOptions("SCHEMA_LOCATION", true);
                this.setDefaultOptions("USE_ENCODED_ATTRIBUTE_STYLE", true);
                this.setDefaultOptions("KEEP_DEFAULT_CONTENT", true);
                this.setDefaultOptions("ELEMENT_HANDLER", ComponentProvider.getInstance().newInstance(ElementHandlerImpl.class, new Class[]{Boolean.TYPE}, new Object[]{false}));
            }
            this.setDefaultOptions("SAVE_TYPE_INFORMATION", true);
            localXMLResource.save(this.writer, this.getOptions());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addExtensionAttributes() {
        for (Object object : this.modelEMFConverter.getObjectMapping().keySet()) {
            if (!ModelResolver.getInstance().isModelEnabled(object)) continue;
            ModelObject modelObject = ModelResolver.getInstance().getModelObject(object);
            AnyType anyType = XMLTypeFactory.eINSTANCE.createAnyType();
            if (IdProvider.getInstance().hasIdEAttribute(object)) {
                anyType.getAnyAttribute().add((EStructuralFeature)TexoExtensionsModelPackage.INSTANCE.getDocumentRoot_Id(), (Object)IdProvider.getInstance().getIdAsString(object));
            }
            String title = TitleProvider.getInstance().getTitle(object);
            anyType.getAnyAttribute().add((EStructuralFeature)TexoExtensionsModelPackage.INSTANCE.getDocumentRoot_Title(), (Object)title);
            String type = ModelUtils.getQualifiedNameFromEClass((EClass)modelObject.eClass());
            anyType.getAnyAttribute().add((EStructuralFeature)TexoExtensionsModelPackage.INSTANCE.getDocumentRoot_Type(), (Object)type);
            EObject eObject = (EObject)this.modelEMFConverter.getObjectMapping().get(object);
            this.xmlResource.getEObjectToExtensionMap().put(eObject, anyType);
        }
    }

    private void addObjectsToRoot(List<EObject> rootObjects) {
        HashMap<EObject, EObject> visited = new HashMap<EObject, EObject>();
        for (EObject eObject : new ArrayList<EObject>(rootObjects)) {
            this.visit(eObject, visited, rootObjects);
        }
    }

    private void visit(EObject eObject, HashMap<EObject, EObject> visited, List<EObject> rootObjects) {
        if (visited.containsKey(eObject)) {
            return;
        }
        visited.put(eObject, eObject);
        if (eObject.eIsProxy()) {
            return;
        }
        if (eObject.eContainer() == null && !rootObjects.contains(eObject)) {
            rootObjects.add(eObject);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (eReference.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)eReference);
                for (EObject refEObject : list) {
                    this.visit(refEObject, visited, rootObjects);
                }
                continue;
            }
            EObject refEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
            if (refEObject == null) continue;
            this.visit(refEObject, visited, rootObjects);
        }
    }

    protected void setDefaultOptions(String option, Object value) {
        if (this.getOptions().get(option) != null) {
            return;
        }
        this.getOptions().put(option, value);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public XMLResource getXmlResource() {
        if (this.xmlResource == null) {
            this.xmlResource = this.saveAsXMI ? (XMLResource)ComponentProvider.getInstance().newInstance(ModelXMIResourceImpl.class) : (XMLResource)ComponentProvider.getInstance().newInstance(ModelXMLResourceImpl.class);
        }
        return this.xmlResource;
    }

    public void setXmlResource(XMLResource xmlResource) {
        this.xmlResource = xmlResource;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    public ModelEMFConverter getModelEMFConverter() {
        return this.modelEMFConverter;
    }

    public void setModelEMFConverter(ModelEMFConverter modelEMFConverter) {
        this.modelEMFConverter = modelEMFConverter;
    }

    public boolean isSaveAsXMI() {
        return this.saveAsXMI;
    }

    public void setSaveAsXMI(boolean saveAsXMI) {
        this.saveAsXMI = saveAsXMI;
    }

    public boolean isOutputExtensionAttributes() {
        return this.outputExtensionAttributes;
    }

    public void setOutputExtensionAttributes(boolean outputExtensionAttributes) {
        this.outputExtensionAttributes = outputExtensionAttributes;
    }

    protected boolean isObjectsAreAlreadyEObjects() {
        return this.objectsAreAlreadyEObjects;
    }

    public void setObjectsAreAlreadyEObjects(boolean objectsAreAlreadyEObjects) {
        this.objectsAreAlreadyEObjects = objectsAreAlreadyEObjects;
    }
}

