/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.converter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.texo.converter.BaseModelConverter;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

public class ModelEMFConverter
extends BaseModelConverter<Object> {
    private Object lastObject = null;
    private ModelObject<?> lastModelObject = null;
    private Map<Object, InternalEObject> objectMapping = new HashMap<Object, InternalEObject>();
    private List<Object> toConvert = new ArrayList<Object>();
    private List<Object> converted = new ArrayList<Object>();
    private List<ManyToMany> toRepairManyToMany = new ArrayList<ManyToMany>();

    public List<EObject> convert(List<Object> objects) {
        this.setSkipVolatileEFeatures(true);
        this.doBaseActions(objects);
        ArrayList<EObject> result = new ArrayList<EObject>();
        Check.isNotNullArgument(objects, "objects");
        for (Object object : objects) {
            result.add(this.createTarget(object));
        }
        while (!this.toConvert.isEmpty()) {
            ArrayList<Object> beingConverted = new ArrayList<Object>(this.toConvert);
            this.toConvert.clear();
            for (Object object : beingConverted) {
                this.convertContent(object);
                this.converted.add(object);
            }
        }
        for (ManyToMany mtm : this.toRepairManyToMany) {
            mtm.repair();
        }
        this.toRepairManyToMany.clear();
        return result;
    }

    protected EObject createTarget(Object target) {
        InternalEObject eObject = this.objectMapping.get(target);
        if (eObject == null) {
            eObject = (InternalEObject)this.getObjectResolver().resolveToEObject(target);
            this.objectMapping.put(target, eObject);
        }
        if (!this.converted.contains(target) && !this.toConvert.contains(target)) {
            this.toConvert.add(target);
        }
        return eObject;
    }

    protected void convertContent(Object target) {
        InternalEObject eObject = this.objectMapping.get(target);
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(target);
        if (this.getProxyObjects().contains(target)) {
            URI proxyURI = this.getProxyId(modelObject);
            if (proxyURI != null) {
                eObject.eSetProxyURI(proxyURI);
            }
            return;
        }
        for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
            EReference eReference;
            EAttribute eAttribute;
            if (!eStructuralFeature.isChangeable() || eStructuralFeature.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                this.convertFeatureMap(modelObject, (EObject)eObject, eStructuralFeature);
                continue;
            }
            if (eStructuralFeature.isMany()) {
                if (eStructuralFeature instanceof EAttribute) {
                    eAttribute = (EAttribute)eStructuralFeature;
                    this.convertManyEAttribute(modelObject, (EObject)eObject, eAttribute);
                    continue;
                }
                eReference = (EReference)eStructuralFeature;
                this.convertManyEReference(modelObject, (EObject)eObject, eReference);
                continue;
            }
            if (eStructuralFeature instanceof EAttribute) {
                eAttribute = (EAttribute)eStructuralFeature;
                this.convertSingleEAttribute(modelObject, (EObject)eObject, eAttribute);
                continue;
            }
            eReference = (EReference)eStructuralFeature;
            this.convertSingleEReference(modelObject, (EObject)eObject, eReference);
        }
    }

    protected void convertFeatureMap(ModelObject<?> modelObject, EObject eObject, EStructuralFeature eFeature) {
        Collection mValues = (Collection)modelObject.eGet(eFeature);
        Collection values = (Collection)eObject.eGet(eFeature);
        for (Object mValue : mValues) {
            ModelFeatureMapEntry<?> mEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, mValue);
            EStructuralFeature entryFeature = mEntry.getEStructuralFeature();
            Object entryValue = mEntry.getValue();
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)entryFeature)) {
                ModelFeatureMapEntry<?> modelFeatureMapEntry = ModelResolver.getInstance().getModelFeatureMapEntry(entryFeature, entryValue);
                entryFeature = ModelUtils.findFeature(modelFeatureMapEntry);
                entryValue = ModelUtils.findValue(modelFeatureMapEntry);
            }
            Object convertedValue = entryFeature instanceof EAttribute ? this.convertEAttributeValue(entryValue, ((EAttribute)entryFeature).getEAttributeType()) : this.createTarget(entryValue);
            FeatureMap.Entry eEntry = FeatureMapUtil.createEntry((EStructuralFeature)entryFeature, (Object)convertedValue);
            values.add(eEntry);
        }
    }

    protected void convertSingleEReference(ModelObject<?> modelObject, EObject eObject, EReference eReference) {
        if (eReference.isContainer()) {
            return;
        }
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            return;
        }
        Object value = modelObject.eGet((EStructuralFeature)eReference);
        if (value == null) {
            eObject.eSet((EStructuralFeature)eReference, null);
        } else {
            InternalEObject eValue = (InternalEObject)this.createTarget(value);
            eObject.eSet((EStructuralFeature)eReference, (Object)eValue);
        }
    }

    protected void convertManyEReference(ModelObject<?> modelObject, EObject eObject, EReference eReference) {
        if (eReference.isContainer()) {
            return;
        }
        Object manyValue = modelObject.eGet((EStructuralFeature)eReference);
        ArrayList<Object> newValues = new ArrayList<Object>();
        boolean isMap = Map.class.isAssignableFrom(manyValue.getClass());
        EStructuralFeature valueFeature = null;
        EStructuralFeature keyFeature = null;
        if (isMap) {
            EClass mapEClass = eReference.getEReferenceType();
            valueFeature = mapEClass.getEStructuralFeature("value");
            keyFeature = mapEClass.getEStructuralFeature("key");
            Check.isTrue(ModelUtils.isEMap((EStructuralFeature)eReference), "Expected emap EReference, but th// case for EReference " + eReference);
            Map map = (Map)manyValue;
            for (Iterator<Object> key : map.keySet()) {
                Object value = map.get(key);
                EObject mapEntryEObject = EcoreUtil.create((EClass)mapEClass);
                if (valueFeature instanceof EReference) {
                    mapEntryEObject.eSet(valueFeature, (Object)this.createTarget(value));
                } else {
                    mapEntryEObject.eSet(valueFeature, value);
                }
                if (keyFeature instanceof EReference) {
                    mapEntryEObject.eSet(keyFeature, (Object)this.createTarget(key));
                } else {
                    mapEntryEObject.eSet(keyFeature, key);
                }
                newValues.add(mapEntryEObject);
            }
        } else {
            if (eReference.getEOpposite() != null && eReference.getEOpposite().isMany()) {
                ManyToMany mtm = new ManyToMany();
                mtm.setOwner(modelObject);
                mtm.setEReference(eReference);
                this.toRepairManyToMany.add(mtm);
            }
            Collection values = (Collection)manyValue;
            for (Object value : values) {
                if (value == null) {
                    newValues.add(null);
                    continue;
                }
                InternalEObject internalEObject = (InternalEObject)this.createTarget(value);
                if (newValues.contains(internalEObject)) continue;
                newValues.add(internalEObject);
            }
        }
        Collection eValues = (Collection)eObject.eGet((EStructuralFeature)eReference);
        boolean updateList = false;
        if (newValues.size() == eValues.size()) {
            Iterator it = eValues.iterator();
            for (Object e : newValues) {
                Object oldValue = it.next();
                if (isMap) {
                    EObject oldMapEntry = (EObject)oldValue;
                    EObject newMapEntry = (EObject)e;
                    Object oldMapValue = oldMapEntry.eGet(valueFeature);
                    Object oldMapKey = oldMapEntry.eGet(keyFeature);
                    Object newMapValue = newMapEntry.eGet(valueFeature);
                    Object newMapKey = newMapEntry.eGet(keyFeature);
                    if (valueFeature instanceof EReference) {
                        updateList = oldMapValue == newMapValue;
                    } else {
                        boolean bl = oldMapValue != null ? !oldMapValue.equals(newMapValue) : (newMapValue != null ? !newMapValue.equals(oldMapValue) : (updateList = false));
                    }
                    updateList = keyFeature instanceof EReference ? updateList || oldMapKey == newMapKey : updateList || !(oldMapKey != null ? oldMapKey.equals(newMapKey) : newMapKey == null || newMapKey.equals(oldMapKey));
                } else {
                    boolean bl = updateList = oldValue != e;
                }
                if (!updateList) {
                    continue;
                }
                break;
            }
        } else {
            updateList = true;
        }
        if (updateList) {
            eValues.clear();
            eValues.addAll(newValues);
        }
    }

    protected void convertSingleEAttribute(ModelObject<?> modelObject, EObject eObject, EAttribute eAttribute) {
        Object value = modelObject.eGet((EStructuralFeature)eAttribute);
        if (value == null && ModelUtils.isUnsettable((EStructuralFeature)eAttribute)) {
            eObject.eUnset((EStructuralFeature)eAttribute);
            return;
        }
        Object newValue = this.convertEAttributeValue(value, eAttribute.getEAttributeType());
        ((InternalEObject)eObject).eSet((EStructuralFeature)eAttribute, newValue);
    }

    protected void convertManyEAttribute(ModelObject<?> modelObject, EObject eObject, EAttribute eAttribute) {
        Collection values = (Collection)modelObject.eGet((EStructuralFeature)eAttribute);
        EDataType eDataType = eAttribute.getEAttributeType();
        List eValues = (List)eObject.eGet((EStructuralFeature)eAttribute);
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (Object value : values) {
            newValues.add(this.convertEAttributeValue(value, eDataType));
        }
        boolean updateList = false;
        if (values.size() == eValues.size()) {
            Iterator it = eValues.iterator();
            for (Object e : newValues) {
                Object oldValue = it.next();
                if (e != null && oldValue == null) {
                    updateList = true;
                } else if (oldValue == null && e != null) {
                    updateList = true;
                } else if (oldValue != null && e != null) {
                    boolean bl = updateList = !oldValue.equals(e);
                }
                if (!updateList) {
                    continue;
                }
                break;
            }
        } else {
            updateList = true;
        }
        if (updateList) {
            eValues.clear();
            eValues.addAll(newValues);
        }
    }

    protected Object convertEAttributeValue(Object value, EDataType eDataType) {
        Date date;
        if (value instanceof Enum) {
            EDataType enumDataType = this.getDataTypeOrBaseType(eDataType);
            Check.isInstanceOf(enumDataType, EEnum.class);
            EEnum eeNum = (EEnum)enumDataType;
            for (EEnumLiteral enumLiteral : eeNum.getELiterals()) {
                if (!enumLiteral.getName().toUpperCase(Locale.ENGLISH).equals(((Enum)value).name())) continue;
                return enumLiteral.getInstance();
            }
        }
        if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getDate()) {
            date = (Date)value;
            XMLCalendar xmlCalendar = new XMLCalendar(date, 2);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            xmlCalendar.clear();
            xmlCalendar.setYear(calendar.get(1));
            xmlCalendar.setMonth(1 + calendar.get(2));
            xmlCalendar.setDay(calendar.get(5));
            xmlCalendar.setTimezone(calendar.get(15) / 60000);
            return xmlCalendar;
        }
        if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
            date = (Date)value;
            return new XMLCalendar(date, 0);
        }
        return value;
    }

    public Map<Object, InternalEObject> getObjectMapping() {
        return this.objectMapping;
    }

    public void setObjectMapping(Map<Object, InternalEObject> objectMapping) {
        this.objectMapping = objectMapping;
    }

    public List<Object> getConverted() {
        return this.converted;
    }

    public void setConverted(List<Object> converted) {
        this.converted = converted;
    }

    private ModelObject<?> getModelObject(Object target) {
        if (target == this.lastObject) {
            return this.lastModelObject;
        }
        this.lastObject = target;
        this.lastModelObject = ModelResolver.getInstance().getModelObject(target);
        return this.lastModelObject;
    }

    @Override
    protected EClass eClass(Object target) {
        return this.getModelObject(target).eClass();
    }

    @Override
    protected Object eGet(Object target, EStructuralFeature eFeature) {
        return this.getModelObject(target).eGet(eFeature);
    }

    @Override
    protected boolean isModelEnabled(Object target) {
        return ModelResolver.getInstance().isModelEnabled(target);
    }

    @Override
    protected boolean doSkipNotChangeAbleFeatures() {
        return true;
    }

    @Override
    public boolean isSkipVolatileEFeatures() {
        return true;
    }

    private class ManyToMany {
        private ModelObject<?> owner;
        private EReference eReference;

        private ManyToMany() {
        }

        public void repair() {
            EObject eObjectOwner = (EObject)ModelEMFConverter.this.objectMapping.get(this.owner.getTarget());
            ModelObject<?> modelObjectOwner = ModelResolver.getInstance().getModelObject(this.owner);
            Object listObject = modelObjectOwner.eGet((EStructuralFeature)this.eReference);
            if (!(listObject instanceof List)) {
                return;
            }
            EList eList = (EList)eObjectOwner.eGet((EStructuralFeature)this.eReference);
            List list = (List)listObject;
            int correctIndex = 0;
            for (Object objectElement : list) {
                EObject eObjectElement = (EObject)ModelEMFConverter.this.objectMapping.get(objectElement);
                int newIndex = eList.indexOf((Object)eObjectElement);
                if (newIndex != correctIndex) {
                    eList.move(correctIndex, newIndex);
                }
                ++correctIndex;
            }
        }

        public void setOwner(ModelObject<?> owner) {
            this.owner = owner;
        }

        public void setEReference(EReference eReference) {
            this.eReference = eReference;
        }
    }
}

