/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.ModelFactory;
import org.eclipse.emf.texo.utils.ModelUtils;

public class ModelEFactory
implements EFactory,
InternalEObject,
TexoComponent {
    private EFactoryImpl delegate;
    private boolean isDynamicEFactory = false;
    private ModelFactory modelFactory;

    public String convertToString(EDataType dataType, Object objectValue) {
        if (this.isDynamicEFactory) {
            if (objectValue instanceof Enumerator) {
                Enumerator enumerator = (Enumerator)objectValue;
                return enumerator.getLiteral();
            }
            if (objectValue instanceof EEnumLiteral) {
                EEnumLiteral eEnumLiteral = (EEnumLiteral)objectValue;
                return eEnumLiteral.getLiteral();
            }
            return this.modelFactory.convertToString(dataType, objectValue);
        }
        return this.delegate.convertToString(dataType, objectValue);
    }

    public Object createFromString(EDataType dataType, String stringValue) {
        if (!this.isDynamicEFactory) {
            return this.delegate.createFromString(dataType, stringValue);
        }
        if (dataType instanceof EEnum) {
            if (stringValue == null || stringValue.trim().length() == 0) {
                return null;
            }
            return ((EEnum)dataType).getEEnumLiteralByLiteral(stringValue);
        }
        EEnum baseType = ModelUtils.getEnumBaseDataTypeIfObject(dataType);
        if (baseType != null && baseType instanceof EEnum) {
            if (stringValue == null || stringValue.trim().length() == 0) {
                return null;
            }
            EEnum eeNum = baseType;
            EEnumLiteral eeNumLiteral = eeNum.getEEnumLiteralByLiteral(stringValue);
            if (eeNumLiteral == null) {
                eeNumLiteral = eeNum.getEEnumLiteral(stringValue);
            }
            if (eeNumLiteral == null) {
                throw new IllegalArgumentException("The value '" + stringValue + "' is not a valid enumerator of '" + dataType.getName() + "'");
            }
            return eeNumLiteral;
        }
        return this.modelFactory.createFromString(dataType, stringValue);
    }

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public EFactory getDelegateEFactory() {
        return this.delegate;
    }

    public EObject create(EClass eClass) {
        if (this.isDynamicEFactory) {
            return eClass.getInstanceClassName() == "java.util.Map$Entry" ? new DynamicEObjectImpl.BasicEMapEntry(eClass) : new DynamicEObjectImpl(eClass);
        }
        return this.delegate.create(eClass);
    }

    public EList<Adapter> eAdapters() {
        return this.delegate.eAdapters();
    }

    public boolean eDeliver() {
        return this.delegate.eDeliver();
    }

    public EList<EAnnotation> getEAnnotations() {
        return this.delegate.getEAnnotations();
    }

    public void eSetDeliver(boolean deliver) {
        this.delegate.eSetDeliver(deliver);
    }

    public EPackage getEPackage() {
        return this.delegate.getEPackage();
    }

    public void eNotify(Notification notification) {
        this.delegate.eNotify(notification);
    }

    public EAnnotation getEAnnotation(String source) {
        return this.delegate.getEAnnotation(source);
    }

    public void setEPackage(EPackage value) {
        this.delegate = (EFactoryImpl)value.getEFactoryInstance();
        this.isDynamicEFactory = this.delegate.getClass() == EFactoryImpl.class;
    }

    public EClass eClass() {
        return this.delegate.eClass();
    }

    public Resource eResource() {
        return this.delegate.eResource();
    }

    public EObject eContainer() {
        return this.delegate.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.delegate.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.delegate.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.delegate.eContents();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.delegate.eAllContents();
    }

    public boolean eIsProxy() {
        return this.delegate.eIsProxy();
    }

    public EList<EObject> eCrossReferences() {
        return this.delegate.eCrossReferences();
    }

    public Object eGet(EStructuralFeature feature) {
        return this.delegate.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.delegate.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.delegate.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.delegate.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.delegate.eUnset(feature);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) {
        try {
            Method method = this.delegate.getClass().getMethod("invoke", EOperation.class, EList.class);
            return method.invoke((Object)this.delegate, operation, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public NotificationChain basicSetEPackage(EPackage newEPackage, NotificationChain msgs) {
        return this.delegate.basicSetEPackage(newEPackage, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        return this.delegate.eGet(featureID, resolve, coreType);
    }

    public InternalEObject eInternalContainer() {
        return this.delegate.eInternalContainer();
    }

    public void eSet(int featureID, Object newValue) {
        this.delegate.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        this.delegate.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        return this.delegate.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) {
        try {
            Method method = this.delegate.getClass().getMethod("eInvoke", Integer.TYPE, EList.class);
            return method.invoke((Object)this.delegate, operationID, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        return this.delegate.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public boolean eNotificationRequired() {
        return this.delegate.eNotificationRequired();
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        return this.delegate.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    public URI eProxyURI() {
        return this.delegate.eProxyURI();
    }

    public void eSetProxyURI(URI uri) {
        this.delegate.eSetProxyURI(uri);
    }

    public int eContainerFeatureID() {
        return this.delegate.eContainerFeatureID();
    }

    public void eSetClass(EClass eClass) {
        this.delegate.eSetClass(eClass);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        return this.delegate.eInverseAdd(otherEnd, featureID, msgs);
    }

    public Resource.Internal eDirectResource() {
        return this.delegate.eDirectResource();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        return this.delegate.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object dynamicGet(int dynamicFeatureID) {
        return this.delegate.dynamicGet(dynamicFeatureID);
    }

    public void dynamicSet(int dynamicFeatureID, Object newValue) {
        this.delegate.dynamicSet(dynamicFeatureID, newValue);
    }

    public void dynamicUnset(int dynamicFeatureID) {
        this.delegate.dynamicUnset(dynamicFeatureID);
    }

    public boolean eContains(EObject eObject) {
        return this.delegate.eContains(eObject);
    }

    public Resource.Internal eInternalResource() {
        return this.delegate.eInternalResource();
    }

    public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
        return this.delegate.eSetResource(resource, notifications);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve, boolean coreType) {
        return this.delegate.eGet(eFeature, resolve, coreType);
    }

    public Object eDynamicGet(EStructuralFeature eFeature, boolean resolve) {
        return this.delegate.eDynamicGet(eFeature, resolve);
    }

    public Object eDynamicGet(int featureID, boolean resolve, boolean coreType) {
        return this.delegate.eDynamicGet(featureID, resolve, coreType);
    }

    public Object eOpenGet(EStructuralFeature eFeature, boolean resolve) {
        return this.delegate.eOpenGet(eFeature, resolve);
    }

    public void eDynamicSet(EStructuralFeature eFeature, Object newValue) {
        this.delegate.eDynamicSet(eFeature, newValue);
    }

    public void eDynamicSet(int featureID, Object newValue) {
        this.delegate.eDynamicSet(featureID, newValue);
    }

    public void eOpenSet(EStructuralFeature eFeature, Object newValue) {
        this.delegate.eOpenSet(eFeature, newValue);
    }

    public void eDynamicUnset(EStructuralFeature eFeature) {
        this.delegate.eDynamicUnset(eFeature);
    }

    public void eDynamicUnset(int featureID) {
        this.delegate.eDynamicUnset(featureID);
    }

    public void eOpenUnset(EStructuralFeature eFeature) {
        this.delegate.eOpenUnset(eFeature);
    }

    public boolean eDynamicIsSet(EStructuralFeature eFeature) {
        return this.delegate.eDynamicIsSet(eFeature);
    }

    public boolean eDynamicIsSet(int featureID) {
        return this.delegate.eDynamicIsSet(featureID);
    }

    public boolean eOpenIsSet(EStructuralFeature eFeature) {
        return this.delegate.eOpenIsSet(eFeature);
    }

    public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain msgs) {
        return this.delegate.eBasicSetContainer(newContainer, newContainerFeatureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        return this.delegate.eBasicRemoveFromContainer(msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        return this.delegate.eBasicRemoveFromContainerFeature(msgs);
    }

    public NotificationChain eDynamicBasicRemoveFromContainer(NotificationChain msgs) {
        return this.delegate.eDynamicBasicRemoveFromContainer(msgs);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        return this.delegate.eInverseAdd(otherEnd, featureID, baseClass, msgs);
    }

    public NotificationChain eDynamicInverseAdd(InternalEObject otherEnd, int featureID, Class<?> inverseClass, NotificationChain msgs) {
        return this.delegate.eDynamicInverseAdd(otherEnd, featureID, inverseClass, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        return this.delegate.eInverseRemove(otherEnd, featureID, baseClass, msgs);
    }

    public NotificationChain eDynamicInverseRemove(InternalEObject otherEnd, int featureID, Class<?> inverseClass, NotificationChain msgs) {
        return this.delegate.eDynamicInverseRemove(otherEnd, featureID, inverseClass, msgs);
    }

    public EObject eResolveProxy(InternalEObject proxy) {
        return this.delegate.eResolveProxy(proxy);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        return this.delegate.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        return this.delegate.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(EStructuralFeature eStructuralFeature) {
        return this.delegate.eDerivedStructuralFeatureID(eStructuralFeature);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        try {
            Method method = this.delegate.getClass().getMethod("eDerivedOperationID", Integer.TYPE, Class.class);
            return (Integer)method.invoke((Object)this.delegate, baseOperationID, baseClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public int eDerivedOperationID(EOperation eOperation) {
        try {
            Method method = this.delegate.getClass().getMethod("eDerivedOperationID", EOperation.class);
            return (Integer)method.invoke((Object)this.delegate, eOperation);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public EStructuralFeature.Setting eSetting(EStructuralFeature eFeature) {
        return this.delegate.eSetting(eFeature);
    }

    public InternalEObject.EStore eStore() {
        return this.delegate.eStore();
    }

    public void eSetStore(InternalEObject.EStore store) {
        this.delegate.eSetStore(store);
    }

    public Object eVirtualGet(int eDerivedStructuralFeatureID) {
        return this.delegate.eVirtualGet(eDerivedStructuralFeatureID);
    }

    public Object eVirtualGet(int eDerivedStructuralFeatureID, Object defaultValue) {
        return this.delegate.eVirtualGet(eDerivedStructuralFeatureID, defaultValue);
    }

    public boolean eVirtualIsSet(int eDerivedStructuralFeatureID) {
        return this.delegate.eVirtualIsSet(eDerivedStructuralFeatureID);
    }

    public Object eVirtualSet(int eDerivedStructuralFeatureID, Object value) {
        return this.delegate.eVirtualSet(eDerivedStructuralFeatureID, value);
    }

    public Object eVirtualUnset(int eDerivedStructuralFeatureID) {
        return this.delegate.eVirtualUnset(eDerivedStructuralFeatureID);
    }

    public Object eDynamicInvoke(int operationID, EList<?> arguments) {
        try {
            Method method = this.delegate.getClass().getMethod("eDynamicInvoke", Integer.TYPE, EList.class);
            return method.invoke((Object)this.delegate, operationID, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static class EFactoryInvocationHandler
    implements InvocationHandler {
        private final ModelEFactory modelEFactory;

        public EFactoryInvocationHandler(ModelEFactory modelEFactory) {
            this.modelEFactory = modelEFactory;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.modelEFactory, args);
        }
    }
}

